/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CascadeParticle
extends TextureSheetParticle {
    protected final SpriteSet provider;

    protected CascadeParticle(ClientLevel clientWorld, double x, double y, double z, SpriteSet provider) {
        super(clientWorld, x, y, z);
        this.provider = provider;
        this.lifetime = 9;
        this.quadSize = 1.0f;
        this.gravity = 0.4f;
        this.setParticleSpeed(this.random.nextDouble() * 0.25 - 0.125, 0.0, this.random.nextDouble() * 0.25 - 0.125);
        this.setSpriteFromAge(provider);
        this.removeIfInsideSolidBlock();
    }

    public void tick() {
        super.tick();
        this.removeIfInsideSolidBlock();
        this.setSpriteFromAge(this.provider);
    }

    private void removeIfInsideSolidBlock() {
        BlockPos pos = BlockPos.containing((Position)new Vec3(this.x, this.y, this.z));
        if (this.level.getBlockState(pos).isRedstoneConductor((BlockGetter)this.level, pos)) {
            this.alpha = 0.0f;
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            return new CascadeParticle(world, x, y, z, this.provider);
        }
    }
}

