/*
 * Decompiled with CFR 0.152.
 */
package com.shim.secretdoors.registry;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SDBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"secretdoors");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"secretdoors");
    public static final Map<DeferredBlock<? extends Block>, String> BLOCK_LANG_EN_US = new HashMap<DeferredBlock<? extends Block>, String>();
    public static final LinkedList<DeferredBlock<? extends Block>> DOOR_LOOT_TABLE = new LinkedList();
    public static final LinkedList<DeferredBlock<? extends Block>> TRAPDOOR_LOOT_TABLE = new LinkedList();
    public static final LinkedList<DeferredBlock<? extends Block>> BUILDING_BLOCKS_CREATIVE_TAB = new LinkedList();
    public static final DeferredBlock<DoorBlock> SECRET_OAK_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.OAK, () -> SDBlocks.doorBlock(Blocks.OAK_PLANKS, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_DARK_OAK_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.DARK_OAK, () -> SDBlocks.doorBlock(Blocks.DARK_OAK_PLANKS, BlockSetType.DARK_OAK));
    public static final DeferredBlock<DoorBlock> SECRET_SPRUCE_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.SPRUCE, () -> SDBlocks.doorBlock(Blocks.SPRUCE_PLANKS, BlockSetType.SPRUCE));
    public static final DeferredBlock<DoorBlock> SECRET_ACACIA_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.ACACIA, () -> SDBlocks.doorBlock(Blocks.ACACIA_PLANKS, BlockSetType.ACACIA));
    public static final DeferredBlock<DoorBlock> SECRET_BIRCH_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.BIRCH, () -> SDBlocks.doorBlock(Blocks.BIRCH_PLANKS, BlockSetType.BIRCH));
    public static final DeferredBlock<DoorBlock> SECRET_JUNGLE_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.JUNGLE, () -> SDBlocks.doorBlock(Blocks.JUNGLE_PLANKS, BlockSetType.JUNGLE));
    public static final DeferredBlock<DoorBlock> SECRET_MANGROVE_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.MANGROVE, () -> SDBlocks.doorBlock(Blocks.MANGROVE_PLANKS, BlockSetType.MANGROVE));
    public static final DeferredBlock<DoorBlock> SECRET_CHERRY_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.CHERRY, () -> SDBlocks.doorBlock(Blocks.CHERRY_PLANKS, BlockSetType.CHERRY));
    public static final DeferredBlock<DoorBlock> SECRET_BAMBOO_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.BAMBOO, () -> SDBlocks.doorBlock(Blocks.BAMBOO_PLANKS, BlockSetType.BAMBOO));
    public static final DeferredBlock<DoorBlock> SECRET_CRIMSON_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.CRIMSON, () -> SDBlocks.doorBlock(Blocks.CRIMSON_PLANKS, BlockSetType.CRIMSON));
    public static final DeferredBlock<DoorBlock> SECRET_WARPED_PLANK_DOOR = SDBlocks.registerPlankDoorBlock(WoodType.WARPED, () -> SDBlocks.doorBlock(Blocks.WARPED_PLANKS, BlockSetType.WARPED));
    public static final DeferredBlock<DoorBlock> SECRET_OAK_LOG_DOOR = SDBlocks.registerLogDoorBlock(WoodType.OAK, () -> SDBlocks.doorBlock(Blocks.OAK_PLANKS, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_DARK_OAK_LOG_DOOR = SDBlocks.registerLogDoorBlock(WoodType.DARK_OAK, () -> SDBlocks.doorBlock(Blocks.DARK_OAK_LOG, BlockSetType.DARK_OAK));
    public static final DeferredBlock<DoorBlock> SECRET_SPRUCE_LOG_DOOR = SDBlocks.registerLogDoorBlock(WoodType.SPRUCE, () -> SDBlocks.doorBlock(Blocks.SPRUCE_LOG, BlockSetType.SPRUCE));
    public static final DeferredBlock<DoorBlock> SECRET_ACACIA_LOG_DOOR = SDBlocks.registerLogDoorBlock(WoodType.ACACIA, () -> SDBlocks.doorBlock(Blocks.ACACIA_LOG, BlockSetType.ACACIA));
    public static final DeferredBlock<DoorBlock> SECRET_BIRCH_LOG_DOOR = SDBlocks.registerLogDoorBlock(WoodType.BIRCH, () -> SDBlocks.doorBlock(Blocks.BIRCH_LOG, BlockSetType.BIRCH));
    public static final DeferredBlock<DoorBlock> SECRET_JUNGLE_LOG_DOOR = SDBlocks.registerLogDoorBlock(WoodType.JUNGLE, () -> SDBlocks.doorBlock(Blocks.JUNGLE_LOG, BlockSetType.JUNGLE));
    public static final DeferredBlock<DoorBlock> SECRET_MANGROVE_LOG_DOOR = SDBlocks.registerLogDoorBlock(WoodType.MANGROVE, () -> SDBlocks.doorBlock(Blocks.MANGROVE_LOG, BlockSetType.MANGROVE));
    public static final DeferredBlock<DoorBlock> SECRET_CHERRY_LOG_DOOR = SDBlocks.registerLogDoorBlock(WoodType.CHERRY, () -> SDBlocks.doorBlock(Blocks.CHERRY_LOG, BlockSetType.CHERRY));
    public static final DeferredBlock<DoorBlock> SECRET_BAMBOO_BLOCK_DOOR = SDBlocks.registerDoorBlock("bamboo_block", "Bamboo Block", () -> SDBlocks.doorBlock(Blocks.BAMBOO_BLOCK, BlockSetType.BAMBOO));
    public static final DeferredBlock<DoorBlock> SECRET_CRIMSON_STEM_DOOR = SDBlocks.registerStemDoorBlock(WoodType.CRIMSON, () -> SDBlocks.doorBlock(Blocks.CRIMSON_STEM, BlockSetType.BAMBOO));
    public static final DeferredBlock<DoorBlock> SECRET_WARPED_STEM_DOOR = SDBlocks.registerStemDoorBlock(WoodType.WARPED, () -> SDBlocks.doorBlock(Blocks.WARPED_STEM, BlockSetType.WARPED));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_OAK_LOG_DOOR = SDBlocks.registerStrippedLogDoorBlock(WoodType.OAK, () -> SDBlocks.doorBlock(Blocks.STRIPPED_OAK_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_DARK_OAK_LOG_DOOR = SDBlocks.registerStrippedLogDoorBlock(WoodType.DARK_OAK, () -> SDBlocks.doorBlock(Blocks.STRIPPED_DARK_OAK_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_SPRUCE_LOG_DOOR = SDBlocks.registerStrippedLogDoorBlock(WoodType.SPRUCE, () -> SDBlocks.doorBlock(Blocks.STRIPPED_SPRUCE_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_ACACIA_LOG_DOOR = SDBlocks.registerStrippedLogDoorBlock(WoodType.ACACIA, () -> SDBlocks.doorBlock(Blocks.STRIPPED_ACACIA_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_BIRCH_LOG_DOOR = SDBlocks.registerStrippedLogDoorBlock(WoodType.BIRCH, () -> SDBlocks.doorBlock(Blocks.STRIPPED_BIRCH_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_JUNGLE_LOG_DOOR = SDBlocks.registerStrippedLogDoorBlock(WoodType.JUNGLE, () -> SDBlocks.doorBlock(Blocks.STRIPPED_JUNGLE_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_MANGROVE_LOG_DOOR = SDBlocks.registerStrippedLogDoorBlock(WoodType.MANGROVE, () -> SDBlocks.doorBlock(Blocks.STRIPPED_MANGROVE_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_CHERRY_LOG_DOOR = SDBlocks.registerStrippedLogDoorBlock(WoodType.CHERRY, () -> SDBlocks.doorBlock(Blocks.STRIPPED_CHERRY_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_BAMBOO_BLOCK_DOOR = SDBlocks.registerDoorBlock("stripped_bamboo_block", "Stripped Bamboo Block", () -> SDBlocks.doorBlock(Blocks.STRIPPED_BAMBOO_BLOCK, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_CRIMSON_STEM_DOOR = SDBlocks.registerStrippedStemDoorBlock(WoodType.CRIMSON, () -> SDBlocks.doorBlock(Blocks.STRIPPED_CRIMSON_STEM, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_WARPED_STEM_DOOR = SDBlocks.registerStrippedStemDoorBlock(WoodType.WARPED, () -> SDBlocks.doorBlock(Blocks.STRIPPED_WARPED_STEM, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_OAK_LOG_DOOR = SDBlocks.registerStrippedHorizontalLogDoorBlock(WoodType.OAK, () -> SDBlocks.doorBlock(Blocks.STRIPPED_OAK_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_DARK_OAK_LOG_DOOR = SDBlocks.registerStrippedHorizontalLogDoorBlock(WoodType.DARK_OAK, () -> SDBlocks.doorBlock(Blocks.STRIPPED_DARK_OAK_LOG, BlockSetType.DARK_OAK));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_SPRUCE_LOG_DOOR = SDBlocks.registerStrippedHorizontalLogDoorBlock(WoodType.SPRUCE, () -> SDBlocks.doorBlock(Blocks.STRIPPED_SPRUCE_LOG, BlockSetType.SPRUCE));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_ACACIA_LOG_DOOR = SDBlocks.registerStrippedHorizontalLogDoorBlock(WoodType.ACACIA, () -> SDBlocks.doorBlock(Blocks.STRIPPED_ACACIA_LOG, BlockSetType.ACACIA));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_BIRCH_LOG_DOOR = SDBlocks.registerStrippedHorizontalLogDoorBlock(WoodType.BIRCH, () -> SDBlocks.doorBlock(Blocks.STRIPPED_BIRCH_LOG, BlockSetType.BIRCH));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_JUNGLE_LOG_DOOR = SDBlocks.registerStrippedHorizontalLogDoorBlock(WoodType.JUNGLE, () -> SDBlocks.doorBlock(Blocks.STRIPPED_JUNGLE_LOG, BlockSetType.JUNGLE));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_MANGROVE_LOG_DOOR = SDBlocks.registerStrippedHorizontalLogDoorBlock(WoodType.MANGROVE, () -> SDBlocks.doorBlock(Blocks.STRIPPED_MANGROVE_LOG, BlockSetType.MANGROVE));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_CHERRY_LOG_DOOR = SDBlocks.registerStrippedHorizontalLogDoorBlock(WoodType.CHERRY, () -> SDBlocks.doorBlock(Blocks.STRIPPED_CHERRY_LOG, BlockSetType.CHERRY));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_BAMBOO_BLOCK_DOOR = SDBlocks.registerDoorBlock("stripped_horizontal_bamboo_block", "Stripped Horizontal Bamboo Block", () -> SDBlocks.doorBlock(Blocks.STRIPPED_BAMBOO_BLOCK, BlockSetType.BAMBOO));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_CRIMSON_STEM_DOOR = SDBlocks.registerStrippedHorizontalStemDoorBlock(WoodType.CRIMSON, () -> SDBlocks.doorBlock(Blocks.STRIPPED_CRIMSON_STEM, BlockSetType.CRIMSON));
    public static final DeferredBlock<DoorBlock> SECRET_STRIPPED_HORIZONTAL_WARPED_STEM_DOOR = SDBlocks.registerStrippedHorizontalStemDoorBlock(WoodType.WARPED, () -> SDBlocks.doorBlock(Blocks.STRIPPED_WARPED_STEM, BlockSetType.WARPED));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_OAK_LOG_DOOR = SDBlocks.registerHorizontalLogDoorBlock(WoodType.OAK, () -> SDBlocks.doorBlock(Blocks.OAK_LOG, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_DARK_OAK_LOG_DOOR = SDBlocks.registerHorizontalLogDoorBlock(WoodType.DARK_OAK, () -> SDBlocks.doorBlock(Blocks.DARK_OAK_LOG, BlockSetType.DARK_OAK));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_SPRUCE_LOG_DOOR = SDBlocks.registerHorizontalLogDoorBlock(WoodType.SPRUCE, () -> SDBlocks.doorBlock(Blocks.SPRUCE_LOG, BlockSetType.SPRUCE));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_ACACIA_LOG_DOOR = SDBlocks.registerHorizontalLogDoorBlock(WoodType.ACACIA, () -> SDBlocks.doorBlock(Blocks.ACACIA_LOG, BlockSetType.ACACIA));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_BIRCH_LOG_DOOR = SDBlocks.registerHorizontalLogDoorBlock(WoodType.BIRCH, () -> SDBlocks.doorBlock(Blocks.BIRCH_LOG, BlockSetType.BIRCH));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_JUNGLE_LOG_DOOR = SDBlocks.registerHorizontalLogDoorBlock(WoodType.JUNGLE, () -> SDBlocks.doorBlock(Blocks.JUNGLE_LOG, BlockSetType.JUNGLE));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_MANGROVE_LOG_DOOR = SDBlocks.registerHorizontalLogDoorBlock(WoodType.MANGROVE, () -> SDBlocks.doorBlock(Blocks.MANGROVE_LOG, BlockSetType.MANGROVE));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_CHERRY_LOG_DOOR = SDBlocks.registerHorizontalLogDoorBlock(WoodType.CHERRY, () -> SDBlocks.doorBlock(Blocks.CHERRY_LOG, BlockSetType.CHERRY));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_BAMBOO_BLOCK_DOOR = SDBlocks.registerDoorBlock("horizontal_bamboo_block", "Horizontal Bamboo Block", () -> SDBlocks.doorBlock(Blocks.BAMBOO_BLOCK, BlockSetType.BAMBOO));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_CRIMSON_STEM_DOOR = SDBlocks.registerHorizontalStemDoorBlock(WoodType.CRIMSON, () -> SDBlocks.doorBlock(Blocks.CRIMSON_STEM, BlockSetType.CRIMSON));
    public static final DeferredBlock<DoorBlock> SECRET_HORIZONTAL_WARPED_STEM_DOOR = SDBlocks.registerHorizontalStemDoorBlock(WoodType.WARPED, () -> SDBlocks.doorBlock(Blocks.WARPED_STEM, BlockSetType.WARPED));
    public static final DeferredBlock<DoorBlock> SECRET_STONE_DOOR = SDBlocks.registerDoorBlock("stone", "Stone", () -> SDBlocks.doorBlock(Blocks.STONE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_COBBLESTONE_DOOR = SDBlocks.registerDoorBlock("cobblestone", "Cobblestone", () -> SDBlocks.doorBlock(Blocks.COBBLESTONE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_STONE_BRICKS_DOOR = SDBlocks.registerDoorBlock("stone_bricks", "Stone Bricks", () -> SDBlocks.doorBlock(Blocks.STONE_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_DEEPSLATE_DOOR = SDBlocks.registerDoorBlock("deepslate", "Deepslate", () -> SDBlocks.doorBlock(Blocks.DEEPSLATE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_COBBLED_DEEPSLATE_DOOR = SDBlocks.registerDoorBlock("cobbled_deepslate", "Cobbled Deepslate", () -> SDBlocks.doorBlock(Blocks.COBBLED_DEEPSLATE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_DEEPSLATE_BRICKS_DOOR = SDBlocks.registerDoorBlock("deepslate_bricks", "Deepslate Bricks", () -> SDBlocks.doorBlock(Blocks.DEEPSLATE_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_DEEPSLATE_TILES_DOOR = SDBlocks.registerDoorBlock("deepslate_tiles", "Deepslate Tiles", () -> SDBlocks.doorBlock(Blocks.DEEPSLATE_TILES, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_POLISHED_DEEPSLATE_DOOR = SDBlocks.registerDoorBlock("polished_deepslate", "Polished Deepslate", () -> SDBlocks.doorBlock(Blocks.POLISHED_DEEPSLATE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_BOOKSHELF_DOOR = SDBlocks.registerDoorBlock("bookshelf", "Bookshelf", () -> SDBlocks.doorBlock(Blocks.BOOKSHELF, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_CHISELED_BOOKSHELF_DOOR = SDBlocks.registerDoorBlock("chiseled_bookshelf", "Chiseled Bookshelf", () -> SDBlocks.doorBlock(Blocks.CHISELED_BOOKSHELF, BlockSetType.OAK));
    public static final DeferredBlock<DoorBlock> SECRET_NETHERRACK_DOOR = SDBlocks.registerDoorBlock("netherrack", "Netherrack", () -> SDBlocks.doorBlock(Blocks.NETHERRACK, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_NETHER_BRICK_DOOR = SDBlocks.registerDoorBlock("nether_brick", "Nether Brick", () -> SDBlocks.doorBlock(Blocks.NETHER_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_POLISHED_BLACKSTONE_DOOR = SDBlocks.registerDoorBlock("polished_blackstone", "Polished Blackstone", () -> SDBlocks.doorBlock(Blocks.POLISHED_BLACKSTONE, BlockSetType.POLISHED_BLACKSTONE));
    public static final DeferredBlock<DoorBlock> SECRET_POLISHED_BASALT_DOOR = SDBlocks.registerDoorBlock("polished_basalt", "Polished Basalt", () -> SDBlocks.doorBlock(Blocks.POLISHED_BASALT, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_BLACKSTONE_DOOR = SDBlocks.registerDoorBlock("blackstone", "Blackstone", () -> SDBlocks.doorBlock(Blocks.BLACKSTONE, BlockSetType.POLISHED_BLACKSTONE));
    public static final DeferredBlock<DoorBlock> SECRET_ANDESITE_DOOR = SDBlocks.registerDoorBlock("andesite", "Andesite", () -> SDBlocks.doorBlock(Blocks.ANDESITE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_POLISHED_ANDESITE_DOOR = SDBlocks.registerDoorBlock("polished_andesite", "Polished Andesite", () -> SDBlocks.doorBlock(Blocks.POLISHED_ANDESITE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_DIORITE_DOOR = SDBlocks.registerDoorBlock("diorite", "Diorite", () -> SDBlocks.doorBlock(Blocks.DIORITE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_POLISHED_DIORITE_DOOR = SDBlocks.registerDoorBlock("polished_diorite", "Polished Diorite", () -> SDBlocks.doorBlock(Blocks.POLISHED_DIORITE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_GRANITE_DOOR = SDBlocks.registerDoorBlock("granite", "Granite", () -> SDBlocks.doorBlock(Blocks.GRANITE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_POLISHED_GRANITE_DOOR = SDBlocks.registerDoorBlock("polished_granite", "Polished Granite", () -> SDBlocks.doorBlock(Blocks.POLISHED_GRANITE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_QUARTZ_BLOCK_DOOR = SDBlocks.registerDoorBlock("quartz_block", "Quartz Block", () -> SDBlocks.doorBlock(Blocks.QUARTZ_BLOCK, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_SMOOTH_QUARTZ_DOOR = SDBlocks.registerDoorBlock("smooth_quartz", "Smooth Quartz", () -> SDBlocks.doorBlock(Blocks.SMOOTH_QUARTZ, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_QUARTZ_BRICKS_DOOR = SDBlocks.registerDoorBlock("quartz_bricks", "Quartz Bricks", () -> SDBlocks.doorBlock(Blocks.QUARTZ_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_SANDSTONE_DOOR = SDBlocks.registerDoorBlock("sandstone", "Sandstone", () -> SDBlocks.doorBlock(Blocks.SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_CUT_SANDSTONE_DOOR = SDBlocks.registerDoorBlock("cut_sandstone", "Cut Sandstone", () -> SDBlocks.doorBlock(Blocks.CUT_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_SMOOTH_SANDSTONE_DOOR = SDBlocks.registerDoorBlock("smooth_sandstone", "Smooth Sandstone", () -> SDBlocks.doorBlock(Blocks.SMOOTH_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_RED_SANDSTONE_DOOR = SDBlocks.registerDoorBlock("red_sandstone", "Red Sandstone", () -> SDBlocks.doorBlock(Blocks.RED_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_CUT_RED_SANDSTONE_DOOR = SDBlocks.registerDoorBlock("cut_red_sandstone", "Cut Red Sandstone", () -> SDBlocks.doorBlock(Blocks.CUT_RED_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_SMOOTH_RED_SANDSTONE_DOOR = SDBlocks.registerDoorBlock("smooth_red_sandstone", "Smooth Red Sandstone", () -> SDBlocks.doorBlock(Blocks.SMOOTH_RED_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_BRICKS_DOOR = SDBlocks.registerDoorBlock("bricks", "Bricks", () -> SDBlocks.doorBlock(Blocks.BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_PURPUR_DOOR = SDBlocks.registerDoorBlock("purpur", "Purpur", () -> SDBlocks.doorBlock(Blocks.PURPUR_BLOCK, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_END_STONE_BRICKS_DOOR = SDBlocks.registerDoorBlock("end_stone_bricks", "End Stone Bricks", () -> SDBlocks.doorBlock(Blocks.END_STONE_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_PRISMARINE_BRICKS_DOOR = SDBlocks.registerDoorBlock("prismarine_bricks", "Prismarine Bricks", () -> SDBlocks.doorBlock(Blocks.PRISMARINE_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<DoorBlock> SECRET_DARK_PRISMARINE_DOOR = SDBlocks.registerDoorBlock("dark_prismarine", "Dark Prismarine", () -> SDBlocks.doorBlock(Blocks.DARK_PRISMARINE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_OAK_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.OAK, () -> SDBlocks.trapDoorBlock(Blocks.OAK_PLANKS, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_DARK_OAK_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.DARK_OAK, () -> SDBlocks.trapDoorBlock(Blocks.DARK_OAK_PLANKS, BlockSetType.DARK_OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_SPRUCE_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.SPRUCE, () -> SDBlocks.trapDoorBlock(Blocks.SPRUCE_PLANKS, BlockSetType.SPRUCE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_ACACIA_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.ACACIA, () -> SDBlocks.trapDoorBlock(Blocks.ACACIA_PLANKS, BlockSetType.ACACIA));
    public static final DeferredBlock<TrapDoorBlock> SECRET_BIRCH_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.BIRCH, () -> SDBlocks.trapDoorBlock(Blocks.BIRCH_PLANKS, BlockSetType.BIRCH));
    public static final DeferredBlock<TrapDoorBlock> SECRET_JUNGLE_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.JUNGLE, () -> SDBlocks.trapDoorBlock(Blocks.JUNGLE_PLANKS, BlockSetType.JUNGLE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_MANGROVE_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.MANGROVE, () -> SDBlocks.trapDoorBlock(Blocks.MANGROVE_PLANKS, BlockSetType.MANGROVE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_CHERRY_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.CHERRY, () -> SDBlocks.trapDoorBlock(Blocks.CHERRY_PLANKS, BlockSetType.CHERRY));
    public static final DeferredBlock<TrapDoorBlock> SECRET_BAMBOO_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.BAMBOO, () -> SDBlocks.trapDoorBlock(Blocks.BAMBOO_PLANKS, BlockSetType.BAMBOO));
    public static final DeferredBlock<TrapDoorBlock> SECRET_CRIMSON_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.CRIMSON, () -> SDBlocks.trapDoorBlock(Blocks.CRIMSON_PLANKS, BlockSetType.CRIMSON));
    public static final DeferredBlock<TrapDoorBlock> SECRET_WARPED_PLANK_TRAPDOOR = SDBlocks.registerPlankTrapdoorBlock(WoodType.WARPED, () -> SDBlocks.trapDoorBlock(Blocks.WARPED_PLANKS, BlockSetType.WARPED));
    public static final DeferredBlock<TrapDoorBlock> SECRET_OAK_LOG_TRAPDOOR = SDBlocks.registerLogTrapdoorBlock(WoodType.OAK, () -> SDBlocks.trapDoorBlock(Blocks.OAK_PLANKS, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_DARK_OAK_LOG_TRAPDOOR = SDBlocks.registerLogTrapdoorBlock(WoodType.DARK_OAK, () -> SDBlocks.trapDoorBlock(Blocks.DARK_OAK_LOG, BlockSetType.DARK_OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_SPRUCE_LOG_TRAPDOOR = SDBlocks.registerLogTrapdoorBlock(WoodType.SPRUCE, () -> SDBlocks.trapDoorBlock(Blocks.SPRUCE_LOG, BlockSetType.SPRUCE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_ACACIA_LOG_TRAPDOOR = SDBlocks.registerLogTrapdoorBlock(WoodType.ACACIA, () -> SDBlocks.trapDoorBlock(Blocks.ACACIA_LOG, BlockSetType.ACACIA));
    public static final DeferredBlock<TrapDoorBlock> SECRET_BIRCH_LOG_TRAPDOOR = SDBlocks.registerLogTrapdoorBlock(WoodType.BIRCH, () -> SDBlocks.trapDoorBlock(Blocks.BIRCH_LOG, BlockSetType.BIRCH));
    public static final DeferredBlock<TrapDoorBlock> SECRET_JUNGLE_LOG_TRAPDOOR = SDBlocks.registerLogTrapdoorBlock(WoodType.JUNGLE, () -> SDBlocks.trapDoorBlock(Blocks.JUNGLE_LOG, BlockSetType.JUNGLE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_MANGROVE_LOG_TRAPDOOR = SDBlocks.registerLogTrapdoorBlock(WoodType.MANGROVE, () -> SDBlocks.trapDoorBlock(Blocks.MANGROVE_LOG, BlockSetType.MANGROVE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_CHERRY_LOG_TRAPDOOR = SDBlocks.registerLogTrapdoorBlock(WoodType.CHERRY, () -> SDBlocks.trapDoorBlock(Blocks.CHERRY_LOG, BlockSetType.CHERRY));
    public static final DeferredBlock<TrapDoorBlock> SECRET_BAMBOO_BLOCK_TRAPDOOR = SDBlocks.registerTrapdoorBlock("bamboo_block", "Bamboo Block", () -> SDBlocks.trapDoorBlock(Blocks.BAMBOO_BLOCK, BlockSetType.BAMBOO));
    public static final DeferredBlock<TrapDoorBlock> SECRET_CRIMSON_STEM_TRAPDOOR = SDBlocks.registerStemTrapdoorBlock(WoodType.CRIMSON, () -> SDBlocks.trapDoorBlock(Blocks.CRIMSON_STEM, BlockSetType.BAMBOO));
    public static final DeferredBlock<TrapDoorBlock> SECRET_WARPED_STEM_TRAPDOOR = SDBlocks.registerStemTrapdoorBlock(WoodType.WARPED, () -> SDBlocks.trapDoorBlock(Blocks.WARPED_STEM, BlockSetType.WARPED));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_OAK_LOG_TRAPDOOR = SDBlocks.registerStrippedLogTrapdoorBlock(WoodType.OAK, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_OAK_LOG, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_DARK_OAK_LOG_TRAPDOOR = SDBlocks.registerStrippedLogTrapdoorBlock(WoodType.DARK_OAK, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_DARK_OAK_LOG, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_SPRUCE_LOG_TRAPDOOR = SDBlocks.registerStrippedLogTrapdoorBlock(WoodType.SPRUCE, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_SPRUCE_LOG, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_ACACIA_LOG_TRAPDOOR = SDBlocks.registerStrippedLogTrapdoorBlock(WoodType.ACACIA, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_ACACIA_LOG, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_BIRCH_LOG_TRAPDOOR = SDBlocks.registerStrippedLogTrapdoorBlock(WoodType.BIRCH, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_BIRCH_LOG, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_JUNGLE_LOG_TRAPDOOR = SDBlocks.registerStrippedLogTrapdoorBlock(WoodType.JUNGLE, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_JUNGLE_LOG, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_MANGROVE_LOG_TRAPDOOR = SDBlocks.registerStrippedLogTrapdoorBlock(WoodType.MANGROVE, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_MANGROVE_LOG, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_CHERRY_LOG_TRAPDOOR = SDBlocks.registerStrippedLogTrapdoorBlock(WoodType.CHERRY, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_CHERRY_LOG, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_BAMBOO_BLOCK_TRAPDOOR = SDBlocks.registerTrapdoorBlock("stripped_bamboo_block", "Stripped Bamboo Block", () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_BAMBOO_BLOCK, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_CRIMSON_STEM_TRAPDOOR = SDBlocks.registerStrippedStemTrapdoorBlock(WoodType.CRIMSON, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_CRIMSON_STEM, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STRIPPED_WARPED_STEM_TRAPDOOR = SDBlocks.registerStrippedStemTrapdoorBlock(WoodType.WARPED, () -> SDBlocks.trapDoorBlock(Blocks.STRIPPED_WARPED_STEM, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("stone", "Stone", () -> SDBlocks.trapDoorBlock(Blocks.STONE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_COBBLESTONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("cobblestone", "Cobblestone", () -> SDBlocks.trapDoorBlock(Blocks.COBBLESTONE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_STONE_BRICKS_TRAPDOOR = SDBlocks.registerTrapdoorBlock("stone_bricks", "Stone Bricks", () -> SDBlocks.trapDoorBlock(Blocks.STONE_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_DEEPSLATE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("deepslate", "Deepslate", () -> SDBlocks.trapDoorBlock(Blocks.DEEPSLATE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_COBBLED_DEEPSLATE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("cobbled_deepslate", "Cobbled Deepslate", () -> SDBlocks.trapDoorBlock(Blocks.COBBLED_DEEPSLATE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_DEEPSLATE_BRICKS_TRAPDOOR = SDBlocks.registerTrapdoorBlock("deepslate_bricks", "Deepslate Bricks", () -> SDBlocks.trapDoorBlock(Blocks.DEEPSLATE_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_DEEPSLATE_TILES_TRAPDOOR = SDBlocks.registerTrapdoorBlock("deepslate_tiles", "Deepslate Tiles", () -> SDBlocks.trapDoorBlock(Blocks.DEEPSLATE_TILES, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_POLISHED_DEEPSLATE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("polished_deepslate", "Polished Deepslate", () -> SDBlocks.trapDoorBlock(Blocks.POLISHED_DEEPSLATE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_BOOKSHELF_TRAPDOOR = SDBlocks.registerTrapdoorBlock("bookshelf", "Bookshelf", () -> SDBlocks.trapDoorBlock(Blocks.BOOKSHELF, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_CHISELED_BOOKSHELF_TRAPDOOR = SDBlocks.registerTrapdoorBlock("chiseled_bookshelf", "Chiseled Bookshelf", () -> SDBlocks.trapDoorBlock(Blocks.CHISELED_BOOKSHELF, BlockSetType.OAK));
    public static final DeferredBlock<TrapDoorBlock> SECRET_NETHERRACK_TRAPDOOR = SDBlocks.registerTrapdoorBlock("netherrack", "Netherrack", () -> SDBlocks.trapDoorBlock(Blocks.NETHERRACK, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_NETHER_BRICK_TRAPDOOR = SDBlocks.registerTrapdoorBlock("nether_brick", "Nether Brick", () -> SDBlocks.trapDoorBlock(Blocks.NETHER_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_POLISHED_BLACKSTONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("polished_blackstone", "Polished Blackstone", () -> SDBlocks.trapDoorBlock(Blocks.POLISHED_BLACKSTONE, BlockSetType.POLISHED_BLACKSTONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_POLISHED_BASALT_TRAPDOOR = SDBlocks.registerTrapdoorBlock("polished_basalt", "Polished Basalt", () -> SDBlocks.trapDoorBlock(Blocks.POLISHED_BASALT, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_BLACKSTONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("blackstone", "Blackstone", () -> SDBlocks.trapDoorBlock(Blocks.BLACKSTONE, BlockSetType.POLISHED_BLACKSTONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_ANDESITE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("andesite", "Andesite", () -> SDBlocks.trapDoorBlock(Blocks.ANDESITE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_POLISHED_ANDESITE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("polished_andesite", "Polished Andesite", () -> SDBlocks.trapDoorBlock(Blocks.POLISHED_ANDESITE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_DIORITE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("diorite", "Diorite", () -> SDBlocks.trapDoorBlock(Blocks.DIORITE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_POLISHED_DIORITE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("polished_diorite", "Polished Diorite", () -> SDBlocks.trapDoorBlock(Blocks.POLISHED_DIORITE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_GRANITE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("granite", "Granite", () -> SDBlocks.trapDoorBlock(Blocks.GRANITE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_POLISHED_GRANITE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("polished_granite", "Polished Granite", () -> SDBlocks.trapDoorBlock(Blocks.POLISHED_GRANITE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_QUARTZ_BLOCK_TRAPDOOR = SDBlocks.registerTrapdoorBlock("quartz_block", "Quartz Block", () -> SDBlocks.trapDoorBlock(Blocks.QUARTZ_BLOCK, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_SMOOTH_QUARTZ_TRAPDOOR = SDBlocks.registerTrapdoorBlock("smooth_quartz", "Smooth Quartz", () -> SDBlocks.trapDoorBlock(Blocks.SMOOTH_QUARTZ, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_QUARTZ_BRICKS_TRAPDOOR = SDBlocks.registerTrapdoorBlock("quartz_bricks", "Quartz Bricks", () -> SDBlocks.trapDoorBlock(Blocks.QUARTZ_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_SANDSTONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("sandstone", "Sandstone", () -> SDBlocks.trapDoorBlock(Blocks.SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_CUT_SANDSTONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("cut_sandstone", "Cut Sandstone", () -> SDBlocks.trapDoorBlock(Blocks.CUT_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_SMOOTH_SANDSTONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("smooth_sandstone", "Smooth Sandstone", () -> SDBlocks.trapDoorBlock(Blocks.SMOOTH_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_RED_SANDSTONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("red_sandstone", "Red Sandstone", () -> SDBlocks.trapDoorBlock(Blocks.RED_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_CUT_RED_SANDSTONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("cut_red_sandstone", "Cut Red Sandstone", () -> SDBlocks.trapDoorBlock(Blocks.CUT_RED_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_SMOOTH_RED_SANDSTONE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("smooth_red_sandstone", "Smooth Red Sandstone", () -> SDBlocks.trapDoorBlock(Blocks.SMOOTH_RED_SANDSTONE, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_BRICKS_TRAPDOOR = SDBlocks.registerTrapdoorBlock("bricks", "Bricks", () -> SDBlocks.trapDoorBlock(Blocks.BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_PURPUR_TRAPDOOR = SDBlocks.registerTrapdoorBlock("purpur", "Purpur", () -> SDBlocks.trapDoorBlock(Blocks.PURPUR_BLOCK, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_END_STONE_BRICKS_TRAPDOOR = SDBlocks.registerTrapdoorBlock("end_stone_bricks", "End Stone Bricks", () -> SDBlocks.trapDoorBlock(Blocks.END_STONE_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_PRISMARINE_BRICKS_TRAPDOOR = SDBlocks.registerTrapdoorBlock("prismarine_bricks", "Prismarine Bricks", () -> SDBlocks.trapDoorBlock(Blocks.PRISMARINE_BRICKS, BlockSetType.STONE));
    public static final DeferredBlock<TrapDoorBlock> SECRET_DARK_PRISMARINE_TRAPDOOR = SDBlocks.registerTrapdoorBlock("dark_prismarine", "Dark Prismarine", () -> SDBlocks.trapDoorBlock(Blocks.DARK_PRISMARINE, BlockSetType.STONE));

    public static DoorBlock doorBlock(Block blockToCopy, BlockSetType type) {
        return new DoorBlock(type, BlockBehaviour.Properties.of().mapColor(blockToCopy.defaultMapColor()).instrument(blockToCopy.defaultBlockState().instrument()).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    }

    public static TrapDoorBlock trapDoorBlock(Block blockToCopy, BlockSetType type) {
        return new TrapDoorBlock(type, BlockBehaviour.Properties.of().mapColor(blockToCopy.defaultMapColor()).instrument(blockToCopy.defaultBlockState().instrument()).strength(3.0f).noOcclusion().isValidSpawn(SDBlocks::never).ignitedByLava());
    }

    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            for (DeferredBlock deferredBlock : BUILDING_BLOCKS_CREATIVE_TAB) {
                event.accept((ItemLike)deferredBlock);
            }
        }
    }

    private static Boolean never(BlockState state, BlockGetter blockGetter, BlockPos pose, EntityType<?> entityType) {
        return false;
    }

    private static <T extends DoorBlock> DeferredBlock<T> registerDoorBlockBase(String nameIn, String localizationIn, Supplier<T> blockIn) {
        DeferredBlock block = BLOCKS.register(nameIn, blockIn);
        ITEMS.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties()));
        BLOCK_LANG_EN_US.put((DeferredBlock<? extends Block>)block, localizationIn);
        DOOR_LOOT_TABLE.add((DeferredBlock<? extends Block>)block);
        BUILDING_BLOCKS_CREATIVE_TAB.add((DeferredBlock<? extends Block>)block);
        return block;
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerDoorBlock(String doorNameIn, String doorLocalizationIn, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlockBase("secret_" + doorNameIn + "_door", "Secret " + doorLocalizationIn + " Door", blockIn);
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerPlankDoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlock(wood.name + "_plank", wood.localization + " Plank", blockIn);
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerLogDoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlock(wood.name + "_log", wood.localization + " Log", blockIn);
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerStemDoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlock(wood.name + "_stem", wood.localization + " Stem", blockIn);
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerStrippedLogDoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlock("stripped_" + wood.name + "_log", "Stripped " + wood.localization + " Log", blockIn);
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerStrippedStemDoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlock("stripped_" + wood.name + "_stem", "Stripped " + wood.localization + " Stem", blockIn);
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerStrippedHorizontalLogDoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlock("stripped_horizontal_" + wood.name + "_log", "Stripped Horizontal " + wood.localization + " Log", blockIn);
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerStrippedHorizontalStemDoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlock("stripped_horizontal_" + wood.name + "_stem", "Stripped Horizontal " + wood.localization + " Stem", blockIn);
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerHorizontalLogDoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlock("horizontal_" + wood.name + "_log", "Horizontal " + wood.localization + " Log", blockIn);
    }

    public static <T extends DoorBlock> DeferredBlock<T> registerHorizontalStemDoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerDoorBlock("horizontal_" + wood.name + "_stem", "Horizontal " + wood.localization + " Stem", blockIn);
    }

    private static <T extends Block> DeferredBlock<T> registerTrapdoorBlockBase(String nameIn, String localizationIn, Supplier<T> blockIn) {
        DeferredBlock block = BLOCKS.register(nameIn, blockIn);
        ITEMS.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties()));
        BLOCK_LANG_EN_US.put((DeferredBlock<? extends Block>)block, localizationIn);
        TRAPDOOR_LOOT_TABLE.add((DeferredBlock<? extends Block>)block);
        BUILDING_BLOCKS_CREATIVE_TAB.add((DeferredBlock<? extends Block>)block);
        return block;
    }

    public static <T extends TrapDoorBlock> DeferredBlock<T> registerTrapdoorBlock(String doorNameIn, String doorLocalizationIn, Supplier<T> blockIn) {
        return SDBlocks.registerTrapdoorBlockBase("secret_" + doorNameIn + "_trapdoor", "Secret " + doorLocalizationIn + " Trapdoor", blockIn);
    }

    public static <T extends TrapDoorBlock> DeferredBlock<T> registerPlankTrapdoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerTrapdoorBlock(wood.name + "_plank", wood.localization + " Plank", blockIn);
    }

    public static <T extends TrapDoorBlock> DeferredBlock<T> registerLogTrapdoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerTrapdoorBlock(wood.name + "_log", wood.localization + " Log", blockIn);
    }

    public static <T extends TrapDoorBlock> DeferredBlock<T> registerStemTrapdoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerTrapdoorBlock(wood.name + "_stem", wood.localization + " Stem", blockIn);
    }

    public static <T extends TrapDoorBlock> DeferredBlock<T> registerStrippedLogTrapdoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerTrapdoorBlock("stripped_" + wood.name + "_log", "Stripped " + wood.localization + " Log", blockIn);
    }

    public static <T extends TrapDoorBlock> DeferredBlock<T> registerStrippedStemTrapdoorBlock(WoodType wood, Supplier<T> blockIn) {
        return SDBlocks.registerTrapdoorBlock("stripped_" + wood.name + "_stem", "Stripped " + wood.localization + " Stem", blockIn);
    }

    static enum WoodType {
        OAK("oak", "Oak"),
        DARK_OAK("dark_oak", "Dark Oak"),
        SPRUCE("spruce", "Spruce"),
        ACACIA("acacia", "Acacia"),
        BIRCH("birch", "Birch"),
        JUNGLE("jungle", "Jungle"),
        MANGROVE("mangrove", "Mangrove"),
        CHERRY("cherry", "Cherry"),
        BAMBOO("bamboo", "Bamboo"),
        CRIMSON("crimson", "Crimson"),
        WARPED("warped", "Warped");

        final String name;
        final String localization;

        private WoodType(String name, String localization) {
            this.name = name;
            this.localization = localization;
        }
    }
}

