/*
 * Decompiled with CFR 0.152.
 */
package com.shim.secretdoors.datagen;

import com.shim.secretdoors.datagen.BlockStates;
import com.shim.secretdoors.datagen.ItemModels;
import com.shim.secretdoors.datagen.ModBlockTags;
import com.shim.secretdoors.datagen.ModItemTags;
import com.shim.secretdoors.datagen.ModLanguageProvider;
import com.shim.secretdoors.datagen.Recipes;
import com.shim.secretdoors.datagen.SBDLootTables;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="secretdoors", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(SBDLootTables::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput, lookupProvider));
        ModBlockTags blockTagsProvider = new ModBlockTags(packOutput, lookupProvider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTags(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), helper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(packOutput, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "en_us"));
    }
}

