/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation.mirror;

import com.cak.pattern_schematics.foundation.mirror.CloneSchematicOutlineRenderer;
import com.cak.pattern_schematics.foundation.mirror.PatternSchematicHotbarSlotOverlay;
import com.cak.pattern_schematics.foundation.mirror.PatternSchematicsToolSelectionScreen;
import com.cak.pattern_schematics.foundation.mirror.PatternSchematicsToolType;
import com.cak.pattern_schematics.foundation.util.Vec3iUtils;
import com.cak.pattern_schematics.registry.PatternSchematicsDataComponents;
import com.cak.pattern_schematics.registry.PatternSchematicsRegistry;
import com.cak.pattern_schematics.registry.PlatformPackets;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllKeys;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.content.schematics.client.SchematicRenderer;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class PatternSchematicHandler
extends SchematicHandler {
    protected String displayedSchematic;
    protected SchematicTransformation transformation;
    protected AABB bounds;
    protected boolean deployed;
    protected boolean active;
    protected PatternSchematicsToolType currentTool;
    protected static final int SYNC_DELAY = 10;
    protected int syncCooldown;
    protected int activeHotbarSlot;
    protected ItemStack activeSchematicItem;
    protected AABBOutline outline;
    protected AABBOutline greaterOutline;
    private final SchematicRenderer[] renderers = new SchematicRenderer[3];
    protected PatternSchematicHotbarSlotOverlay overlay;
    protected PatternSchematicsToolSelectionScreen selectionScreen;
    protected Vec3i cloneScaleMin = new Vec3i(0, 0, 0);
    protected Vec3i cloneScaleMax = new Vec3i(0, 0, 0);
    protected Vec3i cloneOffset = new Vec3i(0, 0, 0);
    protected boolean isRenderingMain;
    protected boolean isRenderingMultiple;

    public PatternSchematicHandler() {
        this.overlay = new PatternSchematicHotbarSlotOverlay();
        this.currentTool = PatternSchematicsToolType.DEPLOY;
        this.selectionScreen = new PatternSchematicsToolSelectionScreen((List<PatternSchematicsToolType>)ImmutableList.of((Object)((Object)PatternSchematicsToolType.DEPLOY)), this::equip);
        this.transformation = new SchematicTransformation();
    }

    public void tick() {
        LocalPlayer player;
        ItemStack stack;
        Minecraft mc = Minecraft.getInstance();
        if (mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            if (this.active) {
                this.active = false;
                this.syncCooldown = 0;
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
            }
            return;
        }
        if (this.activeSchematicItem != null && this.transformation != null) {
            this.transformation.tick();
        }
        if ((stack = this.findBlueprintInHand((Player)(player = mc.player))) == null) {
            this.active = false;
            this.syncCooldown = 0;
            if (this.activeSchematicItem != null && this.itemLost((Player)player)) {
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
            }
            return;
        }
        if (!this.active || !((String)stack.get(AllDataComponents.SCHEMATIC_FILE)).equals(this.displayedSchematic)) {
            this.init(player, stack);
        }
        if (!this.active) {
            return;
        }
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
        }
        if (this.syncCooldown == 1) {
            this.sync();
        }
        this.selectionScreen.update();
        this.currentTool.getTool().updateSelection();
    }

    private void init(LocalPlayer player, ItemStack stack) {
        this.loadSettings(stack);
        this.displayedSchematic = (String)stack.get(AllDataComponents.SCHEMATIC_FILE);
        this.active = true;
        if (this.deployed) {
            this.setupRenderer();
            PatternSchematicsToolType toolBefore = this.currentTool;
            this.selectionScreen = new PatternSchematicsToolSelectionScreen(PatternSchematicsToolType.getTools(player.isCreative()), this::equip);
            if (toolBefore != null) {
                this.selectionScreen.setSelectedElement(toolBefore);
                this.equip(toolBefore);
            }
        } else {
            this.selectionScreen = new PatternSchematicsToolSelectionScreen((List<PatternSchematicsToolType>)ImmutableList.of((Object)((Object)PatternSchematicsToolType.DEPLOY)), this::equip);
        }
    }

    private void setupRenderer() {
        ClientLevel clientWorld = Minecraft.getInstance().level;
        StructureTemplate schematic = SchematicItem.loadSchematic((Level)clientWorld, (ItemStack)this.activeSchematicItem);
        Vec3i size = schematic.getSize();
        if (size.equals((Object)Vec3i.ZERO)) {
            return;
        }
        SchematicLevel w = new SchematicLevel((Level)clientWorld);
        SchematicLevel wMirroredFB = new SchematicLevel((Level)clientWorld);
        SchematicLevel wMirroredLR = new SchematicLevel((Level)clientWorld);
        StructurePlaceSettings placementSettings = new StructurePlaceSettings();
        BlockPos pos = BlockPos.ZERO;
        try {
            schematic.placeInWorld((ServerLevelAccessor)w, pos, pos, placementSettings, w.getRandom(), 2);
        }
        catch (Exception e) {
            Minecraft.getInstance().player.displayClientMessage((Component)CreateLang.translate((String)"schematic.error", (Object[])new Object[0]).component(), false);
            Create.LOGGER.error("Failed to load Schematic for Previewing", (Throwable)e);
            return;
        }
        placementSettings.setMirror(Mirror.FRONT_BACK);
        pos = BlockPos.ZERO.east(size.getX() - 1);
        schematic.placeInWorld((ServerLevelAccessor)wMirroredFB, pos, pos, placementSettings, wMirroredFB.getRandom(), 2);
        StructureTransform transform = new StructureTransform(placementSettings.getRotationPivot(), Direction.Axis.Y, Rotation.NONE, placementSettings.getMirror());
        for (BlockEntity be : wMirroredFB.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        this.fixControllerBlockEntities(wMirroredLR);
        placementSettings.setMirror(Mirror.LEFT_RIGHT);
        pos = BlockPos.ZERO.south(size.getZ() - 1);
        schematic.placeInWorld((ServerLevelAccessor)wMirroredLR, pos, pos, placementSettings, wMirroredFB.getRandom(), 2);
        transform = new StructureTransform(placementSettings.getRotationPivot(), Direction.Axis.Y, Rotation.NONE, placementSettings.getMirror());
        for (BlockEntity be : wMirroredLR.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        this.fixControllerBlockEntities(wMirroredLR);
        this.renderers[0] = new SchematicRenderer(w);
        this.renderers[1] = new SchematicRenderer(wMirroredFB);
        this.renderers[2] = new SchematicRenderer(wMirroredLR);
    }

    private void fixControllerBlockEntities(SchematicLevel level) {
        for (BlockEntity blockEntity : level.getBlockEntities()) {
            if (!(blockEntity instanceof IMultiBlockEntityContainer)) continue;
            IMultiBlockEntityContainer multiBlockEntity = (IMultiBlockEntityContainer)blockEntity;
            BlockPos lastKnown = multiBlockEntity.getLastKnownPos();
            BlockPos current = blockEntity.getBlockPos();
            if (lastKnown == null || current == null || multiBlockEntity.isController() || lastKnown.equals((Object)current)) continue;
            BlockPos newControllerPos = multiBlockEntity.getController().offset((Vec3i)current.subtract((Vec3i)lastKnown));
            if (multiBlockEntity instanceof SmartBlockEntity) {
                SmartBlockEntity sbe = (SmartBlockEntity)multiBlockEntity;
                sbe.markVirtual();
            }
            multiBlockEntity.setController(newControllerPos);
        }
    }

    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera) {
        boolean present;
        boolean bl = present = this.activeSchematicItem != null;
        if (!this.active && !present) {
            return;
        }
        if (this.active) {
            this.isRenderingMultiple = false;
            this.isRenderingMain = true;
            ms.pushPose();
            this.currentTool.getTool().renderTool(ms, buffer, camera);
            ms.popPose();
        }
        Vec3 schematicSize = new Vec3(this.bounds.getXsize(), this.bounds.getYsize(), this.bounds.getZsize());
        this.isRenderingMultiple = !this.cloneScaleMax.equals((Object)this.cloneScaleMin);
        for (int x = this.cloneScaleMin.getX(); x <= this.cloneScaleMax.getX(); ++x) {
            for (int y = this.cloneScaleMin.getY(); y <= this.cloneScaleMax.getY(); ++y) {
                for (int z = this.cloneScaleMin.getZ(); z <= this.cloneScaleMax.getZ(); ++z) {
                    this.isRenderingMain = x == 0 && y == 0 && z == 0;
                    this.renderSchematic(this.transformation, new Vec3((double)x, (double)y, (double)z).multiply(schematicSize), ms, camera, buffer);
                }
            }
        }
        if (this.active && this.deployed) {
            ms.pushPose();
            this.transformation.applyTransformations(ms, camera);
            CloneSchematicOutlineRenderer.renderCloneGridLines(ms, this, buffer);
            ms.popPose();
        }
    }

    protected void renderSchematic(SchematicTransformation transformation, Vec3 cloneOffset, PoseStack ms, Vec3 camera, SuperRenderTypeBuffer buffer) {
        boolean fb;
        boolean present;
        if (!this.active) {
            return;
        }
        boolean bl = present = this.activeSchematicItem != null;
        if (!present) {
            return;
        }
        ms.pushPose();
        this.currentTool.getTool().renderTool(ms, buffer, camera);
        ms.popPose();
        ms.pushPose();
        transformation.applyTransformations(ms, camera);
        ms.translate(cloneOffset.x(), cloneOffset.y(), cloneOffset.z());
        float pt = AnimationTickHolder.getPartialTicks();
        boolean lr = transformation.getScaleLR().getValue(pt) < 0.0f;
        boolean bl2 = fb = transformation.getScaleFB().getValue(pt) < 0.0f;
        if (lr && !fb && this.renderers[2] != null) {
            this.renderers[2].render(ms, buffer);
        } else if (fb && !lr && this.renderers[1] != null) {
            this.renderers[1].render(ms, buffer);
        } else if (this.renderers[0] != null) {
            this.renderers[0].render(ms, buffer);
        }
        this.currentTool.getTool().renderOnSchematic(ms, buffer);
        ms.popPose();
    }

    public void updateRenderers() {
        for (SchematicRenderer renderer : this.renderers) {
            if (renderer == null) continue;
            renderer.update();
        }
    }

    public boolean onMouseInput(int button, boolean pressed) {
        if (!this.active) {
            return false;
        }
        if (!pressed || button != 1) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player.isShiftKeyDown()) {
            return false;
        }
        if (mc.hitResult instanceof BlockHitResult) {
            BlockHitResult blockRayTraceResult = (BlockHitResult)mc.hitResult;
            BlockState clickedBlock = mc.level.getBlockState(blockRayTraceResult.getBlockPos());
            if (AllBlocks.SCHEMATICANNON.has(clickedBlock)) {
                return false;
            }
            if (AllBlocks.DEPLOYER.has(clickedBlock)) {
                return false;
            }
        }
        return this.currentTool.getTool().handleRightClick();
    }

    public void onKeyInput(int key, boolean pressed) {
        if (!this.active) {
            return;
        }
        if (!AllKeys.TOOL_MENU.doesModifierAndCodeMatch(key)) {
            return;
        }
        if (pressed && !this.selectionScreen.focused) {
            this.selectionScreen.focused = true;
        }
        if (!pressed && this.selectionScreen.focused) {
            this.selectionScreen.focused = false;
            this.selectionScreen.onClose();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (!this.active) {
            return false;
        }
        if (this.selectionScreen.focused) {
            this.selectionScreen.cycle((int)delta);
            return true;
        }
        if (AllKeys.ctrlDown()) {
            return this.currentTool.getTool().handleMouseWheel(delta);
        }
        return false;
    }

    private ItemStack findBlueprintInHand(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (!PatternSchematicsRegistry.PATTERN_SCHEMATIC.isIn(stack)) {
            return null;
        }
        if (!stack.has(AllDataComponents.SCHEMATIC_FILE)) {
            return null;
        }
        this.activeSchematicItem = stack;
        this.activeHotbarSlot = player.getInventory().selected;
        return stack;
    }

    private boolean itemLost(Player player) {
        for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
            if (player.getInventory().getItem(i).is(this.activeSchematicItem.getItem()) || !ItemStack.matches((ItemStack)player.getInventory().getItem(i), (ItemStack)this.activeSchematicItem)) continue;
            return false;
        }
        return true;
    }

    public void markDirty() {
        this.syncCooldown = 10;
    }

    public void sync() {
        if (this.activeSchematicItem == null) {
            return;
        }
        PlatformPackets.sendPatternSchematicSyncPacket(this.activeHotbarSlot, this.transformation.toSettings(), this.transformation.getAnchor(), this.deployed, this.cloneScaleMin, this.cloneScaleMax, this.cloneOffset);
    }

    public void equip(PatternSchematicsToolType tool) {
        this.currentTool = tool;
        this.currentTool.getTool().init();
    }

    public void loadSettings(ItemStack blueprint) {
        BlockPos anchor = BlockPos.ZERO;
        StructurePlaceSettings settings = SchematicItem.getSettings((ItemStack)blueprint);
        this.cloneScaleMin = (Vec3i)blueprint.getOrDefault(PatternSchematicsDataComponents.SCHEMATIC_CLONE_SCALE_MIN, (Object)Vec3i.ZERO);
        this.cloneScaleMax = (Vec3i)blueprint.getOrDefault(PatternSchematicsDataComponents.SCHEMATIC_CLONE_SCALE_MAX, (Object)Vec3i.ZERO);
        this.cloneOffset = (Vec3i)blueprint.getOrDefault(PatternSchematicsDataComponents.SCHEMATIC_CLONE_OFFSET, (Object)Vec3i.ZERO);
        this.transformation = new SchematicTransformation();
        this.deployed = (Boolean)blueprint.getOrDefault(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)false);
        if (this.deployed) {
            anchor = (BlockPos)blueprint.get(AllDataComponents.SCHEMATIC_ANCHOR);
        }
        Vec3i size = (Vec3i)blueprint.get(AllDataComponents.SCHEMATIC_BOUNDS);
        this.bounds = new AABB(0.0, 0.0, 0.0, (double)size.getX(), (double)size.getY(), (double)size.getZ());
        this.outline = new AABBOutline(this.bounds);
        this.outline.getParams().colored(10847909).lineWidth(0.0f);
        this.greaterOutline = new AABBOutline(this.calculateGreaterOutlineBounds());
        this.greaterOutline.getParams().colored(10847909).lineWidth(0.0f);
        this.transformation.init(anchor, settings, this.bounds);
    }

    public AABB calculateGreaterOutlineBounds() {
        return this.bounds.expandTowards(new Vec3(0.0, 0.0, 0.0).add(this.bounds.getXsize() * (double)this.cloneScaleMin.getX(), this.bounds.getYsize() * (double)this.cloneScaleMin.getY(), this.bounds.getZsize() * (double)this.cloneScaleMin.getZ())).expandTowards(new Vec3(0.0, 0.0, 0.0).add(this.bounds.getXsize() * (double)this.cloneScaleMax.getX(), this.bounds.getYsize() * (double)this.cloneScaleMax.getY(), this.bounds.getZsize() * (double)this.cloneScaleMax.getZ()));
    }

    public void deploy() {
        if (!this.deployed) {
            List<PatternSchematicsToolType> tools = PatternSchematicsToolType.getTools(Minecraft.getInstance().player.isCreative());
            this.selectionScreen = new PatternSchematicsToolSelectionScreen(tools, this::equip);
        }
        this.deployed = true;
        this.setupRenderer();
    }

    public String getCurrentSchematicName() {
        return this.displayedSchematic != null ? this.displayedSchematic : "-";
    }

    public boolean isActive() {
        return this.active;
    }

    public AABB getBounds() {
        return this.bounds;
    }

    public SchematicTransformation getTransformation() {
        return this.transformation;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public ItemStack getActiveSchematicItem() {
        return this.activeSchematicItem;
    }

    public void setCloneScaleMin(Vec3i min) {
        this.cloneScaleMin = Vec3iUtils.min(min, 0);
    }

    public void setCloneScaleMax(Vec3i max) {
        this.cloneScaleMax = Vec3iUtils.max(max, 0);
    }

    public Vec3i getCloneScaleMin() {
        return this.cloneScaleMin;
    }

    public Vec3i getCloneScaleMax() {
        return this.cloneScaleMax;
    }

    public void setCloneOffset(Vec3i offset) {
        this.cloneOffset = offset;
    }

    public boolean isRenderingMain() {
        return this.isRenderingMain;
    }

    public boolean isRenderingMultiple() {
        return this.isRenderingMultiple;
    }

    public AABB getExtendedBounds() {
        AABB originalBounds = this.getBounds();
        Vec3 boundsLength = new Vec3(originalBounds.getXsize(), originalBounds.getYsize(), originalBounds.getZsize());
        return this.getBounds().expandTowards(new Vec3((double)this.cloneScaleMin.getX(), (double)this.cloneScaleMin.getY(), (double)this.cloneScaleMin.getZ()).multiply(boundsLength)).expandTowards(new Vec3((double)this.cloneScaleMax.getX(), (double)this.cloneScaleMax.getY(), (double)this.cloneScaleMax.getZ()).multiply(boundsLength));
    }

    public AABBOutline getGreaterOutline() {
        return this.greaterOutline;
    }
}

