/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.data.capture.MobColor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.npc.Villager;

public class MobColorData {
    public static final String COLOR_TAG = "Color";

    private MobColorData() {
    }

    public static MobColor getColor(EntityType<?> entityType) {
        return MobColor.NONE;
    }

    public static MobColor getColor(LivingEntity livingEntity) {
        if (livingEntity instanceof Sheep) {
            Sheep sheep = (Sheep)livingEntity;
            return MobColor.byDyeColor(sheep.getColor());
        }
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            return MobColor.byVillagerType(villager.getVillagerData().getType());
        }
        return MobColor.NONE;
    }

    public static MobColor getColor(CompoundTag compoundTag) {
        if (compoundTag == null || !compoundTag.contains(COLOR_TAG)) {
            return MobColor.NONE;
        }
        return MobColor.byName(compoundTag.getString(COLOR_TAG));
    }
}

