/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util.hnsw;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.codecs.hnsw.HnswGraphProvider;
import org.apache.lucene.ars_nouveau.index.FieldInfo;
import org.apache.lucene.ars_nouveau.index.KnnVectorValues;
import org.apache.lucene.ars_nouveau.search.TaskExecutor;
import org.apache.lucene.ars_nouveau.util.FixedBitSet;
import org.apache.lucene.ars_nouveau.util.hnsw.HnswBuilder;
import org.apache.lucene.ars_nouveau.util.hnsw.HnswConcurrentMergeBuilder;
import org.apache.lucene.ars_nouveau.util.hnsw.HnswGraph;
import org.apache.lucene.ars_nouveau.util.hnsw.IncrementalHnswGraphMerger;
import org.apache.lucene.ars_nouveau.util.hnsw.InitializedHnswGraphBuilder;
import org.apache.lucene.ars_nouveau.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.ars_nouveau.util.hnsw.RandomVectorScorerSupplier;

public class ConcurrentHnswMerger
extends IncrementalHnswGraphMerger {
    private final TaskExecutor taskExecutor;
    private final int numWorker;

    public ConcurrentHnswMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, TaskExecutor taskExecutor, int numWorker) {
        super(fieldInfo, scorerSupplier, M, beamWidth);
        this.taskExecutor = taskExecutor;
        this.numWorker = numWorker;
    }

    @Override
    protected HnswBuilder createBuilder(KnnVectorValues mergedVectorValues, int maxOrd) throws IOException {
        if (this.initReader == null) {
            return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.scorerSupplier, this.M, this.beamWidth, new OnHeapHnswGraph(this.M, maxOrd), null);
        }
        HnswGraph initializerGraph = ((HnswGraphProvider)((Object)this.initReader)).getGraph(this.fieldInfo.name);
        FixedBitSet initializedNodes = new FixedBitSet(maxOrd);
        int[] oldToNewOrdinalMap = this.getNewOrdMapping(mergedVectorValues, initializedNodes);
        return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.scorerSupplier, this.M, this.beamWidth, InitializedHnswGraphBuilder.initGraph(this.M, initializerGraph, oldToNewOrdinalMap, maxOrd), initializedNodes);
    }
}

