/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world.dimension;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.tile.PlanariumProjectorTile;
import com.hollingsworth.arsnouveau.setup.ModSetup;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;

public class PlanariumChunkGenerator
extends ChunkGenerator {
    public static AABB innerBox = new AABB(0.0, 0.0, 0.0, 31.0, 30.0, 31.0);
    private final Holder<Biome> biome;

    public Holder<Biome> biome() {
        return this.biome;
    }

    public static MapCodec<PlanariumChunkGenerator> makeCodec() {
        return Biome.CODEC.fieldOf("biome").xmap(PlanariumChunkGenerator::new, PlanariumChunkGenerator::biome);
    }

    public int getHeight() {
        return 31;
    }

    public PlanariumChunkGenerator(MinecraftServer server) {
        this((Holder<Biome>)server.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(ArsNouveau.BIOME_KEY));
    }

    public PlanariumChunkGenerator(Holder<Biome> biome) {
        super((BiomeSource)new FixedBiomeSource(biome));
        this.biome = biome;
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return (MapCodec)ModSetup.VOID_CHUNK_GENERATOR_CODEC.get();
    }

    public void applyCarvers(WorldGenRegion world, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carvingStep) {
    }

    public void buildSurface(WorldGenRegion worldGenRegion, StructureManager structureFeatureManager, RandomState random, ChunkAccess chunk) {
        int chunkX = chunk.getPos().x;
        int chunkZ = chunk.getPos().z;
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        int minX = -1;
        int maxX = 32;
        int minY = 0;
        int maxY = 32;
        int minZ = -1;
        int maxZ = 32;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldPosX = worldX + x;
                int worldPosZ = worldZ + z;
                if (worldPosX < minX || worldPosX > maxX || worldPosZ < minZ || worldPosZ > maxZ) continue;
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos;
                    boolean isEdge;
                    boolean bl = isEdge = worldPosX == minX || worldPosX == maxX || y == minY || y == maxY || worldPosZ == minZ || worldPosZ == maxZ;
                    if (worldPosX == 0 && y == 0 && worldPosZ == 0) {
                        pos = new BlockPos(x, y - 1, z);
                        chunk.setBlockState(pos, BlockRegistry.PLANARIUM_PROJECTOR.defaultBlockState(), false);
                        chunk.setBlockEntity((BlockEntity)new PlanariumProjectorTile(pos, BlockRegistry.PLANARIUM_PROJECTOR.defaultBlockState()));
                        chunk.setBlockState(new BlockPos(x, y, z), BlockRegistry.DIM_BOUNDARY.defaultBlockState(), false);
                        continue;
                    }
                    if (!isEdge) continue;
                    pos = new BlockPos(x, y, z);
                    chunk.setBlockState(pos, BlockRegistry.DIM_BOUNDARY.defaultBlockState(), false);
                }
            }
        }
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
    }

    public int getGenDepth() {
        return 33;
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState random, StructureManager structures, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int getSeaLevel() {
        return 0;
    }

    public int getMinY() {
        return -64;
    }

    public int getBaseHeight(int x, int z, Heightmap.Types heightmapType, LevelHeightAccessor level, RandomState random) {
        return 0;
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor level, RandomState random) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void addDebugScreenInfo(List<String> stringsToRender, RandomState random, BlockPos pos) {
    }

    @Nullable
    public Pair<BlockPos, Holder<Structure>> findNearestMapStructure(ServerLevel level, HolderSet<Structure> structures, BlockPos pos, int range, boolean skipKnownStructures) {
        return null;
    }

    public void applyBiomeDecoration(WorldGenLevel world, ChunkAccess chunkAccess, StructureManager structures) {
    }

    public int getSpawnHeight(LevelHeightAccessor level) {
        return 1;
    }

    public void createReferences(WorldGenLevel world, StructureManager structures, ChunkAccess chunk) {
    }
}

