/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RitualDisintegration
extends AbstractRitual {
    @Override
    protected void tick() {
        Level world = this.getWorld();
        if (world.isClientSide) {
            BlockPos pos = this.getPos();
            for (int i = 0; i < 10; ++i) {
                Vec3 particlePos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(0.5, 0.0, 0.5);
                particlePos = particlePos.add(ParticleUtil.pointInSphere().multiply(5.0, 5.0, 5.0));
                world.addParticle(ParticleLineData.createData(this.getCenterColor()), particlePos.x(), particlePos.y(), particlePos.z(), (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            }
        }
        if (!world.isClientSide && world.getGameTime() % 60L == 0L) {
            boolean didWorkOnce = false;
            List entityList = world.getEntitiesOfClass(LivingEntity.class, new AABB(this.getPos()).inflate(5.0), m -> (m.getClassification(false).equals((Object)MobCategory.MONSTER) || m.getType().is(EntityTags.DISINTEGRATION_WHITELIST)) && !(m instanceof Player));
            for (LivingEntity m2 : entityList) {
                int numLesser;
                int numGreater;
                int exp;
                if (m2.getType().is(EntityTags.DISINTEGRATION_BLACKLIST)) continue;
                m2.remove(Entity.RemovalReason.DISCARDED);
                if (!m2.isRemoved()) continue;
                ParticleUtil.spawnPoof((ServerLevel)world, m2.blockPosition());
                if (!m2.shouldDropExperience() || (exp = m2.getExperienceReward((ServerLevel)world, null) * 2) <= 0) continue;
                if ((exp -= (numGreater = exp / 12) * 12) - (numLesser = exp / 3) * 3 > 0) {
                    ++numLesser;
                }
                Vec3 pos = m2.blockPosition().getBottomCenter();
                if (numGreater > 0) {
                    world.addFreshEntity((Entity)new ItemEntity(world, pos.x, pos.y, pos.z, new ItemStack(ItemsRegistry.GREATER_EXPERIENCE_GEM, numGreater)));
                }
                if (numLesser > 0) {
                    world.addFreshEntity((Entity)new ItemEntity(world, pos.x, pos.y, pos.z, new ItemStack(ItemsRegistry.EXPERIENCE_GEM, numLesser)));
                }
                didWorkOnce = true;
            }
            if (didWorkOnce) {
                this.setNeedsSource(true);
            }
        }
    }

    @Override
    public int getSourceCost() {
        return 300;
    }

    @Override
    public String getLangName() {
        return "Disintegration";
    }

    @Override
    public String getLangDescription() {
        return "Destroys nearby monsters and converts them into Experience Gems worth twice as much experience. Monsters destroyed this way will not drop items. This ritual consumes source each time a monster is destroyed.";
    }

    @Override
    public ParticleColor getCenterColor() {
        return ParticleColor.makeRandomColor(220, 20, 20, this.rand);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.DISINTEGRATION);
    }
}

