/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.mixin.ChatComponentAccessor;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class PacketNoSpamChatMessage
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketNoSpamChatMessage> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("no_spam_chat_message"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketNoSpamChatMessage> CODEC = StreamCodec.ofMember(PacketNoSpamChatMessage::toBytes, PacketNoSpamChatMessage::new);
    private final Component message;
    private final int messageChannelId;
    private final boolean overlayMessage;
    private static final int MESSAGE_ID = "ars_nouveau".hashCode();
    private static final MessageSignature AN_SIGNATURE;

    public PacketNoSpamChatMessage(Component message, int messageChannelId, boolean overlayMessage) {
        this.message = message;
        this.messageChannelId = MESSAGE_ID + messageChannelId;
        this.overlayMessage = overlayMessage;
    }

    public PacketNoSpamChatMessage(RegistryFriendlyByteBuf buf) {
        this.message = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
        this.messageChannelId = buf.readInt();
        this.overlayMessage = buf.readBoolean();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)this.message);
        buf.writeInt(this.messageChannelId);
        buf.writeBoolean(this.overlayMessage);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        if (this.overlayMessage) {
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.displayClientMessage(this.message, true);
            }
        } else {
            ChatComponent gui = minecraft.gui.getChat();
            ChatComponentAccessor chatComponentAccessor = (ChatComponentAccessor)gui;
            chatComponentAccessor.getAllMessages().removeIf(m -> m.signature() != null && m.signature().equals((Object)AN_SIGNATURE));
            gui.rescaleChat();
            gui.addMessage((Component)this.message.plainCopy().setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), AN_SIGNATURE, GuiMessageTag.system());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        byte[] bytes = new byte[256];
        Random random = new Random();
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)random.nextInt(127);
        }
        AN_SIGNATURE = new MessageSignature(bytes);
    }
}

