/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.nbt.AbstractData;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PiglinBehavior
extends JarBehavior<Piglin> {
    @Override
    public void use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, MobJarTile tile) {
        if (world.isClientSide) {
            return;
        }
        ItemStack heldStack = player.getItemInHand(handIn);
        Piglin piglin = (Piglin)this.entityFromJar(tile);
        boolean hasCurrency = piglin.getOffhandItem().isPiglinCurrency();
        if (heldStack.isPiglinCurrency() && !hasCurrency && piglin.isAdult()) {
            piglin.setItemInHand(InteractionHand.OFF_HAND, player.getItemInHand(handIn).split(1));
            tile.updateBlock();
        }
    }

    @Override
    public void tick(MobJarTile tile) {
        boolean isAdmiring;
        ItemEntity itemEntity;
        List itemEntities;
        if (tile.getLevel().isClientSide || this.isPowered(tile)) {
            return;
        }
        ExtraData data = new ExtraData(tile.getExtraDataTag());
        Piglin piglin = (Piglin)this.entityFromJar(tile);
        boolean hasCurrency = piglin.getOffhandItem().isPiglinCurrency();
        if (!hasCurrency && piglin.isAdult() && tile.getLevel().getRandom().nextInt(20) == 0 && !(itemEntities = piglin.level.getEntitiesOfClass(ItemEntity.class, new AABB(tile.getBlockPos()).inflate(3.0), Entity::isAlive)).isEmpty() && (itemEntity = (ItemEntity)itemEntities.stream().filter(item -> item.getItem().isPiglinCurrency()).findFirst().orElse(null)) != null) {
            piglin.setItemInHand(InteractionHand.OFF_HAND, itemEntity.getItem().split(1));
            tile.updateBlock();
        }
        boolean bl = isAdmiring = piglin.isAdult() && piglin.getOffhandItem().isPiglinCurrency();
        if (isAdmiring) {
            ++data.ticksWithCurrency;
            if (data.ticksWithCurrency >= 60) {
                data.ticksWithCurrency = 0;
                PiglinBehavior.throwItems(piglin, PiglinBehavior.getBarterResponseItems(piglin));
                piglin.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                tile.updateBlock();
            }
            CompoundTag updateTag = new CompoundTag();
            data.writeToNBT(updateTag);
            tile.setExtraDataTag(updateTag);
        }
    }

    private static List<ItemStack> getBarterResponseItems(Piglin pPiglin) {
        LootTable loottable = pPiglin.level().getServer().reloadableRegistries().getLootTable(BuiltInLootTables.PIGLIN_BARTERING);
        ObjectArrayList list = loottable.getRandomItems(new LootParams.Builder((ServerLevel)pPiglin.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)pPiglin).create(LootContextParamSets.PIGLIN_BARTER));
        return list;
    }

    private static void throwItems(Piglin pPilgin, List<ItemStack> pStacks) {
        List players = pPilgin.level.getEntitiesOfClass(Player.class, pPilgin.getBoundingBox().inflate(3.0));
        if (!players.isEmpty()) {
            PiglinBehavior.throwItemsTowardPlayer(pPilgin, (Player)players.get(0), pStacks);
        } else {
            PiglinBehavior.throwItemsTowardRandomPos(pPilgin, pStacks);
        }
    }

    private static void throwItemsTowardRandomPos(Piglin pPiglin, List<ItemStack> pStacks) {
        PiglinBehavior.throwItemsTowardPos(pPiglin, pStacks, PiglinBehavior.getRandomNearbyPos(pPiglin));
    }

    private static void throwItemsTowardPlayer(Piglin pPiglin, Player pPlayer, List<ItemStack> pStacks) {
        PiglinBehavior.throwItemsTowardPos(pPiglin, pStacks, pPlayer.position());
    }

    private static Vec3 getRandomNearbyPos(Piglin pPiglin) {
        Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)pPiglin, (int)4, (int)2);
        return vec3 == null ? pPiglin.position() : vec3;
    }

    private static void throwItemsTowardPos(Piglin pPiglin, List<ItemStack> pStacks, Vec3 pPos) {
        if (!pStacks.isEmpty()) {
            pPiglin.swing(InteractionHand.OFF_HAND);
            for (ItemStack itemstack : pStacks) {
                BehaviorUtils.throwItem((LivingEntity)pPiglin, (ItemStack)itemstack, (Vec3)pPos.add(0.0, 0.0, 0.0));
            }
        }
    }

    public static class ExtraData
    extends AbstractData {
        boolean hasCurrency;
        int ticksWithCurrency;

        public ExtraData(CompoundTag tag) {
            super(tag);
            this.hasCurrency = tag.getBoolean("hasCurrency");
            this.ticksWithCurrency = tag.getInt("ticksWithCurrency");
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            tag.putBoolean("hasCurrency", this.hasCurrency);
            tag.putInt("ticksWithCurrency", this.ticksWithCurrency);
        }
    }
}

