/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantmentRecipe;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.items.data.ReactiveCasterData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactiveEnchantmentRecipe
extends EnchantmentRecipe {
    public ReactiveEnchantmentRecipe(List<Ingredient> pedestalItems, int sourceCost) {
        super(pedestalItems, EnchantmentRegistry.REACTIVE_ENCHANTMENT, 1, sourceCost);
    }

    @Override
    @NotNull
    public ItemStack assemble(ApparatusRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        ItemStack result = super.assemble(input, lookup);
        ItemStack parchment = ReactiveEnchantmentRecipe.getParchment(input.pedestals());
        AbstractCaster<?> parchmentCaster = SpellCasterRegistry.from(parchment);
        result.set(DataComponentRegistry.REACTIVE_CASTER, (Object)((ReactiveCasterData)new ReactiveCasterData(0, "", false, "", 1).setSpell(parchmentCaster.getSpell())));
        return result;
    }

    @Override
    public boolean matches(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        ItemStack parchment = ReactiveEnchantmentRecipe.getParchment(input.pedestals());
        if (parchment.isEmpty() || SpellCasterRegistry.from(parchment).getSpell().isEmpty()) {
            return false;
        }
        return super.matches(input, level, player);
    }

    @NotNull
    public static ItemStack getParchment(List<ItemStack> pedestalItems) {
        for (ItemStack stack : pedestalItems) {
            if (!(stack.getItem() instanceof SpellParchment)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.REACTIVE_TYPE.get();
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.REACTIVE_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ReactiveEnchantmentRecipe> {
        public static final MapCodec<ReactiveEnchantmentRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(EnchantingApparatusRecipe::pedestalItems), (App)Codec.INT.fieldOf("sourceCost").forGetter(EnchantingApparatusRecipe::sourceCost)).apply((Applicative)instance, ReactiveEnchantmentRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ReactiveEnchantmentRecipe> STREAM = CheatSerializer.create(CODEC);

        @NotNull
        public MapCodec<ReactiveEnchantmentRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ReactiveEnchantmentRecipe> streamCodec() {
            return STREAM;
        }
    }
}

