/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.command;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class DroplessMobsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ars-dropless").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSystemMessage((Component)Component.literal((String)DroplessMobsCommand.listDroplessEntities(((CommandSourceStack)c.getSource()).getServer().reloadableRegistries(), ((CommandSourceStack)c.getSource()).getLevel(), 0).stream().map(e -> BuiltInRegistries.ENTITY_TYPE.getKey(e).toString()).collect(Collectors.joining(","))));
            ((CommandSourceStack)c.getSource()).sendSystemMessage((Component)Component.literal((String)"Listed mobs that produce no drops under naive filtering, open your logs if you want to copy them."));
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"simulate").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"times", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> {
            int times = IntegerArgumentType.getInteger((CommandContext)c, (String)"times");
            ((CommandSourceStack)c.getSource()).sendSystemMessage((Component)Component.literal((String)DroplessMobsCommand.listDroplessEntities(((CommandSourceStack)c.getSource()).getServer().reloadableRegistries(), ((CommandSourceStack)c.getSource()).getLevel(), times).stream().map(e -> BuiltInRegistries.ENTITY_TYPE.getKey(e).toString()).collect(Collectors.joining(","))));
            ((CommandSourceStack)c.getSource()).sendSystemMessage((Component)Component.literal((String)("Listed mobs that produced no drops after " + times + " simulations, open your logs if you want to copy them.")));
            return 1;
        }))));
    }

    public static ObjectArrayList<EntityType<?>> listDroplessEntities(ReloadableServerRegistries.Holder registries, ServerLevel level, int simulations) {
        ANFakePlayer fakePlayer = simulations <= 0 ? null : ANFakePlayer.getPlayer(level);
        DamageSource damageSource = simulations <= 0 ? null : level.damageSources().playerAttack((Player)fakePlayer);
        ObjectArrayList stacks = simulations <= 0 ? null : new ObjectArrayList();
        ObjectArrayList types = new ObjectArrayList();
        block2: for (EntityType ty : BuiltInRegistries.ENTITY_TYPE) {
            Entity e;
            try {
                e = ty.create((Level)level);
                if (e == null) continue;
                if (!(e instanceof LivingEntity)) {
                    e.discard();
                }
            }
            catch (Throwable ignored) {}
            continue;
            LootTable table = registries.getLootTable(e.getType().getDefaultLootTable());
            if (!table.pools.isEmpty()) {
                e.discard();
                continue;
            }
            if (simulations <= 0) {
                types.add((Object)e.getType());
                continue;
            }
            LootParams.Builder ctx = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)e).withParameter(LootContextParams.ORIGIN, (Object)e.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
            ctx = ctx.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)fakePlayer).withLuck(fakePlayer.getLuck());
            for (int i = 0; i < simulations; ++i) {
                stacks.clear();
                stacks.addAll((ObjectList)table.getRandomItems(ctx.create(LootContextParamSets.ENTITY)));
                if (stacks.isEmpty()) continue;
                e.discard();
                continue block2;
            }
            types.add((Object)e.getType());
        }
        return types;
    }
}

