/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RelayCollectorTile
extends RelayTile {
    public RelayCollectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.RELAY_COLLECTOR_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.disabled) {
            return;
        }
        if (!this.level.isClientSide && this.level.getGameTime() % 20L == 0L && this.getSource() <= this.getMaxSource()) {
            List<ISpecialSourceProvider> takeList = SourceUtil.canTakeSource(this.getBlockPos(), this.level, 5);
            for (ISpecialSourceProvider provider : takeList) {
                int transferred;
                if (this.getSource() >= this.getMaxSource()) break;
                if (this.getToPos() != null && this.level.isLoaded(this.getToPos()) && this.level.getBlockEntity(this.getToPos()) == provider.getSource() || this.getFromPos() != null && this.level.isLoaded(this.getFromPos()) && this.level.getBlockEntity(this.getFromPos()) == provider.getSource() || (transferred = this.transferSource(provider.getSource(), this)) <= 0) continue;
                ParticleUtil.spawnFollowProjectile(this.level, provider.getCurrentPos(), this.worldPosition, this.getColor());
            }
        }
    }
}

