/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.registry.JarBehaviorRegistry;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.MobJar;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.data.MobJarData;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobJarTile
extends ModdedTile
implements ITickable,
IDispellable,
ITooltipProvider {
    @Nullable
    public Entity cachedEntity;
    private CompoundTag entityTag;
    private CompoundTag extraDataTag;
    public boolean isVisible = true;

    public MobJarTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.MOB_JAR_TILE, pos, state);
    }

    @Override
    public void tick() {
        try {
            if (this.level.isClientSide && this.cachedEntity != null) {
                Camera camera;
                Vec3 startPos;
                Mob mob;
                if (this.cachedEntity.isRemoved()) {
                    this.removeEntity();
                    return;
                }
                Entity entity = this.cachedEntity;
                if (entity instanceof Mob && !((mob = (Mob)entity) instanceof Bee)) {
                    mob.getLookControl().tick();
                }
                this.isVisible = false;
                Entity entity2 = this.getEntity();
                if (entity2 != null && (startPos = (camera = Minecraft.getInstance().gameRenderer.getMainCamera()).getPosition()).distanceToSqr(this.getBlockPos().getCenter()) <= 4096.0) {
                    AABB aabb = entity2.getBoundingBoxForCulling();
                    for (Entity passenger : entity2.getPassengers()) {
                        aabb = aabb.minmax(passenger.getBoundingBoxForCulling());
                    }
                    if (Double.isFinite(aabb.minX) && Double.isFinite(aabb.minY) && Double.isFinite(aabb.minZ) && Double.isFinite(aabb.maxX) && Double.isFinite(aabb.maxY) && Double.isFinite(aabb.maxZ)) {
                        for (Vec3 endPos : new Vec3[]{new Vec3(aabb.minX, aabb.minY, aabb.minZ), new Vec3(aabb.minX, aabb.minY, aabb.maxZ), new Vec3(aabb.minX, aabb.maxY, aabb.minZ), new Vec3(aabb.minX, aabb.maxY, aabb.maxZ), new Vec3(aabb.maxX, aabb.minY, aabb.minZ), new Vec3(aabb.maxX, aabb.minY, aabb.maxZ), new Vec3(aabb.maxX, aabb.maxY, aabb.minZ), new Vec3(aabb.maxX, aabb.maxY, aabb.maxZ)}) {
                            BlockHitResult result = this.level.clip(new ClipContext(startPos, endPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
                            if (result.getType() != HitResult.Type.MISS && this.getBlockPos() != result.getBlockPos()) continue;
                            this.isVisible = true;
                            break;
                        }
                    } else {
                        this.isVisible = true;
                    }
                }
            }
            this.dispatchBehavior(behavior -> behavior.tick(this));
            this.setChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean setEntityData(@NotNull Entity entity) {
        CompoundTag tag = new CompoundTag();
        if (entity.shouldBeSaved() && entity.save(tag)) {
            this.cachedEntity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)this.level, Function.identity());
            this.cachedEntity.setBoundingBox(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
            this.cachedEntity.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5);
            this.extraDataTag = null;
            this.entityTag = tag;
            if (!this.level.isClientSide) {
                this.invalidateCapabilities();
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(MobJar.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.calculateLight())));
                this.updateBlock();
            }
            return true;
        }
        try {
            this.writeSimple(entity);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setRemoved() {
        super.setRemoved();
        this.entityTag = this.saveEntityToTag(this.getEntity());
        Entity entity = this.getEntity();
        if (entity instanceof Entity) {
            Entity e = entity;
            e.remove(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        }
    }

    public void writeSimple(Entity e) {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", EntityType.getKey((EntityType)e.getType()).toString());
        if (this.level == null) {
            return;
        }
        this.cachedEntity = e.getType().create(this.level);
        assert (this.cachedEntity != null);
        this.cachedEntity.setBoundingBox(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        this.cachedEntity.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5);
        this.extraDataTag = null;
        this.entityTag = tag;
        if (!this.level.isClientSide) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(MobJar.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.calculateLight())));
            this.updateBlock();
        }
    }

    public int calculateLight() {
        if (this.getEntity() == null) {
            return 0;
        }
        if (this.getEntity().isOnFire()) {
            return 15;
        }
        if (this.getEntity() instanceof LightningBolt) {
            return 15;
        }
        AtomicInteger light = new AtomicInteger();
        JarBehaviorRegistry.forEach(this.getEntity(), behavior -> light.set(Math.max(light.get(), behavior.lightLevel(this))));
        return light.get();
    }

    @Nullable
    public Entity getEntity() {
        if (this.entityTag != null && this.cachedEntity == null) {
            this.cachedEntity = MobJarTile.loadEntityFromTag(this.level, this.entityTag);
            if (this.cachedEntity == null) {
                return null;
            }
            this.cachedEntity.setBoundingBox(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
            this.cachedEntity.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5);
        }
        return this.cachedEntity;
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        if (this.entityTag == null || this.level == null) {
            return false;
        }
        Entity entity = MobJarTile.loadEntityFromTag(this.level, this.entityTag);
        if (entity == null || entity.getType().is(EntityTags.JAR_RELEASE_BLACKLIST)) {
            return false;
        }
        entity.setPos((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.0, (double)this.getBlockPos().getZ() + 0.5);
        this.level.addFreshEntity(entity);
        this.removeEntity();
        return true;
    }

    public void removeEntity() {
        Entity entity = this.getEntity();
        if (entity instanceof Entity) {
            Entity e = entity;
            e.remove(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        }
        this.entityTag = null;
        this.cachedEntity = null;
        this.extraDataTag = null;
        this.invalidateCapabilities();
        this.updateBlock();
    }

    public CompoundTag getExtraDataTag() {
        return this.extraDataTag == null ? new CompoundTag() : this.extraDataTag;
    }

    public void setExtraDataTag(CompoundTag tag) {
        this.extraDataTag = tag;
        this.setChanged();
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.entityTag != null || this.cachedEntity != null) {
            this.cachedEntity = this.getEntity();
            if (this.cachedEntity != null) {
                try {
                    tag.put("entityTag", (Tag)this.saveEntityToTag(this.cachedEntity));
                    if (tag.getCompound("entityTag").contains("id")) {
                        tag.putString("entityId", tag.getCompound("entityTag").getString("id"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.extraDataTag != null) {
            tag.put("extraMobData", (Tag)this.extraDataTag);
        }
    }

    protected void loadAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("entityTag")) {
            this.entityTag = pTag.getCompound("entityTag");
            this.cachedEntity = null;
        }
        this.extraDataTag = pTag.getCompound("extraMobData");
    }

    @Override
    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        this.cachedEntity = null;
        this.entityTag = null;
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public void dispatchBehavior(Consumer<JarBehavior<? extends Entity>> consumer) {
        Entity entity = this.getEntity();
        if (entity == null) {
            return;
        }
        JarBehaviorRegistry.forEach(entity, consumer);
    }

    public static Entity loadEntityFromTag(Level level, CompoundTag tag) {
        String id;
        Optional type;
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, Function.identity());
        if (entity == null && (type = EntityType.byString((String)(id = tag.getString("id")))).isPresent()) {
            entity = ((EntityType)type.get()).create(level);
        }
        return entity;
    }

    public CompoundTag saveEntityToTag(Entity entity) {
        CompoundTag tag = new CompoundTag();
        if (entity != null) {
            entity.save(tag);
            if (tag.isEmpty()) {
                tag.putString("id", EntityType.getKey((EntityType)entity.getType()).toString());
            }
        }
        return tag;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        Entity entity = this.getEntity();
        if (entity != null) {
            JarBehaviorRegistry.forEach(entity, behavior -> behavior.getTooltip(this, tooltip));
        }
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        MobJarData jar = (MobJarData)pComponentInput.getOrDefault(DataComponentRegistry.MOB_JAR, (Object)new MobJarData(Optional.empty(), Optional.empty()));
        this.entityTag = jar.entityTag().orElse(null);
        this.extraDataTag = jar.extraDataTag().orElse(null);
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        if (this.entityTag != null && !this.entityTag.isEmpty() || this.extraDataTag != null && !this.extraDataTag.isEmpty()) {
            pComponents.set(DataComponentRegistry.MOB_JAR, (Object)new MobJarData(this.entityTag, this.extraDataTag));
        }
    }

    public <T, C> T getEntityCapability(EntityCapability<T, C> type, C context) {
        Entity entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return (T)entity.getCapability(type, context);
    }

    public static class SavingItemHandler
    implements IItemHandler {
        MobJarTile tile;
        IItemHandler inner;

        private SavingItemHandler(MobJarTile tile, IItemHandler inner) {
            this.tile = tile;
            this.inner = inner;
        }

        public static SavingItemHandler of(MobJarTile tile, IItemHandler inner) {
            return inner == null ? null : new SavingItemHandler(tile, inner);
        }

        public int getSlots() {
            return this.inner.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inner.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            Entity entity;
            ItemStack result = this.inner.insertItem(slot, stack, simulate);
            if (!simulate && (entity = this.tile.getEntity()) != null) {
                this.tile.entityTag = this.tile.saveEntityToTag(entity);
            }
            return result;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            Entity entity;
            ItemStack result = this.inner.extractItem(slot, amount, simulate);
            if (!simulate && (entity = this.tile.getEntity()) != null) {
                this.tile.entityTag = this.tile.saveEntityToTag(entity);
            }
            return result;
        }

        public int getSlotLimit(int slot) {
            return this.inner.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.inner.isItemValid(slot, stack);
        }
    }
}

