/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RedstoneRelayTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;

public class RedstoneRelay
extends TickableModBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;

    public RedstoneRelay() {
        this(RedstoneRelay.defaultProperties().noOcclusion());
    }

    public RedstoneRelay(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        BlockEntity blockEntity;
        Direction facing = (Direction)pBlockState.getValue((Property)FACING);
        if (pSide == facing.getOpposite() || !((blockEntity = pBlockAccess.getBlockEntity(pPos)) instanceof RedstoneRelayTile)) {
            return 0;
        }
        RedstoneRelayTile redstoneRelayTile = (RedstoneRelayTile)blockEntity;
        return redstoneRelayTile.getOutputPower();
    }

    public int getDirectSignal(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        return this.getSignal(pState, pLevel, pPos, pDirection);
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        this.updatePower(pLevel, pPos, pState);
    }

    public void updatePower(Level pLevel, BlockPos pPos, BlockState pState) {
        int power = 0;
        Direction direction = (Direction)pState.getValue((Property)FACING);
        power = pLevel.getSignal(pPos.relative((Direction)pState.getValue((Property)FACING)), direction);
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof RedstoneRelayTile) {
            RedstoneRelayTile redstoneRelayTile = (RedstoneRelayTile)blockEntity;
            redstoneRelayTile.setLocalPower(power);
        }
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.is(pNewState.getBlock())) {
            return;
        }
        if (pLevel.isClientSide) {
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
            return;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof RedstoneRelayTile)) {
            return;
        }
        RedstoneRelayTile thisTile = (RedstoneRelayTile)blockEntity;
        BlockPos worldPosition = pPos.immutable();
        for (BlockPos pos : thisTile.powering) {
            BlockEntity blockEntity2 = pLevel.getBlockEntity(pos);
            if (!(blockEntity2 instanceof RedstoneRelayTile)) continue;
            RedstoneRelayTile redstoneRelayTile = (RedstoneRelayTile)blockEntity2;
            redstoneRelayTile.onParentRemoved(worldPosition);
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
        this.updatePower(pLevel, pPos, pState);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new RedstoneRelayTile(pPos, pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWER});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }
}

