/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.world;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.PantomimeTimeline;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.method.MethodPantomime;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class PantomimeRenderer {
    public static void renderOutline(PoseStack poseStack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ICasterTool)) {
            return;
        }
        AbstractCaster<?> caster = SpellCasterRegistry.from(heldItem);
        if (caster == null) {
            return;
        }
        Spell selectedSpell = caster.getSpell();
        AbstractCastMethod abstractCastMethod = selectedSpell.getCastMethod();
        if (!(abstractCastMethod instanceof MethodPantomime)) {
            return;
        }
        MethodPantomime pantomime = (MethodPantomime)abstractCastMethod;
        SpellStats stats = new SpellStats.Builder().setAugments(selectedSpell.getAugments(0, (LivingEntity)player)).addItemsFromEntity((LivingEntity)player).build(MethodPantomime.INSTANCE, null, player.level, (LivingEntity)player, SpellContext.fromEntity(selectedSpell, (LivingEntity)player, heldItem));
        if (!stats.isSensitive()) {
            return;
        }
        BlockPos pos = pantomime.findPosition((LivingEntity)player, stats).getBlockPos();
        poseStack.pushPose();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        poseStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        RenderType lineType = RenderType.lines();
        OutlineBufferSource buffer = Minecraft.getInstance().renderBuffers().outlineBufferSource();
        VertexConsumer lines = buffer.getBuffer(lineType);
        int color = ((PantomimeTimeline)selectedSpell.particleTimeline().get((IParticleTimelineType)ParticleTimelineRegistry.PANTOMIME_TIMELINE.get())).onResolvingEffect.particleOptions().colorProp().color().getColor();
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)lines, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (float)((float)FastColor.ARGB32.red((int)color) / 255.0f), (float)((float)FastColor.ARGB32.green((int)color) / 255.0f), (float)((float)FastColor.ARGB32.blue((int)color) / 255.0f), (float)1.0f);
        poseStack.popPose();
    }
}

