/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.renderer.LiquidBlockVertexConsumer;
import com.hollingsworth.arsnouveau.client.renderer.PlanariumRenderingWorld;
import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.PlanariumModel;
import com.hollingsworth.arsnouveau.client.renderer.world.CulledStatePos;
import com.hollingsworth.arsnouveau.common.block.tile.MirrorWeaveTile;
import com.hollingsworth.arsnouveau.common.block.tile.PlanariumTile;
import com.hollingsworth.arsnouveau.common.mixin.structure.StructureTemplateAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PlanariumRenderer
implements BlockEntityRenderer<PlanariumTile> {
    public static List<WeakReference<PlanariumTile>> deferredRenders = new ArrayList<WeakReference<PlanariumTile>>();
    public static Map<ResourceKey<Level>, StructureRenderData> structureRenderData = new WeakHashMap<ResourceKey<Level>, StructureRenderData>();
    public static Direction[] DIRECTIONS = Direction.values();
    public static float pad = 0.0025f;
    public static float scale = (1.0f - 2.0f * pad) / 32.0f;
    public static float offset = pad + (1.0f - 2.0f * pad - 32.0f * scale) * 0.5f;

    public PlanariumRenderer(BlockEntityRendererProvider.Context blockRenderDispatcher) {
    }

    public void render(PlanariumTile blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.getTemplate() == null) {
            return;
        }
        structureRenderData.computeIfAbsent(blockEntity.key, be -> {
            StructureRenderData data = new StructureRenderData(blockEntity.getTemplate(), blockEntity.lastUpdated);
            PlanariumRenderer.generateRender(data, blockEntity.getLevel(), blockEntity.getBlockPos(), Minecraft.getInstance().gameRenderer.getMainCamera().getPosition());
            return data;
        });
        deferredRenders.add(new WeakReference<PlanariumTile>(blockEntity));
        StructureRenderData renderData = structureRenderData.get(blockEntity.key);
        if (renderData != null) {
            BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            Level originalLevel = dispatcher.level;
            dispatcher.prepare(originalLevel, Minecraft.getInstance().getBlockEntityRenderDispatcher().camera, Minecraft.getInstance().hitResult);
            for (BlockEntity fakeTile : renderData.fakeRenderingWorld.blockEntityMap.values()) {
                block7: {
                    BlockPos pos = fakeTile.getBlockPos();
                    poseStack.pushPose();
                    poseStack.translate(offset, offset, offset);
                    poseStack.scale(scale, scale, scale);
                    poseStack.translate((float)pos.getX(), (float)(26 + pos.getY()), (float)pos.getZ());
                    BlockEntityRenderer renderer = dispatcher.getRenderer(fakeTile);
                    if (fakeTile instanceof PlanariumTile) {
                        PlanariumTile planariumTile = (PlanariumTile)fakeTile;
                        planariumTile.key = null;
                    }
                    if (renderer != null) {
                        try {
                            renderer.render(fakeTile, partialTick, poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
                        }
                        catch (Exception e) {
                            if (fakeTile.getLevel().getGameTime() % 100L != 0L && FMLEnvironment.production) break block7;
                            e.printStackTrace();
                        }
                    }
                }
                poseStack.popPose();
            }
        }
    }

    public static void updateCulling(CulledStatePos culledStatePos, PlanariumRenderingWorld fakeRenderingWorld) {
        boolean disableEntireRender = true;
        culledStatePos.setSkipRender(false);
        for (Direction direction : DIRECTIONS) {
            BlockPos adjacentPos = culledStatePos.pos.relative(direction);
            BlockState adjacentState = fakeRenderingWorld.getBlockState(adjacentPos);
            culledStatePos.setRenderDirection(direction, false);
            BlockEntity blockEntity = fakeRenderingWorld.getBlockEntity(adjacentPos);
            if (blockEntity instanceof MirrorWeaveTile) {
                MirrorWeaveTile neighborTile = (MirrorWeaveTile)blockEntity;
                adjacentState = neighborTile.getStateForCulling();
            }
            VoxelShape blockingShape = adjacentState.getOcclusionShape((BlockGetter)fakeRenderingWorld, adjacentPos);
            if (!Block.shouldRenderFace((BlockState)culledStatePos.state, (BlockGetter)fakeRenderingWorld, (BlockPos)culledStatePos.pos, (Direction)direction, (BlockPos)adjacentPos)) continue;
            if (!adjacentState.canOcclude()) {
                culledStatePos.setRenderDirection(direction, true);
                disableEntireRender = false;
                continue;
            }
            if (!adjacentState.canOcclude() || Shapes.blockOccudes((VoxelShape)Shapes.block(), (VoxelShape)blockingShape, (Direction)direction)) continue;
            culledStatePos.setRenderDirection(direction, true);
            disableEntireRender = false;
        }
        culledStatePos.setSkipRender(disableEntireRender);
    }

    public static void tesselateBlock(CulledStatePos tile, ModelBlockRenderer blockRenderer, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, RandomSource random, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        boolean bl;
        block11: {
            block10: {
                if (!Minecraft.useAmbientOcclusion()) break block10;
                switch (model.useAmbientOcclusion(state, modelData, renderType)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case TRUE: {
                        break;
                    }
                    case DEFAULT: {
                        if (state.getLightEmission((BlockGetter)level, pos) == 0) {
                            break;
                        }
                        break block10;
                    }
                    case FALSE: {
                        break block10;
                    }
                }
                bl = true;
                break block11;
            }
            bl = false;
        }
        boolean flag = bl;
        Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
        poseStack.translate(vec3.x, vec3.y, vec3.z);
        try {
            if (flag) {
                PlanariumRenderer.tesselateWithAO(tile, blockRenderer, level, model, state, pos, poseStack, consumer, random, seed, packedOverlay, modelData, renderType);
            } else {
                PlanariumRenderer.tesselateWithoutAO(tile, blockRenderer, level, model, state, pos, poseStack, consumer, random, seed, packedOverlay, modelData, renderType);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Block model being tesselated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)level, (BlockPos)pos, (BlockState)state);
            crashreportcategory.setDetail("Using AO", (Object)flag);
            throw new ReportedException(crashreport);
        }
    }

    public static void tesselateWithoutAO(CulledStatePos tile, ModelBlockRenderer renderer, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, RandomSource random, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        BitSet bitset = new BitSet(3);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (Direction direction : DIRECTIONS) {
            if (!tile.shouldRenderFace(direction)) continue;
            random.setSeed(seed);
            List list = model.getQuads(state, direction, random, modelData, renderType);
            if (list.isEmpty()) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
            int i = PlanariumRenderer.getLightColor(level, state, (BlockPos)blockpos$mutableblockpos);
            PlanariumRenderer.renderModelFaceFlat(renderer, level, state, pos, i, packedOverlay, false, poseStack, consumer, list, bitset);
        }
        random.setSeed(seed);
        List list1 = model.getQuads(state, null, random, modelData, renderType);
        if (!list1.isEmpty()) {
            PlanariumRenderer.renderModelFaceFlat(renderer, level, state, pos, -1, packedOverlay, true, poseStack, consumer, list1, bitset);
        }
    }

    public static int getLightColor(BlockAndTintGetter level, BlockState state, BlockPos pos) {
        int k;
        if (state.emissiveRendering((BlockGetter)level, pos)) {
            return 0xF000F0;
        }
        int i = level.getBrightness(LightLayer.SKY, pos);
        int j = level.getBrightness(LightLayer.BLOCK, pos);
        if (j < (k = state.getLightEmission((BlockGetter)level, pos))) {
            j = k;
        }
        return i << 20 | j << 4;
    }

    private static void renderModelFaceFlat(ModelBlockRenderer renderer, BlockAndTintGetter level, BlockState state, BlockPos pos, int packedLight, int packedOverlay, boolean repackLight, PoseStack poseStack, VertexConsumer consumer, List<BakedQuad> quads, BitSet shapeFlags) {
        for (BakedQuad bakedquad : quads) {
            if (repackLight) {
                renderer.calculateShape(level, state, pos, bakedquad.getVertices(), bakedquad.getDirection(), null, shapeFlags);
                BlockPos blockpos = shapeFlags.get(0) ? pos.relative(bakedquad.getDirection()) : pos;
                packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockState)state, (BlockPos)blockpos);
            }
            float f = level.getShade(bakedquad.getDirection(), bakedquad.isShade());
            renderer.putQuadData(level, state, pos, consumer, poseStack.last(), bakedquad, f, f, f, f, packedLight, packedLight, packedLight, packedLight, packedOverlay);
        }
    }

    public static void tesselateWithAO(CulledStatePos tile, ModelBlockRenderer blockRenderer, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, RandomSource random, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        float[] afloat = new float[DIRECTIONS.length * 2];
        BitSet bitset = new BitSet(3);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (Direction direction : DIRECTIONS) {
            if (!tile.shouldRenderFace(direction)) continue;
            random.setSeed(seed);
            List list = model.getQuads(state, direction, random, modelData, renderType);
            if (list.isEmpty()) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
            PlanariumRenderer.renderModelFaceAO(blockRenderer, level, state, pos, poseStack, consumer, list, afloat, bitset, packedOverlay);
        }
        random.setSeed(seed);
        List list1 = model.getQuads(state, null, random, modelData, renderType);
        if (!list1.isEmpty()) {
            PlanariumRenderer.renderModelFaceAO(blockRenderer, level, state, pos, poseStack, consumer, list1, afloat, bitset, packedOverlay);
        }
    }

    private static void renderModelFaceAO(ModelBlockRenderer blockRenderer, BlockAndTintGetter level, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, List<BakedQuad> quads, float[] shape, BitSet shapeFlags, int packedOverlay) {
        ModelBlockRenderer.AmbientOcclusionFace aoFace = new ModelBlockRenderer.AmbientOcclusionFace();
        for (BakedQuad bakedquad : quads) {
            blockRenderer.calculateShape(level, state, pos, bakedquad.getVertices(), bakedquad.getDirection(), shape, shapeFlags);
            if (!ClientHooks.calculateFaceWithoutAO((BlockAndTintGetter)level, (BlockState)state, (BlockPos)pos, (BakedQuad)bakedquad, (boolean)shapeFlags.get(0), (float[])aoFace.brightness, (int[])aoFace.lightmap)) {
                aoFace.calculate(level, state, pos, bakedquad.getDirection(), shape, shapeFlags, bakedquad.isShade());
            }
            blockRenderer.putQuadData(level, state, pos, consumer, poseStack.last(), bakedquad, aoFace.brightness[0], aoFace.brightness[1], aoFace.brightness[2], aoFace.brightness[3], aoFace.lightmap[0], aoFace.lightmap[1], aoFace.lightmap[2], aoFace.lightmap[3], packedOverlay);
        }
    }

    public static GenericItemBlockRenderer getISTER() {
        return new GenericItemBlockRenderer(new PlanariumModel(false));
    }

    public static void buildRender(PlanariumTile tile, PoseStack poseStack, Player player) {
        if (tile == null) {
            return;
        }
        BlockPos renderPos = tile.getBlockPos();
        renderPos = renderPos.above();
        StructureRenderData data = structureRenderData.get(tile.key);
        if (PlanariumRenderer.shouldUpdateRender(data, tile)) {
            PlanariumRenderer.clearByteBuffers(data);
            data = new StructureRenderData(tile.getTemplate(), tile.lastUpdated);
            structureRenderData.put(tile.key, data);
            PlanariumRenderer.generateRender(data, player.level(), renderPos, Minecraft.getInstance().gameRenderer.getMainCamera().getPosition());
            data.lastUpdatedAt = tile.lastUpdated;
        }
    }

    public static boolean shouldUpdateRender(StructureRenderData data, PlanariumTile planariumTile) {
        return data.lastUpdatedAt < planariumTile.lastUpdated;
    }

    public static void clearByteBuffers(StructureRenderData data) {
        for (Map.Entry<RenderType, ByteBufferBuilder> entry : data.builders.entrySet()) {
            entry.getValue().clear();
        }
        data.bufferBuilders.clear();
        data.sortStates.clear();
        data.meshDatas.clear();
    }

    public static void generateRender(StructureRenderData data, Level level, BlockPos renderPos, Vec3 cameraPosition) {
        BufferBuilder builder;
        float pad = 0.0025f;
        float scale = (1.0f - 2.0f * pad) / 32.0f;
        float offset = pad + (1.0f - 2.0f * pad - 32.0f * scale) * 0.5f;
        ArrayList<CulledStatePos> statePosCache = data.statePosCache;
        Map<RenderType, VertexBuffer> vertexBuffers = data.vertexBuffers;
        if (statePosCache == null || statePosCache.isEmpty()) {
            return;
        }
        PoseStack matrix = new PoseStack();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer modelBlockRenderer = dispatcher.getModelRenderer();
        RandomSource random = RandomSource.create();
        PlanariumRenderer.clearByteBuffers(data);
        for (CulledStatePos pos : statePosCache) {
            BlockState renderState = data.fakeRenderingWorld.getBlockState(pos.pos);
            if (renderState.isAir() || !PlanariumRenderer.isModelRender(pos.state) && pos.state.getFluidState().isEmpty()) continue;
            if (pos.needsUpdate()) {
                PlanariumRenderer.updateCulling(pos, data.fakeRenderingWorld);
                pos.setNeedsUpdate(false);
            }
            if (pos.shouldSkipRender()) continue;
            BakedModel ibakedmodel = dispatcher.getBlockModel(renderState);
            matrix.pushPose();
            matrix.translate(offset, offset, offset);
            matrix.scale(scale, scale, scale);
            matrix.translate((float)pos.pos.getX(), (float)(pos.pos.getY() + 26), (float)pos.pos.getZ());
            for (RenderType renderType : ibakedmodel.getRenderTypes(renderState, random, ModelData.EMPTY)) {
                if (renderType.equals(RenderType.cutout()) && renderState.getShape((BlockGetter)level, pos.pos.offset((Vec3i)renderPos)).equals(Shapes.block())) {
                    renderType = RenderType.translucent();
                }
                builder = data.bufferBuilders.computeIfAbsent(renderType, rt -> new BufferBuilder(data.getByteBuffer((RenderType)rt), rt.mode(), rt.format()));
                try {
                    FluidState fluidState = pos.state.getFluidState();
                    if (!fluidState.isEmpty()) {
                        Minecraft.getInstance().getBlockRenderer().renderLiquid(pos.pos, (BlockAndTintGetter)data.fakeRenderingWorld, (VertexConsumer)new LiquidBlockVertexConsumer((VertexConsumer)builder, matrix, pos.pos), pos.state, fluidState);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (renderState.getRenderShape() != RenderShape.MODEL || !renderState.getFluidState().isEmpty() || !PlanariumRenderer.isModelRender(pos.state)) continue;
                try {
                    PlanariumRenderer.tesselateBlock(pos, modelBlockRenderer, (BlockAndTintGetter)data.fakeRenderingWorld, ibakedmodel, renderState, pos.pos.offset((Vec3i)renderPos), matrix, (VertexConsumer)builder, random, renderState.getSeed(pos.pos.offset((Vec3i)renderPos)), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            matrix.popPose();
        }
        Vec3 subtracted = cameraPosition.subtract((double)renderPos.getX(), (double)renderPos.getY(), (double)renderPos.getZ());
        Vector3f sortPos = new Vector3f((float)subtracted.x, (float)subtracted.y, (float)subtracted.z);
        for (Map.Entry<RenderType, BufferBuilder> entry : data.bufferBuilders.entrySet()) {
            RenderType renderType = entry.getKey();
            ByteBufferBuilder byteBufferBuilder = data.getByteBuffer(renderType);
            builder = entry.getValue();
            Map<RenderType, MeshData> meshDatas = data.meshDatas;
            if (meshDatas.containsKey(renderType) && meshDatas.get(renderType) != null) {
                meshDatas.get(renderType).close();
            }
            meshDatas.put(renderType, builder.build());
            if (!meshDatas.containsKey(renderType) || meshDatas.get(renderType) == null) continue;
            data.sortStates.put(renderType, meshDatas.get(renderType).sortQuads(byteBufferBuilder, VertexSorting.byDistance(v -> -sortPos.distanceSquared((Vector3fc)v))));
            VertexBuffer vertexBuffer = vertexBuffers.get(entry.getKey());
            vertexBuffer.bind();
            vertexBuffer.upload(meshDatas.get(renderType));
            VertexBuffer.unbind();
        }
    }

    public static boolean isModelRender(BlockState state) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel ibakedmodel = dispatcher.getBlockModel(state);
        for (Direction direction : Direction.values()) {
            if (!ibakedmodel.getQuads(state, direction, RandomSource.create()).isEmpty()) {
                return true;
            }
            if (ibakedmodel.getQuads(state, null, RandomSource.create()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void drawRender(PlanariumTile tile, PoseStack poseStack, Matrix4f projectionMatrix, Matrix4f modelViewMatrix, Player player) {
        if (tile == null) {
            return;
        }
        StructureRenderData data = structureRenderData.get(tile.key);
        if (data == null || data.vertexBuffers == null) {
            return;
        }
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        BlockPos renderPos = tile.getBlockPos();
        if (data.sortCounter > 20) {
            PlanariumRenderer.sortAll(data, renderPos);
            data.sortCounter = 0;
        } else {
            ++data.sortCounter;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate((double)renderPos.getX() - projectedView.x(), (double)renderPos.getY() - projectedView.y(), (double)renderPos.getZ() - projectedView.z());
        ArrayList<RenderType> drawSet = new ArrayList<RenderType>();
        drawSet.add(RenderType.solid());
        drawSet.add(RenderType.cutout());
        drawSet.add(RenderType.cutoutMipped());
        drawSet.add(RenderType.translucent());
        drawSet.add(RenderType.tripwire());
        try {
            Iterator iterator = drawSet.iterator();
            while (iterator.hasNext()) {
                RenderType renderType;
                RenderType drawRenderType = renderType = (RenderType)iterator.next();
                VertexBuffer vertexBuffer = data.vertexBuffers.get(renderType);
                if (vertexBuffer.getFormat() == null) continue;
                drawRenderType.setupRenderState();
                vertexBuffer.bind();
                vertexBuffer.drawWithShader(poseStack.last().pose(), new Matrix4f((Matrix4fc)projectionMatrix), RenderSystem.getShader());
                VertexBuffer.unbind();
                drawRenderType.clearRenderState();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        poseStack.popPose();
        BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
        Level originalLevel = dispatcher.level;
        dispatcher.prepare(originalLevel, Minecraft.getInstance().getBlockEntityRenderDispatcher().camera, Minecraft.getInstance().hitResult);
    }

    public static void sortAll(StructureRenderData data, BlockPos lookingAt) {
        for (Map.Entry<RenderType, MeshData.SortState> entry : data.sortStates.entrySet()) {
            RenderType renderType = entry.getKey();
            ByteBufferBuilder.Result renderedBuffer = PlanariumRenderer.sort(data, lookingAt, renderType);
            VertexBuffer vertexBuffer = data.vertexBuffers.get(renderType);
            vertexBuffer.bind();
            vertexBuffer.uploadIndexBuffer(renderedBuffer);
            VertexBuffer.unbind();
        }
    }

    public static ByteBufferBuilder.Result sort(StructureRenderData data, BlockPos lookingAt, RenderType renderType) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 camPos = camera.getPosition();
        Vector3f sortPos = new Vector3f((float)camPos.x, (float)camPos.y, (float)camPos.z);
        return data.sortStates.get(renderType).buildSortedIndexBuffer(data.getByteBuffer(renderType), VertexSorting.byDistance(v -> -sortPos.distanceSquared((Vector3fc)v)));
    }

    public static class StructureRenderData {
        public ArrayList<CulledStatePos> statePosCache;
        public Map<RenderType, MeshData.SortState> sortStates = new HashMap<RenderType, MeshData.SortState>();
        public Map<RenderType, MeshData> meshDatas = new HashMap<RenderType, MeshData>();
        public PlanariumRenderingWorld fakeRenderingWorld;
        public int sortCounter;
        public final Map<RenderType, ByteBufferBuilder> builders = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(renderType -> renderType, type -> new ByteBufferBuilder(type.bufferSize())));
        public Map<RenderType, VertexBuffer> vertexBuffers = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(renderType -> renderType, type -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
        public final Map<RenderType, BufferBuilder> bufferBuilders = new HashMap<RenderType, BufferBuilder>();
        public long lastUpdatedAt;

        public StructureRenderData(StructureTemplate structureTemplate, long lastUpdatedAt) {
            StructureTemplateAccessor accessor = (StructureTemplateAccessor)structureTemplate;
            List<StructureTemplate.Palette> palettes = accessor.getPalettes();
            if (palettes.isEmpty()) {
                return;
            }
            StructureTemplate.Palette palette = palettes.get(0);
            this.statePosCache = new ArrayList();
            for (StructureTemplate.StructureBlockInfo blockInfo : palette.blocks()) {
                this.statePosCache.add(new CulledStatePos(blockInfo.state(), blockInfo.pos(), blockInfo.nbt()));
            }
            this.fakeRenderingWorld = new PlanariumRenderingWorld((Level)Minecraft.getInstance().level, this.statePosCache);
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public ByteBufferBuilder getByteBuffer(RenderType renderType) {
            return this.builders.get(renderType);
        }
    }
}

