/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.item;

import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.items.MobJarItem;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class MobJarItemRenderer
extends GeoItemRenderer<MobJarItem> {
    private static MobJarTile jarTile;

    public MobJarItemRenderer() {
        super(new GenericModel("mob_jar"));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        if (transformType == ItemDisplayContext.GUI) {
            pPackedLight = 0xF000F0;
            pPackedOverlay = 0xF000F0;
        }
        super.renderByItem(stack, transformType, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        jarTile = new MobJarTile(Minecraft.getInstance().player.getOnPos().above(), BlockRegistry.MOB_JAR.defaultBlockState());
        Entity entity = MobJarItem.fromItem(stack, (Level)Minecraft.getInstance().level);
        if (entity == null) {
            return;
        }
        jarTile.setLevel((Level)Minecraft.getInstance().level);
        MobJarItemRenderer.jarTile.cachedEntity = entity;
        entity.setPos((double)Minecraft.getInstance().player.getOnPos().getX(), (double)(Minecraft.getInstance().player.getOnPos().getY() + 1), (double)Minecraft.getInstance().player.getOnPos().getZ());
        pPoseStack.pushPose();
        pPoseStack.translate(0.0, 0.5, 0.0);
        Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)jarTile, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        pPoseStack.popPose();
    }
}

