/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.google.common.base.Suppliers;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.client.container.IAutoFillTerminal;
import com.hollingsworth.arsnouveau.client.jei.AlakarkinosRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.AliasProvider;
import com.hollingsworth.arsnouveau.client.jei.ApparatusEnchantingRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.ArmorUpgradeRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.BuddingConversionRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.CraftingTerminalTransferHandler;
import com.hollingsworth.arsnouveau.client.jei.CrushRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.DyeRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.EnchantingApparatusRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.GlyphRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.ImbuementRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.ScryRitualRecipeCategory;
import com.hollingsworth.arsnouveau.common.crafting.recipes.AlakarkinosRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ArmorUpgradeRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.BuddingConversionRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.DyeRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantmentRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ScryRitualRecipe;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIArsNouveauPlugin
implements IModPlugin {
    public static final Supplier<RecipeType<RecipeHolder<GlyphRecipe>>> GLYPH_RECIPE_TYPE = JEIArsNouveauPlugin.createFromDeferredVanilla(RecipeRegistry.GLYPH_TYPE);
    public static final Supplier<RecipeType<RecipeHolder<EnchantingApparatusRecipe>>> ENCHANTING_APP_RECIPE_TYPE = JEIArsNouveauPlugin.createFromDeferredVanilla(RecipeRegistry.APPARATUS_TYPE);
    public static final Supplier<RecipeType<RecipeHolder<EnchantmentRecipe>>> ENCHANTING_RECIPE_TYPE = JEIArsNouveauPlugin.createFromDeferredVanilla(RecipeRegistry.ENCHANTMENT_TYPE);
    public static final Supplier<RecipeType<RecipeHolder<ArmorUpgradeRecipe>>> ARMOR_RECIPE_TYPE = JEIArsNouveauPlugin.createFromDeferredVanilla(RecipeRegistry.ARMOR_UPGRADE_TYPE);
    public static final Supplier<RecipeType<RecipeHolder<ImbuementRecipe>>> IMBUEMENT_RECIPE_TYPE = JEIArsNouveauPlugin.createFromDeferredVanilla(RecipeRegistry.IMBUEMENT_TYPE);
    public static final Supplier<RecipeType<RecipeHolder<CrushRecipe>>> CRUSH_RECIPE_TYPE = JEIArsNouveauPlugin.createFromDeferredVanilla(RecipeRegistry.CRUSH_TYPE);
    public static final Supplier<RecipeType<RecipeHolder<BuddingConversionRecipe>>> BUDDING_CONVERSION_RECIPE_TYPE = JEIArsNouveauPlugin.createFromDeferredVanilla(RecipeRegistry.BUDDING_CONVERSION_TYPE);
    public static final Supplier<RecipeType<RecipeHolder<ScryRitualRecipe>>> SCRY_RITUAL_RECIPE_TYPE = JEIArsNouveauPlugin.createFromDeferredVanilla(RecipeRegistry.SCRY_RITUAL_TYPE);
    public static final Supplier<RecipeType<RecipeHolder<AlakarkinosRecipe>>> ALAKARKINOS_RECIPE_TYPE = JEIArsNouveauPlugin.createFromDeferredVanilla(RecipeRegistry.ALAKARKINOS_RECIPE_TYPE);
    private static IJeiRuntime jeiRuntime;

    private static <R extends Recipe<?>> Supplier<RecipeType<RecipeHolder<R>>> createFromDeferredVanilla(Supplier<? extends net.minecraft.world.item.crafting.RecipeType<R>> deferredVanillaRecipeType) {
        return Suppliers.memoize(() -> RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)deferredVanillaRecipeType.get())));
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ArsNouveau.prefix("main");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new GlyphRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new CrushRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ImbuementRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new EnchantingApparatusRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ApparatusEnchantingRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ArmorUpgradeRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new BuddingConversionRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ScryRitualRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new AlakarkinosRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        ArrayList<RecipeHolder> recipeList = new ArrayList<RecipeHolder>();
        ArrayList<RecipeHolder> apparatus = new ArrayList<RecipeHolder>();
        ArrayList<RecipeHolder> enchantments = new ArrayList<RecipeHolder>();
        ArrayList<RecipeHolder> crushRecipes = new ArrayList<RecipeHolder>();
        ArrayList<RecipeHolder> armorUpgrades = new ArrayList<RecipeHolder>();
        List imbuementRecipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.IMBUEMENT_TYPE.get()).stream().toList();
        ArrayList<RecipeHolder> buddingConversionRecipes = new ArrayList<RecipeHolder>();
        ArrayList<RecipeHolder> scryRitualRecipes = new ArrayList<RecipeHolder>();
        ArrayList<RecipeHolder> alakarkinosRecipes = new ArrayList<RecipeHolder>();
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        for (RecipeHolder h : manager.getRecipes().stream().toList()) {
            EnchantingApparatusRecipe enchantingApparatusRecipe;
            Recipe i = h.value();
            if (i instanceof GlyphRecipe) {
                recipeList.add(h);
            }
            if (i instanceof EnchantmentRecipe) {
                enchantments.add(h);
            } else if (i instanceof ArmorUpgradeRecipe) {
                armorUpgrades.add(h);
            } else if (i instanceof EnchantingApparatusRecipe && !(enchantingApparatusRecipe = (EnchantingApparatusRecipe)i).excludeJei()) {
                apparatus.add(h);
            }
            if (i instanceof CrushRecipe) {
                crushRecipes.add(h);
            }
            if (i instanceof BuddingConversionRecipe) {
                buddingConversionRecipes.add(h);
            }
            if (i instanceof ScryRitualRecipe) {
                scryRitualRecipes.add(h);
            }
            if (!(i instanceof AlakarkinosRecipe)) continue;
            alakarkinosRecipes.add(h);
        }
        registry.addRecipes(GLYPH_RECIPE_TYPE.get(), recipeList);
        registry.addRecipes(CRUSH_RECIPE_TYPE.get(), crushRecipes);
        registry.addRecipes(ENCHANTING_APP_RECIPE_TYPE.get(), apparatus);
        registry.addRecipes(ENCHANTING_RECIPE_TYPE.get(), enchantments);
        registry.addRecipes(IMBUEMENT_RECIPE_TYPE.get(), imbuementRecipes);
        registry.addRecipes(ARMOR_RECIPE_TYPE.get(), armorUpgrades);
        registry.addRecipes(BUDDING_CONVERSION_RECIPE_TYPE.get(), buddingConversionRecipes);
        registry.addRecipes(SCRY_RITUAL_RECIPE_TYPE.get(), scryRitualRecipes);
        registry.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, List.of(BlockRegistry.PORTAL_BLOCK.asItem().getDefaultInstance()));
        registry.addRecipes(ALAKARKINOS_RECIPE_TYPE.get(), alakarkinosRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.SCRIBES_BLOCK), new RecipeType[]{GLYPH_RECIPE_TYPE.get()});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)EffectCrush.INSTANCE.glyphItem), new RecipeType[]{CRUSH_RECIPE_TYPE.get()});
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.IMBUEMENT_BLOCK), new RecipeType[]{IMBUEMENT_RECIPE_TYPE.get()});
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{ENCHANTING_APP_RECIPE_TYPE.get()});
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{ENCHANTING_RECIPE_TYPE.get()});
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{ARMOR_RECIPE_TYPE.get()});
        registry.addRecipeCatalyst(new ItemStack(ItemsRegistry.AMETHYST_GOLEM_CHARM), new RecipeType[]{BUDDING_CONVERSION_RECIPE_TYPE.get()});
        registry.addRecipeCatalyst(RitualRegistry.getRitualItemMap().get(ScryRitualRecipeCategory.SCRY_RITUAL).asItem().getDefaultInstance(), new RecipeType[]{SCRY_RITUAL_RECIPE_TYPE.get()});
        registry.addRecipeCatalyst(new ItemStack(ItemsRegistry.ALAKARKINOS_CHARM), new RecipeType[]{ALAKARKINOS_RECIPE_TYPE.get()});
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
        CraftingTerminalTransferHandler.registerTransferHandlers(registration);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(DyeRecipe.class, (ICraftingCategoryExtension)new DyeRecipeCategory());
    }

    public void registerIngredientAliases(@NotNull IIngredientAliasRegistration registration) {
        List<SpellSchool> schools = List.of(SpellSchools.ELEMENTAL, SpellSchools.ABJURATION, SpellSchools.CONJURATION, SpellSchools.NECROMANCY, SpellSchools.MANIPULATION, SpellSchools.ELEMENTAL_AIR, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_WATER);
        for (SpellSchool school : schools) {
            registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, GlyphRegistry.getGlyphItemMap().values().stream().map(Supplier::get).filter(glyph -> school.isPartOfSchool(glyph.spellPart)).map(Item::getDefaultInstance).toList(), school.getTextComponent().getString());
        }
        for (DeferredHolder entry : ItemsRegistry.ITEMS.getEntries()) {
            Object object = entry.get();
            if (!(object instanceof AliasProvider)) continue;
            AliasProvider aliasProvider = (AliasProvider)object;
            List<String> aliases = aliasProvider.getAliases().stream().map(AliasProvider.Alias::toTranslationKey).toList();
            registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)entry.get()).getDefaultInstance(), aliases);
        }
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        JEIArsNouveauPlugin.jeiRuntime = jeiRuntime;
    }

    static {
        IAutoFillTerminal.updateSearch.add(new IAutoFillTerminal.ISearchHandler(){

            @Override
            public void setSearch(String text) {
                if (jeiRuntime != null && jeiRuntime.getIngredientFilter() != null) {
                    jeiRuntime.getIngredientFilter().setFilterText(text);
                }
            }

            @Override
            public String getSearch() {
                if (jeiRuntime != null && jeiRuntime.getIngredientFilter() != null) {
                    return jeiRuntime.getIngredientFilter().getFilterText();
                }
                return "";
            }

            @Override
            public String getName() {
                return "JEI";
            }
        });
    }
}

