/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.common.util.HolderHelper;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEffect
extends AbstractSpellPart {
    public ModConfigSpec.DoubleValue DAMAGE;
    public ModConfigSpec.DoubleValue AMP_VALUE;
    public ModConfigSpec.IntValue POTION_TIME;
    public ModConfigSpec.IntValue EXTEND_TIME;
    public ModConfigSpec.IntValue DURATION_DOWN_TIME;
    public ModConfigSpec.IntValue GENERIC_INT;
    public ModConfigSpec.DoubleValue GENERIC_DOUBLE;
    public ModConfigSpec.DoubleValue RANDOMIZE_CHANCE;

    public AbstractEffect(String tag, String description) {
        super(tag, description);
    }

    public AbstractEffect(ResourceLocation tag, String description) {
        super(tag, description);
    }

    @Override
    public Integer getTypeIndex() {
        return 5;
    }

    public void onResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            this.onResolveBlock(blockHitResult, world, shooter, spellStats, spellContext, resolver);
        } else if (rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
            this.onResolveEntity(entityHitResult, world, shooter, spellStats, spellContext, resolver);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
    }

    public boolean canSummon(LivingEntity playerEntity) {
        Player player;
        return this.isRealPlayer((Entity)playerEntity) && (playerEntity.getEffect(ModPotions.SUMMONING_SICKNESS_EFFECT) == null || playerEntity instanceof Player && (player = (Player)playerEntity).isCreative());
    }

    public void applySummoningSickness(LivingEntity playerEntity, int time) {
        playerEntity.addEffect(new MobEffectInstance(ModPotions.SUMMONING_SICKNESS_EFFECT, time));
    }

    public void summonLivingEntity(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats augments, SpellContext spellContext, @Nullable SpellResolver resolver, ISummon summon) {
        summon.setOwnerID(shooter.getUUID());
        LivingEntity summonLivingEntity = summon.getLivingEntity();
        if (summonLivingEntity != null) {
            world.addFreshEntity((Entity)summon.getLivingEntity());
            if (resolver != null && resolver.hasFocus((Item)ItemsRegistry.SUMMONING_FOCUS.get())) {
                SpellContext newContext = resolver.spellContext.makeChildContext();
                EntitySpellResolver spellResolver = new EntitySpellResolver(newContext.withWrappedCaster(new LivingCaster(summonLivingEntity)));
                spellResolver.onResolveEffect(world, (HitResult)new EntityHitResult((Entity)summonLivingEntity));
            }
        }
        NeoForge.EVENT_BUS.post((Event)new SummonEvent(rayTraceResult, world, shooter, augments, spellContext, summon));
    }

    public Player getPlayer(LivingEntity entity, ServerLevel world) {
        Player player;
        return entity instanceof Player ? (player = (Player)entity) : ANFakePlayer.getPlayer(world, entity.getUUID());
    }

    public int getBaseHarvestLevel(SpellStats stats) {
        return (int)(3.0 + stats.getAmpMultiplier());
    }

    public boolean canBlockBeHarvested(SpellStats stats, Level world, BlockPos pos) {
        return BlockUtil.canBlockBeHarvested(stats, world, pos);
    }

    public Vec3 safelyGetHitPos(HitResult result) {
        Vec3 vec3;
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            vec3 = entityHitResult.getEntity().position();
        } else {
            vec3 = result.getLocation();
        }
        return vec3;
    }

    public boolean isRealPlayer(Entity entity) {
        return entity instanceof Player && this.isNotFakePlayer(entity);
    }

    public boolean isNotFakePlayer(Entity entity) {
        return !(entity instanceof FakePlayer);
    }

    public void applyEnchantments(Level level, SpellStats stats, ItemStack stack) {
        if (stats.hasBuff(AugmentExtract.INSTANCE)) {
            stack.enchant(HolderHelper.unwrap(level, Enchantments.SILK_TOUCH), 1);
        }
        if (stats.hasBuff(AugmentFortune.INSTANCE)) {
            stack.enchant(HolderHelper.unwrap(level, Enchantments.FORTUNE), stats.getBuffCount(AugmentFortune.INSTANCE));
        }
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        HashMap<ResourceLocation, Integer> defaultAugmentLimits = new HashMap<ResourceLocation, Integer>();
        this.addDefaultAugmentLimits(defaultAugmentLimits);
        this.buildAugmentLimitsConfig(builder, defaultAugmentLimits);
        HashMap<ResourceLocation, Integer> defaultAugmentCosts = new HashMap<ResourceLocation, Integer>();
        this.addAugmentCostOverrides(defaultAugmentCosts);
        this.buildAugmentCostOverrideConfig(builder, defaultAugmentCosts);
        super.buildAugmentLimitsConfig(builder, this.getDefaultAugmentLimits(new HashMap<ResourceLocation, Integer>()));
        super.buildInvalidCombosConfig(builder, this.getDefaultInvalidCombos(new HashSet<ResourceLocation>()));
    }

    public void addDamageConfig(ModConfigSpec.Builder builder, double defaultValue) {
        this.DAMAGE = builder.defineInRange("damage", defaultValue, 0.0, 2.147483647E9);
    }

    public void addAmpConfig(ModConfigSpec.Builder builder, double defaultValue) {
        this.AMP_VALUE = builder.defineInRange("amplify", defaultValue, 0.0, 2.147483647E9);
    }

    public void addPotionConfig(ModConfigSpec.Builder builder, int defaultTime) {
        this.POTION_TIME = builder.comment("Potion duration, in seconds").defineInRange("potion_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addExtendTimeConfig(ModConfigSpec.Builder builder, int defaultTime) {
        this.EXTEND_TIME = builder.comment("Extend time duration, in seconds").defineInRange("extend_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addRandomizeConfig(ModConfigSpec.Builder builder, float defaultChance) {
        this.RANDOMIZE_CHANCE = builder.comment("Randomize chance, in percentage (0-1 = 0% - 100%)").defineInRange("randomize_chance", (double)defaultChance, 0.0, 2.147483647E9);
    }

    public void addDurationDownConfig(ModConfigSpec.Builder builder, int defaultTime) {
        this.DURATION_DOWN_TIME = builder.comment("Duration down time, in ticks").defineInRange("duration_down_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addGenericInt(ModConfigSpec.Builder builder, int val, String comment, String path) {
        this.GENERIC_INT = builder.comment(comment).defineInRange(path, val, 0, Integer.MAX_VALUE);
    }

    public void addGenericDouble(ModConfigSpec.Builder builder, double val, String comment, String path) {
        this.GENERIC_DOUBLE = builder.comment(comment).defineInRange(path, val, 0.0, Double.MAX_VALUE);
    }

    @Override
    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        if (this instanceof IPotionEffect) {
            this.addPotionAugmentDescriptions(map);
        }
        if (this instanceof IDamageEffect) {
            this.addDamageAugmentDescriptions(map);
        }
    }

    public void addDefaultPotionConfig(ModConfigSpec.Builder builder) {
        this.addPotionConfig(builder, 30);
        this.addExtendTimeConfig(builder, 8);
    }

    protected Set<AbstractAugment> getPotionAugments() {
        return this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAmplify.INSTANCE);
    }

    protected void addBlockAoeAugmentDescriptions(Map<AbstractAugment, String> map) {
        map.put(AugmentAOE.INSTANCE, "Increases the radius of targeted blocks.");
        map.put(AugmentPierce.INSTANCE, "Increases the depth of targeted blocks.");
        map.put(AugmentRandomize.INSTANCE, "Adds a chance to not target a block.");
        map.put(AugmentFortune.INSTANCE, "Applies fortune when breaking a block.");
        map.put(AugmentExtract.INSTANCE, "Applies silk touch when breaking a block.");
    }

    protected void addDamageAugmentDescriptions(Map<AbstractAugment, String> map) {
        map.put(AugmentAmplify.INSTANCE, "Increases damage dealt.");
        map.put(AugmentDampen.INSTANCE, "Reduces damage dealt.");
        map.put(AugmentFortune.INSTANCE, "Applies looting when killing a mob.");
        map.put(AugmentRandomize.INSTANCE, "Randomizes the damage dealt.");
    }

    protected void addPotionAugmentDescriptions(Map<AbstractAugment, String> map) {
        map.put(AugmentExtendTime.INSTANCE, "Extends the duration of the effect.");
        map.put(AugmentDurationDown.INSTANCE, "Reduces the duration of the effect.");
        map.put(AugmentAmplify.INSTANCE, "Increases the level of the effect.");
    }

    protected Set<AbstractAugment> getSummonAugments() {
        return this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE);
    }

    protected void addSummonAugmentDescriptions(Map<AbstractAugment, String> map) {
        map.put(AugmentExtendTime.INSTANCE, "Extends the duration of the summon.");
        map.put(AugmentDurationDown.INSTANCE, "Reduces the duration of the summon.");
    }

    @Override
    public DocAssets.BlitInfo getTypeIcon() {
        return DocAssets.EFFECT_ICON;
    }

    @Override
    public Component getTypeName() {
        return Component.translatable((String)"ars_nouveau.spell_book_gui.effect");
    }
}

