/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.registry;

import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class PotionProviderRegistry {
    private static final ConcurrentHashMap<Item, Function<ItemStack, IPotionProvider>> MAP = new ConcurrentHashMap();
    private static final IPotionProvider DEFAULT = new IPotionProvider(){

        @Override
        @NotNull
        public PotionContents getPotionData(ItemStack stack) {
            return (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        }

        @Override
        public int usesRemaining(ItemStack stack) {
            PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (contents == null) {
                return 0;
            }
            return contents == PotionContents.EMPTY ? 0 : 1;
        }

        @Override
        public int maxUses(ItemStack stack) {
            return 1;
        }

        @Override
        public void consumeUses(ItemStack stack, int amount, @Nullable LivingEntity entity) {
            Item item = stack.getItem();
            if (item instanceof PotionItem) {
                PotionItem potionItem = (PotionItem)item;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.hasInfiniteMaterials()) {
                        stack.shrink(1);
                    }
                    player.inventory.add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                } else {
                    stack.shrink(1);
                }
            }
        }

        @Override
        public void addUse(ItemStack stack, int amount, @Nullable LivingEntity entity) {
            Item item = stack.getItem();
            if (item instanceof BottleItem) {
                BottleItem bottleItem = (BottleItem)item;
                ItemStack bottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                bottle.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)stack.get(DataComponents.POTION_CONTENTS)));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.hasInfiniteMaterials()) {
                        stack.shrink(1);
                    }
                    player.inventory.add(bottle);
                }
            }
        }

        @Override
        public void setData(PotionContents contents, int usesRemaining, int maxUses, ItemStack stack) {
            stack.set(DataComponents.POTION_CONTENTS, (Object)contents);
        }
    };

    @Nullable
    public static IPotionProvider from(ItemStack stack) {
        return MAP.getOrDefault(stack.getItem(), item -> null).apply(stack);
    }

    static {
        MAP.put(ItemsRegistry.POTION_FLASK.asItem(), stack -> (IPotionProvider)stack.get(DataComponentRegistry.MULTI_POTION));
        MAP.put(ItemsRegistry.POTION_FLASK_AMPLIFY.asItem(), stack -> (IPotionProvider)stack.get(DataComponentRegistry.MULTI_POTION));
        MAP.put(ItemsRegistry.POTION_FLASK_EXTEND_TIME.asItem(), stack -> (IPotionProvider)stack.get(DataComponentRegistry.MULTI_POTION));
        MAP.put(Items.POTION, stack -> DEFAULT);
    }
}

