/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.registry;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.AlakarkinosRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class AlakarkinosConversionRegistry {
    private static List<AlakarkinosRecipe> RECIPES = new ArrayList<AlakarkinosRecipe>();
    private static Set<Block> CONVERTABLE_BLOCKS = Set.of();
    private static Map<Block, WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>> CONVERTABLE_BLOCKS_MAP = new HashMap<Block, WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>>();

    public static List<AlakarkinosRecipe> getRecipes() {
        return Collections.unmodifiableList(RECIPES);
    }

    public static void reloadAlakarkinosRecipes(RecipeManager recipeManager, MinecraftServer server) {
        RECIPES = new ArrayList<AlakarkinosRecipe>();
        List<AlakarkinosRecipe> recipes = recipeManager.getAllRecipesFor((RecipeType)RecipeRegistry.ALAKARKINOS_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        RECIPES.addAll(recipes);
        CONVERTABLE_BLOCKS = new HashSet<Block>();
        for (AlakarkinosRecipe recipe : RECIPES) {
            CONVERTABLE_BLOCKS.add(recipe.input());
        }
        CONVERTABLE_BLOCKS_MAP = new HashMap<Block, WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>>();
        for (AlakarkinosRecipe recipe : RECIPES) {
            WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>> list = CONVERTABLE_BLOCKS_MAP.getOrDefault(recipe.input(), (WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>)WeightedRandomList.create());
            ArrayList<WeightedEntry.Wrapper> modifiedList = new ArrayList<WeightedEntry.Wrapper>(list.unwrap());
            modifiedList.add(WeightedEntry.wrap((Object)recipe, (int)recipe.weight()));
            CONVERTABLE_BLOCKS_MAP.put(recipe.input(), (WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>)WeightedRandomList.create(modifiedList));
        }
        LootDrop.DROPS.clear();
        for (AlakarkinosRecipe recipe : RECIPES) {
            LootDrop.computeLootDrops(server, recipe);
        }
    }

    public static boolean isConvertable(Block block) {
        return CONVERTABLE_BLOCKS.contains(block);
    }

    @Nullable
    public static AlakarkinosRecipe getConversionResult(Block block, RandomSource random) {
        if (!AlakarkinosConversionRegistry.isConvertable(block)) {
            return null;
        }
        WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>> list = CONVERTABLE_BLOCKS_MAP.get(block);
        Optional entry = list.getRandom(random);
        return entry.map(WeightedEntry.Wrapper::data).orElse(null);
    }

    public record LootDrop(ItemStack item, float chance) {
        private static HashMap<ResourceKey<LootTable>, LootDrops> DROPS = new HashMap();
        public static Codec<LootDrop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(LootDrop::item), (App)Codec.FLOAT.fieldOf("chance").forGetter(LootDrop::chance)).apply((Applicative)instance, LootDrop::new));

        public static LootDrops getLootDrops(ResourceKey<LootTable> resourceKey) {
            return DROPS.get(resourceKey);
        }

        @Deprecated
        public static LootDrops computeLootDrops(AlakarkinosRecipe recipe) {
            return LootDrop.computeLootDrops(ServerLifecycleHooks.getCurrentServer(), recipe);
        }

        public static LootDrops computeLootDrops(MinecraftServer server, AlakarkinosRecipe recipe) {
            return DROPS.computeIfAbsent(recipe.table(), key -> {
                LootTable lootTable = server.reloadableRegistries().getLootTable(key);
                if (lootTable.equals(LootTable.EMPTY)) {
                    return null;
                }
                Object2IntOpenCustomHashMap drops = new Object2IntOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

                    public int hashCode(ItemStack o) {
                        return ItemStack.hashItemAndComponents((ItemStack)o);
                    }

                    public boolean equals(ItemStack a, ItemStack b) {
                        return a == null && b == null || a != null && b != null && ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
                    }
                });
                ANFakePlayer player = ANFakePlayer.getPlayer(server.overworld());
                LootParams lootParams = new LootParams.Builder(server.overworld()).withParameter(LootContextParams.ORIGIN, (Object)BlockPos.ZERO.getCenter()).withLuck(1.0f).withParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.CHEST);
                for (int i = 0; i < 600; ++i) {
                    for (ItemStack random : lootTable.getRandomItems(lootParams)) {
                        drops.put((Object)random, drops.getInt((Object)random) + random.getCount());
                    }
                }
                int totalDrops = 0;
                ObjectIterator iter = Object2IntMaps.fastIterator((Object2IntMap)drops);
                while (iter.hasNext()) {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iter.next();
                    totalDrops += entry.getIntValue();
                }
                ArrayList<LootDrop> lootDrops = new ArrayList<LootDrop>(drops.size());
                iter = Object2IntMaps.fastIterator((Object2IntMap)drops);
                while (iter.hasNext()) {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iter.next();
                    LootDrop drop = new LootDrop((ItemStack)entry.getKey(), (float)entry.getIntValue() / (float)totalDrops);
                    lootDrops.add(drop);
                }
                lootDrops.sort(Comparator.comparing(LootDrop::chance).reversed());
                return new LootDrops(lootDrops, AlakarkinosConversionRegistry.CONVERTABLE_BLOCKS_MAP.get((Object)recipe.input()).totalWeight);
            });
        }
    }

    public record LootDrops(List<LootDrop> list, int weight) {
        public static Codec<LootDrops> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LootDrop.CODEC.listOf().fieldOf("list").forGetter(LootDrops::list), (App)Codec.INT.fieldOf("weight").forGetter(LootDrops::weight)).apply((Applicative)instance, LootDrops::new));
    }
}

