/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ColorProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.client.gui.buttons.SelectedParticleButton;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class ModelProperty
extends BaseProperty<ModelProperty> {
    public static MapCodec<ModelProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("resource").forGetter(i -> i.selectedResource.resourceLocation), (App)PropMap.CODEC.fieldOf("subPropMap").forGetter(i -> i.subPropMap)).apply((Applicative)instance, ModelProperty::new));
    public static StreamCodec<RegistryFriendlyByteBuf, ModelProperty> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, i -> i.selectedResource.resourceLocation, PropMap.STREAM_CODEC, i -> i.subPropMap, ModelProperty::new);
    public Model selectedResource;
    public PropMap subPropMap;
    public static final Model NONE = new Model(ArsNouveau.prefix("empty"), DocAssets.STYLE_ICON_NONE, false);
    public static final Model CUBE_BODY = new Model(ArsNouveau.prefix("cube"), DocAssets.STYLE_ICON_BLOCK, true, spell -> ArsNouveau.prefix("textures/particle/projectile_" + spell.age / 5 % 4 + ".png"));
    public static final Model SPIKE_BODY = new Model(ArsNouveau.prefix("spike"), DocAssets.STYLE_ICON_SPIKE, true);
    public static final List<Model> resources = new CopyOnWriteArrayList<Model>();

    public ModelProperty(PropMap propMap) {
        super(propMap);
        if (propMap.has((IPropertyType)ParticlePropertyRegistry.MODEL_PROPERTY.get())) {
            ModelProperty modelProperty = (ModelProperty)propMap.get((IPropertyType)ParticlePropertyRegistry.MODEL_PROPERTY.get());
            this.selectedResource = modelProperty.selectedResource;
            this.subPropMap = ((ModelProperty)propMap.get((IPropertyType)ParticlePropertyRegistry.MODEL_PROPERTY.get())).subPropMap;
        } else {
            this.selectedResource = NONE;
            this.subPropMap = new PropMap();
        }
    }

    public ModelProperty() {
        this.selectedResource = NONE;
        this.subPropMap = new PropMap();
    }

    public ModelProperty(ResourceLocation resourceLocation, PropMap subPropMap) {
        this(new PropMap());
        this.selectedResource = resources.stream().filter(res -> res.resourceLocation.equals((Object)resourceLocation)).findFirst().orElse(NONE);
        this.subPropMap = subPropMap;
    }

    @Override
    public ParticleConfigWidgetProvider buildWidgets(int x, int y, int width, int height) {
        final ModelProperty self = this;
        return new ParticleConfigWidgetProvider(x, y, width, height){
            SelectedParticleButton selectedButton;

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.drawHeader(ModelProperty.this.getName(), graphics, this.x, this.y, this.width, mouseX, mouseY, partialTicks);
            }

            @Override
            public void addWidgets(List<AbstractWidget> widgets) {
                for (int i = 0; i < resources.size(); ++i) {
                    Model resource = resources.get(i);
                    SelectedParticleButton selectedParticleButton = new SelectedParticleButton(this.x + 6 + 16 * (i % 7), this.y + 20 + 20 * (i / 7), 14, 14, this.getImagePath(resource), b -> {
                        boolean didHaveColor = ModelProperty.this.selectedResource.supportsColor;
                        ModelProperty.this.selectedResource = resource;
                        boolean nowHasColor = ModelProperty.this.selectedResource.supportsColor;
                        ModelProperty.this.propertyHolder.set(ModelProperty.this.getType(), self);
                        if (didHaveColor != nowHasColor && ModelProperty.this.onDependenciesChanged != null) {
                            ModelProperty.this.onDependenciesChanged.run();
                        }
                        this.selectedButton.selected = false;
                        if (b instanceof SelectedParticleButton) {
                            SelectedParticleButton selectedParticleButton1 = (SelectedParticleButton)b;
                            selectedParticleButton1.selected = true;
                            this.selectedButton = selectedParticleButton1;
                        }
                    });
                    selectedParticleButton.withTooltip(this.getTypeName(resource.resourceLocation));
                    widgets.add((AbstractWidget)selectedParticleButton);
                    if (ModelProperty.this.selectedResource != resource) continue;
                    this.selectedButton = selectedParticleButton;
                    this.selectedButton.selected = true;
                }
            }

            private ResourceLocation getImagePath(Model location) {
                return location.blitInfo.location();
            }

            private Component getTypeName(ResourceLocation location) {
                return Component.translatable((String)(location.getNamespace() + ".model." + location.getPath()));
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
                graphics.blit(this.getImagePath(ModelProperty.this.selectedResource), x, y, 0.0f, 0.0f, 14, 14, 14, 14);
            }

            @Override
            public Component getButtonTitle() {
                return Component.literal((String)(ModelProperty.this.getName().getString() + ": " + this.getTypeName(ModelProperty.this.selectedResource.resourceLocation).getString()));
            }

            @Override
            public void getButtonTooltips(List<Component> tooltip) {
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.model_tooltip"));
            }
        };
    }

    @Override
    public List<BaseProperty<?>> subProperties() {
        if (this.selectedResource.supportsColor) {
            return List.of(this.subPropMap.createIfMissing(new ColorProperty()));
        }
        return List.of();
    }

    @Override
    public IPropertyType<ModelProperty> getType() {
        return (IPropertyType)ParticlePropertyRegistry.MODEL_PROPERTY.get();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelProperty that = (ModelProperty)o;
        return Objects.equals(this.selectedResource, that.selectedResource) && Objects.equals(this.subPropMap, that.subPropMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.selectedResource, this.subPropMap);
    }

    static {
        resources.add(NONE);
        resources.add(CUBE_BODY);
        resources.add(SPIKE_BODY);
    }

    public record Model(ResourceLocation resourceLocation, DocAssets.BlitInfo blitInfo, boolean supportsColor, Function<EntityProjectileSpell, ResourceLocation> getTexture) {
        public Model(ResourceLocation resourceLocation, DocAssets.BlitInfo blitInfo, boolean supportsColor) {
            this(resourceLocation, blitInfo, supportsColor, spell -> ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)("textures/entity/" + resourceLocation.getPath() + ".png")));
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Model model = (Model)o;
            return Objects.equals(this.resourceLocation, model.resourceLocation);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.resourceLocation);
        }
    }
}

