/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleDensityProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SpeedProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticleMotionRegistry;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BrazierMotion
extends ParticleMotion {
    public static MapCodec<BrazierMotion> CODEC = BrazierMotion.buildPropCodec(BrazierMotion::new);
    public static StreamCodec<RegistryFriendlyByteBuf, BrazierMotion> STREAM = BrazierMotion.buildStreamCodec(BrazierMotion::new);

    public BrazierMotion(PropMap propertyMap) {
        super(propertyMap);
    }

    @Override
    public IParticleMotionType<?> getType() {
        return (IParticleMotionType)ParticleMotionRegistry.BRAZIER_TYPE.get();
    }

    @Override
    public void tick(PropertyParticleOptions particleOptions, Level level, double x, double y, double z, double prevX, double prevY, double prevZ) {
        ParticleDensityProperty density = this.getDensity(particleOptions, 100, 0.25f);
        double xzOffset = density.radius();
        int numParticles = this.getNumParticles(density.density());
        ParticleTypeProperty secondType = (ParticleTypeProperty)this.propertyMap.get((IPropertyType)ParticlePropertyRegistry.TYPE_PROPERTY.get());
        PropertyParticleOptions particle2 = secondType != null ? new PropertyParticleOptions(this.propertyMap) : new PropertyParticleOptions();
        for (int i = 0; i < numParticles; ++i) {
            Vec3 speed = this.randomSpeed(particleOptions, 0.0, 0.0, 0.0, 0.05f);
            level.addAlwaysVisibleParticle((ParticleOptions)particleOptions, false, x + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), y + ParticleUtil.inRange(-0.05, 0.2), z + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), speed.x, speed.y, speed.z);
            Vec3 speed2 = this.randomSpeed(particleOptions, 0.0, 0.0, 0.0, 0.05f);
            level.addAlwaysVisibleParticle((ParticleOptions)particle2, false, x + ParticleUtil.inRange(-xzOffset, xzOffset), y + ParticleUtil.inRange(0.0, 0.7), z + ParticleUtil.inRange(-xzOffset, xzOffset), speed2.x, speed2.y, speed2.z);
        }
    }

    @Override
    public List<BaseProperty<?>> getProperties(PropMap propMap) {
        return List.of(propMap.createIfMissing(new ParticleTypeProperty()), this.propertyMap.createIfMissing(new ParticleTypeProperty()), propMap.createIfMissing(new ParticleDensityProperty(100, 0.25, ParticleMotion.SpawnType.SPHERE).supportsShapes(false).minDensity(1).maxDensity(200).densityStepSize(1)), propMap.createIfMissing(new SpeedProperty().yRange(0.0, 0.05)));
    }
}

