/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.qio;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import me.ramidzkh.mekae2.AMText;
import mekanism.api.Action;
import mekanism.api.inventory.IHashedItem;
import mekanism.api.inventory.qio.IQIOComponent;
import mekanism.api.inventory.qio.IQIOFrequency;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class QioStorageAdapter<DASHBOARD extends BlockEntity & ISecurityObject>
implements MEStorage {
    private static final Map<IHashedItem, AEItemKey> CACHE = new WeakHashMap<IHashedItem, AEItemKey>();
    private final DASHBOARD dashboard;
    @Nullable
    private final Direction queriedSide;
    @Nullable
    private final UUID owner;

    public QioStorageAdapter(DASHBOARD dashboard, @Nullable Direction queriedSide, @Nullable UUID owner) {
        this.dashboard = dashboard;
        this.queriedSide = queriedSide;
        this.owner = owner;
    }

    @Nullable
    public IQIOFrequency getFrequency() {
        if (((Direction)this.dashboard.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite() != this.queriedSide) {
            return null;
        }
        IQIOFrequency freq = ((IQIOComponent)this.dashboard).getQIOFrequency();
        if (freq == null || !freq.isValid()) {
            return null;
        }
        ISecurityUtils utils = ISecurityUtils.INSTANCE;
        SecurityMode securityMode = utils.getSecurityMode(() -> (ISecurityObject)this.dashboard, () -> (IOwnerObject)this.dashboard, this.dashboard.getLevel().isClientSide());
        if (securityMode != SecurityMode.PUBLIC && !utils.canAccessObject(this.owner, (ISecurityObject)this.dashboard, this.dashboard.getLevel().isClientSide())) {
            return null;
        }
        return freq;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            if (amount > 0L) {
                IQIOFrequency freq = this.getFrequency();
                if (freq == null) {
                    return 0L;
                }
                return freq.massInsert(itemKey.toStack(), amount, Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction()));
            }
        }
        return 0L;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            if (amount > 0L) {
                IQIOFrequency freq = this.getFrequency();
                if (freq == null) {
                    return 0L;
                }
                return freq.massExtract(itemKey.toStack(), amount, Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction()));
            }
        }
        return 0L;
    }

    public void getAvailableStacks(KeyCounter out) {
        IQIOFrequency freq = this.getFrequency();
        if (freq == null) {
            return;
        }
        freq.forAllHashedStored((type, count) -> out.add((AEKey)CACHE.computeIfAbsent((IHashedItem)type, it -> AEItemKey.of((ItemStack)it.getInternalStack())), count));
    }

    public Component getDescription() {
        IQIOFrequency freq = this.getFrequency();
        if (freq == null) {
            throw new IllegalStateException("Unexpected null frequency!");
        }
        return AMText.QIO_FREQUENCY.formatted(freq.getName());
    }
}

