/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.BasicTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class BasicTreeFeature
extends BOPTreeFeature<BasicTreeConfiguration> {
    public BasicTreeFeature(Codec<BasicTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        BasicTreeConfiguration config = (BasicTreeConfiguration)configBase;
        int height = random.nextInt(config.maxHeight - config.minHeight) + config.minHeight;
        boolean hasSpace = true;
        if (pos.getY() >= world.getMinBuildHeight() + 1 && pos.getY() + height + 1 <= world.getMaxBuildHeight()) {
            int x;
            int leavesRadius;
            int currentLayer;
            int y;
            for (int y2 = pos.getY(); y2 <= pos.getY() + 1 + height; ++y2) {
                int radius = 1;
                if (y2 == pos.getY()) {
                    radius = 0;
                }
                if (y2 >= pos.getY() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x2 = pos.getX() - radius; x2 <= pos.getX() + radius && hasSpace; ++x2) {
                    for (int z = pos.getZ() - radius; z <= pos.getZ() + radius && hasSpace; ++z) {
                        if (y2 >= world.getMinBuildHeight() && y2 < world.getMaxBuildHeight()) {
                            if (this.canReplace((LevelAccessor)world, new BlockPos(x2, y2, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.below();
            Block soil = world.getBlockState(soilPos).getBlock();
            if (world.getBlockState(pos.below()).getBlock() == Blocks.GRASS_BLOCK || world.getBlockState(pos.below()).getBlock() == Blocks.MYCELIUM) {
                world.setBlock(soilPos, Blocks.DIRT.defaultBlockState(), 3);
            }
            int leavesLayers = config.leafLayers - 1;
            for (y = pos.getY() + height - leavesLayers; y <= pos.getY() + height; ++y) {
                currentLayer = y - (pos.getY() + height);
                leavesRadius = config.maxLeavesRadius - currentLayer / config.leavesLayerHeight;
                for (x = pos.getX() - leavesRadius; x <= pos.getX() + leavesRadius; ++x) {
                    int xDiff = x - pos.getX();
                    for (int z = pos.getZ() - leavesRadius; z <= pos.getZ() + leavesRadius; ++z) {
                        int zDiff = z - pos.getZ();
                        if (Math.abs(xDiff) == leavesRadius && Math.abs(zDiff) == leavesRadius && (random.nextInt(2) == 0 || currentLayer == 0)) continue;
                        BlockPos leavesPos = new BlockPos(x, y, z);
                        if (this.canReplace((LevelAccessor)world, leavesPos)) {
                            if (config.altFoliageProvider.getState(random, pos) != Blocks.AIR.defaultBlockState()) {
                                if (random.nextInt(4) == 0) {
                                    this.placeAltLeaves((LevelAccessor)world, leavesPos, leaves, config);
                                } else {
                                    this.placeLeaves((LevelAccessor)world, leavesPos, leaves, config);
                                }
                            } else {
                                this.placeLeaves((LevelAccessor)world, leavesPos, leaves, config);
                            }
                        }
                        int hanging_height = random.nextInt(2) + 1;
                        if (config.hangingProvider.getState(random, pos) == Blocks.AIR.defaultBlockState() || random.nextInt(2) != 0) continue;
                        for (int i = 0; i < hanging_height; ++i) {
                            if (!this.canReplace((LevelAccessor)world, leavesPos.below(i))) continue;
                            this.setHanging((LevelAccessor)world, leavesPos.below(i), config);
                        }
                    }
                }
            }
            this.generateTrunk((LevelAccessor)world, pos, height, logs, config);
            if (config.vineProvider.getState(random, pos) != Blocks.AIR.defaultBlockState()) {
                for (y = pos.getY() - leavesLayers + height; y <= pos.getY() + height; ++y) {
                    currentLayer = y - (pos.getY() + height);
                    leavesRadius = config.maxLeavesRadius + config.leavesOffset - currentLayer / config.leavesLayerHeight;
                    for (x = pos.getX() - leavesRadius; x <= pos.getX() + leavesRadius; ++x) {
                        for (int z = pos.getZ() - leavesRadius; z <= pos.getZ() + leavesRadius; ++z) {
                            BlockPos blockpos3 = new BlockPos(x, y, z);
                            if (!world.getBlockState(blockpos3).is(BlockTags.LEAVES)) continue;
                            BlockPos westPos = blockpos3.west();
                            BlockPos eastPos = blockpos3.east();
                            BlockPos northPos = blockpos3.north();
                            BlockPos southPos = blockpos3.south();
                            if (random.nextInt(4) == 0 && this.canPlaceVinesOn((LevelAccessor)world, westPos)) {
                                this.extendVines((LevelAccessor)world, random, westPos, Direction.EAST, config);
                            }
                            if (random.nextInt(4) == 0 && this.canPlaceVinesOn((LevelAccessor)world, eastPos)) {
                                this.extendVines((LevelAccessor)world, random, eastPos, Direction.WEST, config);
                            }
                            if (random.nextInt(4) == 0 && this.canPlaceVinesOn((LevelAccessor)world, northPos)) {
                                this.extendVines((LevelAccessor)world, random, northPos, Direction.SOUTH, config);
                            }
                            if (random.nextInt(4) != 0 || !this.canPlaceVinesOn((LevelAccessor)world, southPos)) continue;
                            this.extendVines((LevelAccessor)world, random, southPos, Direction.NORTH, config);
                        }
                    }
                }
            }
            if (config.trunkFruitProvider.getState(random, pos) != Blocks.AIR.defaultBlockState() && random.nextInt(5) == 0 && height > 5) {
                for (int l3 = 0; l3 < 2; ++l3) {
                    for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                        if (random.nextInt(4 - l3) != 0) continue;
                        Direction Direction1 = Direction2.getOpposite();
                        this.generateTrunkFruit((LevelAccessor)world, random, random.nextInt(3), pos.offset(Direction1.getStepX(), height - 5 + l3, Direction1.getStepZ()), Direction2, config);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected void generateTrunk(LevelAccessor world, BlockPos start, int height, BiConsumer<BlockPos, BlockState> logs, BasicTreeConfiguration config) {
        for (int layer = 0; layer < height; ++layer) {
            BlockPos blockpos2 = start.above(layer);
            if (!this.canReplace(world, blockpos2)) continue;
            this.placeLog(world, start.above(layer), logs, config);
        }
    }

    private void generateTrunkFruit(LevelAccessor world, RandomSource random, int age, BlockPos pos, Direction direction, BasicTreeConfiguration config) {
        if (config.trunkFruitProvider.getState(random, pos) == Blocks.COCOA.defaultBlockState()) {
            this.setBlock((LevelWriter)world, pos, (BlockState)((BlockState)config.trunkFruitProvider.getState(random, pos).setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(age))).setValue((Property)CocoaBlock.FACING, (Comparable)direction));
        } else {
            this.setBlock((LevelWriter)world, pos, (BlockState)config.trunkFruitProvider.getState(random, pos).setValue((Property)CocoaBlock.FACING, (Comparable)direction));
        }
    }

    private BlockState getVineStateForSide(RandomSource random, BlockPos pos, Direction side, BasicTreeConfiguration config) {
        return config.vineProvider.getState(random, pos).getBlock() instanceof VineBlock ? (BlockState)config.vineProvider.getState(random, pos).setValue((Property)VineBlock.getPropertyForFace((Direction)side), (Comparable)Boolean.valueOf(true)) : config.vineProvider.getState(random, pos);
    }

    private void extendVines(LevelAccessor world, RandomSource random, BlockPos pos, Direction side, BasicTreeConfiguration config) {
        BlockState vineState = this.getVineStateForSide(random, pos, side, config);
        this.setBlock((LevelWriter)world, pos, vineState);
        pos = pos.below();
        for (int length = 4; this.canPlaceVinesOn(world, pos) && length > 0; --length) {
            this.setBlock((LevelWriter)world, pos, vineState);
            pos = pos.below();
        }
    }

    protected boolean canPlaceVinesOn(LevelAccessor world, BlockPos pos) {
        return world.getBlockState(pos).isAir();
    }
}

