/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.damagesource.BOPDamageTypes;
import biomesoplenty.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrimstoneFumaroleBlock
extends Block {
    protected static final VoxelShape SHAPE_TOP = Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_BOTTOM = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    protected static final VoxelShape FULL_SHAPE = Shapes.or((VoxelShape)SHAPE_TOP, (VoxelShape)SHAPE_BOTTOM);

    public BrimstoneFumaroleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void stepOn(Level level, BlockPos p_153778_, BlockState p_153779_, Entity p_153780_) {
        if (!p_153780_.fireImmune() && p_153780_ instanceof LivingEntity) {
            p_153780_.hurt(level.damageSources().source(BOPDamageTypes.FUMAROLE), 1.0f);
        }
        super.stepOn(level, p_153778_, p_153779_, p_153780_);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        if (worldIn.getBlockState(pos.above()).isAir()) {
            worldIn.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)pos.getX() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 6.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 6.0, 0.0, 0.02, 0.0);
            if (rand.nextInt(6) == 0) {
                for (int i = 0; i < 5; ++i) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 6.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 6.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return FULL_SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState groundState = worldIn.getBlockState(pos.below());
        return groundState.is(ModTags.Blocks.BRIMSTONE_DECORATION_PLACEABLE) && groundState.isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP);
    }

    public BlockState updateShape(BlockState p_51032_, Direction p_51033_, BlockState p_51034_, LevelAccessor p_51035_, BlockPos p_51036_, BlockPos p_51037_) {
        return !p_51032_.canSurvive((LevelReader)p_51035_, p_51036_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_51032_, p_51033_, p_51034_, p_51035_, p_51036_, p_51037_);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }
}

