/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.FlamingoConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class FlamingoEntity
extends Animal
implements ILexiconEntry {
    private static final EntityDataAccessor<Boolean> LEFT_LEG_UP = SynchedEntityData.defineId(FlamingoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> RIGHT_LEG_UP = SynchedEntityData.defineId(FlamingoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private DeepWaterAvoidingRandomWalkingGoal randomWalkingGoal;

    public FlamingoEntity(EntityType<? extends FlamingoEntity> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, 1.0f);
    }

    public static boolean checkFlamingoSpawnRules(EntityType<FlamingoEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.FLAMINGO_SPAWNABLE_ON) && FlamingoEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)ModEntityTypes.FLAMINGO.get().create((Level)world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, FlamingoConfig.health()).add(Attributes.MOVEMENT_SPEED, FlamingoConfig.movementSpeed());
    }

    protected void registerGoals() {
        this.randomWalkingGoal = new DeepWaterAvoidingRandomWalkingGoal(this, 1.0, 50);
        this.goalSelector.addGoal(0, (Goal)new SwimInDeepWaterGoal(this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredients.FLAMINGO_FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new LiftLegsGoal(this, 15));
        this.goalSelector.addGoal(5, (Goal)this.randomWalkingGoal);
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, FlamingoEntity.class, 8.0f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LEFT_LEG_UP, (Object)false);
        builder.define(RIGHT_LEG_UP, (Object)false);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.FLAMINGO_FOOD);
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    public int getMaxSpawnClusterSize() {
        return FlamingoConfig.maxSpawnedInChunk();
    }

    public boolean isLeftLegUp() {
        return (Boolean)this.entityData.get(LEFT_LEG_UP);
    }

    public boolean isRightLegUp() {
        return (Boolean)this.entityData.get(RIGHT_LEG_UP);
    }

    public void setLeftLegUp(boolean up) {
        this.entityData.set(LEFT_LEG_UP, (Object)up);
    }

    public void setRightLegUp(boolean up) {
        this.entityData.set(RIGHT_LEG_UP, (Object)up);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.FLAMINGO;
    }

    private static class DeepWaterAvoidingRandomWalkingGoal
    extends RandomStrollGoal {
        private final FlamingoEntity flamingo;

        public DeepWaterAvoidingRandomWalkingGoal(FlamingoEntity creatureIn, double speedIn, int chance) {
            super((PathfinderMob)creatureIn, speedIn, chance);
            this.flamingo = creatureIn;
        }

        protected Vec3 getPosition() {
            if (this.flamingo.wasEyeInWater) {
                Vec3 vector3d = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)7);
                return vector3d == null ? super.getPosition() : vector3d;
            }
            return LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
        }
    }

    static class SwimInDeepWaterGoal
    extends FloatGoal {
        private final FlamingoEntity flamingo;

        public SwimInDeepWaterGoal(FlamingoEntity entityIn) {
            super((Mob)entityIn);
            this.flamingo = entityIn;
        }

        public boolean canUse() {
            return this.flamingo.wasEyeInWater && super.canUse();
        }

        public void tick() {
            this.flamingo.randomWalkingGoal.trigger();
            super.tick();
        }
    }

    static class LiftLegsGoal
    extends Goal {
        private final FlamingoEntity flamingo;
        private final int chance;
        private int rightLegCounter;
        private int leftLegCounter;

        public LiftLegsGoal(FlamingoEntity flamingo, int chance) {
            this.flamingo = flamingo;
            this.chance = chance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.flamingo.getRandom().nextInt(this.chance) != 0) {
                return false;
            }
            return !this.flamingo.isRightLegUp() && !this.flamingo.isLeftLegUp() && this.flamingo.getNavigation().isDone();
        }

        public boolean canContinueToUse() {
            return this.flamingo.getNavigation().isDone() && (this.flamingo.isRightLegUp() || this.flamingo.isLeftLegUp());
        }

        public void stop() {
            this.leftLegCounter = 0;
            this.rightLegCounter = 0;
            this.flamingo.setLeftLegUp(false);
            this.flamingo.setRightLegUp(false);
        }

        public void tick() {
            if (this.leftLegCounter > 0) {
                --this.leftLegCounter;
            } else {
                this.leftLegCounter = 0;
                this.flamingo.setLeftLegUp(false);
            }
            if (this.rightLegCounter > 0) {
                --this.rightLegCounter;
            } else {
                this.rightLegCounter = 0;
                this.flamingo.setRightLegUp(false);
            }
            if (this.rightLegCounter == 0 && this.leftLegCounter == 0 && Math.random() < (double)0.1f) {
                if (Math.random() < 0.5) {
                    this.leftLegCounter = 500;
                    this.flamingo.setLeftLegUp(true);
                } else {
                    this.rightLegCounter = 500;
                    this.flamingo.setRightLegUp(true);
                }
            }
        }
    }
}

