/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.GeneralConfig;
import com.tristankechlo.livingthings.config.entity.BabyEnderDragonConfig;
import com.tristankechlo.livingthings.entity.ai.CustomSitWhenOrderedToSitGoal;
import com.tristankechlo.livingthings.entity.projectile.CustomDragonFireball;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class BabyEnderDragonEntity
extends TamableAnimal
implements NeutralMob,
RangedAttackMob,
FlyingAnimal,
ILexiconEntry {
    private static final EntityDataAccessor<Integer> COLLAR_COLOR = SynchedEntityData.defineId(BabyEnderDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.defineId(BabyEnderDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private UUID persistentAngerTarget;

    public BabyEnderDragonEntity(EntityType<? extends BabyEnderDragonEntity> entity, Level level) {
        super(entity, level);
        this.setTame(false, false);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new CustomSitWhenOrderedToSitGoal(this));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredients.BABY_ENDERDRAGON_FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.1, 120, 240, (float)BabyEnderDragonConfig.followRange()));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.3, 10.0f, 3.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, true, arg_0 -> ((BabyEnderDragonEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLLAR_COLOR, (Object)DyeColor.RED.getId());
        builder.define(REMAINING_ANGER_TIME, (Object)0);
    }

    protected void customServerAiStep() {
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        if (this.navigation.isDone() && this.isOrderedToSit()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
        }
        super.customServerAiStep();
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.setCanFloat(true);
        navigation.setCanOpenDoors(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (stack.is(ModItems.LEXICON.get())) {
            return InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isFood(stack) && stack.has(DataComponents.FOOD) && this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(player, hand, stack);
                this.heal(((FoodProperties)stack.get(DataComponents.FOOD)).nutrition() / 2);
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (this.isOwnedBy((LivingEntity)player) && item instanceof DyeItem) {
                DyeColor dyecolor = ((DyeItem)item).getDyeColor();
                if (dyecolor != this.getCollarColor()) {
                    this.setCollarColor(dyecolor);
                    this.usePlayerItem(player, hand, stack);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.isEmpty() && this.isOwnedBy((LivingEntity)player)) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
        } else if (!this.isTame() && this.isFood(stack) && !this.isAngry()) {
            this.usePlayerItem(player, hand, stack);
            if (this.random.nextInt(5) == 0 && !this.level().isClientSide()) {
                this.tame(player);
                this.navigation.stop();
                this.setTarget(null);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.BABY_ENDERDRAGON_FOOD);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setCollarColor(DyeColor.byId((int)nbt.getInt("CollarColor")));
        this.readPersistentAngerSaveData(this.level(), nbt);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putShort("CollarColor", (short)this.getCollarColor().getId());
        this.addPersistentAngerSaveData(nbt);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, BabyEnderDragonConfig.health()).add(Attributes.MOVEMENT_SPEED, BabyEnderDragonConfig.movementSpeed()).add(Attributes.FLYING_SPEED, BabyEnderDragonConfig.flyingSpeed()).add(Attributes.FOLLOW_RANGE, BabyEnderDragonConfig.followRange());
    }

    public static boolean checkBabyEnderDragonSpawnRules(EntityType<BabyEnderDragonEntity> entityType, LevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(LivingThingsTags.BABY_ENDER_DRAGON_SPAWNABLE_ON);
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor dyeColor) {
        this.entityData.set(COLLAR_COLOR, (Object)dyeColor.getId());
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(REMAINING_ANGER_TIME, (Object)time);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public boolean canMate(Animal animal) {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        BabyEnderDragonEntity child = (BabyEnderDragonEntity)ModEntityTypes.BABY_ENDER_DRAGON.get().create((Level)world);
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            child.setOwnerUUID(uuid);
            child.setTame(true, false);
        }
        return child;
    }

    public void performRangedAttack(LivingEntity entity, float distanceFactor) {
        boolean peaceful = this.level().getDifficulty() == Difficulty.PEACEFUL;
        boolean ambientMode = GeneralConfig.get().ambientMode.get();
        if (peaceful || ambientMode || !BabyEnderDragonConfig.canAttack()) {
            return;
        }
        if (!this.canAttack(entity)) {
            return;
        }
        Vec3 vec = this.getViewVector(1.0f);
        double d1 = this.getX() - vec.x;
        double d2 = this.getY(0.5);
        double d3 = this.getZ() - vec.z;
        double d4 = entity.getX() - d1;
        double d5 = entity.getY(0.5) - d2;
        double d6 = entity.getZ() - d3;
        CustomDragonFireball dragonfireball = new CustomDragonFireball(this.level(), (LivingEntity)this, d4, d5, d6);
        dragonfireball.moveTo(d1, d2, d3, 0.0f, 0.0f);
        this.level().addFreshEntity((Entity)dragonfireball);
        if (!this.level().isClientSide() && !this.isSilent()) {
            this.level().playSound(null, this.blockPosition(), ModSounds.BABY_ENDER_DRAGON_SHOOT.get(), SoundSource.HOSTILE, 2.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public boolean causeFallDamage(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public int getMaxSpawnClusterSize() {
        return BabyEnderDragonConfig.maxSpawnedInChunk();
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.BABY_ENDER_DRAGON_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return ModSounds.BABY_ENDER_DRAGON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.BABY_ENDER_DRAGON_DEATH.get();
    }

    public int getAmbientSoundInterval() {
        return 300;
    }

    protected void onFlap() {
        this.level().playSound(null, this.blockPosition(), ModSounds.BABY_ENDER_DRAGON_FLAP.get(), SoundSource.AMBIENT, 2.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    public boolean hurt(DamageSource source, float damage) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.getDirectEntity() instanceof AreaEffectCloud) {
            return this == source.getEntity();
        }
        return super.hurt(source, damage);
    }

    public boolean isAngryAtAllPlayers(Level level) {
        return !this.isTame();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.BABY_ENDER_DRAGON;
    }
}

