/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.oceansdelight.datagen;

import com.mojang.logging.LogUtils;
import com.scouter.oceansdelight.blocks.ODBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class BlockstateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public BlockstateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "oceansdelight", exFileHelper);
    }

    private String blockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"oceansdelight", (String)("block/" + path));
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.feastBlock((FeastBlock)ODBlocks.GUARDIAN_SOUP.get());
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            IntegerProperty servingsProperty = block.getServingsProperty();
            int servings = (Integer)state.getValue((Property)servingsProperty);
            Object suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 0) {
                suffix = block.hasLeftovers ? "_leftover" : "_stage" + (servingsProperty.getPossibleValues().toArray().length - 2);
            }
            ConfiguredModel.Builder var10000 = ConfiguredModel.builder();
            String var10002 = this.blockName((Block)block);
            return var10000.modelFile(this.existingModel(var10002 + (String)suffix)).rotationY(((int)((Direction)state.getValue((Property)FeastBlock.FACING)).toYRot() + 180) % 360).build();
        });
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public void tomatoBlock(Block block, ResourceLocation texture, String renderType) {
        this.tomatoBlock(block, this.key(block).toString(), texture, renderType);
    }

    public void tomatoBlock(Block block, String baseName, ResourceLocation texture, String renderType) {
        ModelBuilder age1 = ((BlockModelBuilder)this.models().cross(baseName + "_stage0", ResourceLocation.parse((String)(texture.toString() + "_stage0")))).renderType(renderType);
        ModelBuilder age2 = ((BlockModelBuilder)this.models().cross(baseName + "_stage1", ResourceLocation.parse((String)(texture.toString() + "_stage1")))).renderType(renderType);
        ModelBuilder age3 = ((BlockModelBuilder)this.models().cross(baseName + "_stage2", ResourceLocation.parse((String)(texture.toString() + "_stage2")))).renderType(renderType);
        ModelBuilder age4 = ((BlockModelBuilder)this.models().cross(baseName + "_stage3", ResourceLocation.parse((String)(texture.toString() + "_stage3")))).renderType(renderType);
        this.tomatoBlock(block, (ModelFile)age1, (ModelFile)age2, (ModelFile)age3, (ModelFile)age4);
    }

    private void tomatoBlock(Block block, ModelFile age1, ModelFile age2, ModelFile age3, ModelFile age4) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            switch ((Integer)state.getValue((Property)BlockStateProperties.AGE_3)) {
                default: {
                    return ConfiguredModel.builder().modelFile(age1).build();
                }
                case 1: {
                    return ConfiguredModel.builder().modelFile(age2).build();
                }
                case 2: {
                    return ConfiguredModel.builder().modelFile(age3).build();
                }
                case 3: 
            }
            return ConfiguredModel.builder().modelFile(age4).build();
        }, new Property[0]);
    }

    public String getName() {
        return "Block States: oceansdelight";
    }
}

