/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.sprite;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jetbrains.annotations.Nullable;

public class Material {
    private final ResourceLocation atlasLocation;
    private final ResourceLocation texture;
    private final Function<ResourceLocation, TextureAtlasSprite> spriteFunction;
    @Nullable
    private RenderType renderType;
    @Nullable
    private net.minecraft.client.resources.model.Material vanillaMat;

    public Material(ResourceLocation atlasLocation, ResourceLocation texture, Function<ResourceLocation, TextureAtlasSprite> spriteFunction) {
        this.atlasLocation = atlasLocation;
        this.texture = texture;
        this.spriteFunction = spriteFunction;
    }

    public ResourceLocation atlasLocation() {
        return this.atlasLocation;
    }

    public ResourceLocation texture() {
        return this.texture;
    }

    public TextureAtlasSprite sprite() {
        return this.spriteFunction.apply(this.texture());
    }

    public RenderType renderType(Function<ResourceLocation, RenderType> typeBuilder) {
        if (this.renderType == null) {
            this.renderType = typeBuilder.apply(this.atlasLocation());
        }
        return this.renderType;
    }

    public VertexConsumer buffer(MultiBufferSource buffers, Function<ResourceLocation, RenderType> typeBuilder) {
        return buffers.getBuffer(this.renderType(typeBuilder));
    }

    public net.minecraft.client.resources.model.Material getVanillaMat() {
        if (this.vanillaMat == null) {
            this.vanillaMat = new net.minecraft.client.resources.model.Material(this.atlasLocation, this.texture);
        }
        return this.vanillaMat;
    }

    public static Material fromAtlas(ResourceLocation atlasLocation, String texture) {
        return new Material(atlasLocation, ResourceLocation.fromNamespaceAndPath((String)atlasLocation.getNamespace(), (String)texture), e -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(atlasLocation).apply(e));
    }

    @Nullable
    public static Material fromSprite(@Nullable TextureAtlasSprite sprite) {
        if (sprite == null) {
            return null;
        }
        return new Material(sprite.atlasLocation(), sprite.contents().name(), e -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(sprite.atlasLocation()).apply(e));
    }

    public static Material fromRawTexture(ResourceLocation texture) {
        return new Material(texture, texture, FullSprite::new);
    }

    private static class FullSprite
    extends TextureAtlasSprite {
        private FullSprite(ResourceLocation location) {
            super(location, new SpriteContents(location, new FrameSize(1, 1), new NativeImage(1, 1, false), ResourceMetadata.EMPTY), 1, 1, 0, 0);
        }

        public float getU(float u) {
            return u / 16.0f;
        }

        public float getV(float v) {
            return v / 16.0f;
        }
    }
}

