/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.entity.spikes.DripstoneSpikeEntity;
import alexthw.ars_elemental.common.entity.spikes.EnchantedDripstoneEntity;
import alexthw.ars_elemental.common.entity.spikes.IceSpikeEntity;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.util.CompatUtils;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffectSpike
extends ElementalAbstractEffect
implements IDamageEffect {
    public static EffectSpike INSTANCE = new EffectSpike();

    public EffectSpike() {
        super("spike", "Spike");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.getEntity().getOnPos();
        for (int i = 0; i < 3; ++i) {
            if (world.getBlockState(pos.below(i)).isAir()) continue;
            this.summonSpike(world, shooter, spellStats, spellContext, resolver, pos, rayTraceResult.getEntity().position());
            return;
        }
        float damagePerDistance = (float)((Double)this.DAMAGE.get() + spellStats.getAmpMultiplier() * (Double)this.AMP_VALUE.get());
        EnchantedDripstoneEntity spike = new EnchantedDripstoneEntity(world, pos.above(2), resolver, spellStats);
        spike.setHurtsEntities(damagePerDistance, (Integer)this.GENERIC_INT.get());
        world.addFreshEntity((Entity)spike);
        ShapersFocus.tryPropagateEntitySpell((EnchantedFallingBlock)spike, (Level)world, (Entity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
    }

    private void summonSpike(Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver, BlockPos pos, @Nullable Vec3 originalPosition) {
        float baseDamage = (float)((Double)this.DAMAGE.get() + spellStats.getAmpMultiplier() * (Double)this.AMP_VALUE.get());
        DripstoneSpikeEntity spike = CompatUtils.waterCheck(resolver) ? new IceSpikeEntity(world, pos, baseDamage, shooter, spellStats, spellContext, resolver) : new DripstoneSpikeEntity(world, pos, baseDamage, shooter, spellStats, spellContext, resolver);
        world.addFreshEntity((Entity)spike);
        if (originalPosition != null) {
            spike.setPos(new Vec3(originalPosition.x, spike.getY(), originalPosition.z));
        }
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.getBlockPos();
        for (int i = -1; i < 3; ++i) {
            if (world.getBlockState(pos.below(i)).isAir()) continue;
            this.summonSpike(world, shooter, spellStats, spellContext, resolver, pos.below(i), null);
            return;
        }
        float damagePerDistance = (float)((Double)this.DAMAGE.get() + spellStats.getAmpMultiplier() * (Double)this.AMP_VALUE.get());
        EnchantedDripstoneEntity spike = new EnchantedDripstoneEntity(world, pos, resolver, spellStats);
        spike.setHurtsEntities(damagePerDistance, (Integer)this.GENERIC_INT.get());
        world.addFreshEntity((Entity)spike);
        ShapersFocus.tryPropagateEntitySpell((EnchantedFallingBlock)spike, (Level)world, (Entity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
    }

    public int getDefaultManaCost() {
        return 30;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 8.0);
        this.addAmpConfig(builder, 2.5);
        this.addGenericInt(builder, 40, "The maximum damage a thrown spike can deal to a single entity. The damage from thrown spikes scales with the height difference.", "maxFallDamage");
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentExtendTime.INSTANCE, AugmentRandomize.INSTANCE, AugmentFortune.INSTANCE});
    }

    public String getBookDescription() {
        return "Creates a spike of dripstone that will damage entities that touch it. Can be augmented with AoE and Pierce to make it wider or taller, with ExtendTime to make it last longer or with Amplify to make it deal more damage. If a spike can't be placed, a falling spike will be summoned instead, which only can be augmented with Amplify to increase the damage it deals based on the height it falls from.";
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the size of the spike");
        map.put((AbstractAugment)AugmentPierce.INSTANCE, "Increases the height of the spike");
        map.put((AbstractAugment)AugmentExtendTime.INSTANCE, "Extends the time before the spike retracts");
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_WATER});
    }
}

