/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.summon;

import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SummonStrider
extends Strider
implements PlayerRideable,
ISummon {
    public int ticksLeft;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(SummonStrider.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public SummonStrider(EntityType<? extends Strider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SummonStrider(Level pLevel) {
        super((EntityType)ModEntities.STRIDER_SUMMON.get(), pLevel);
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.STRIDER_SUMMON.get();
    }

    public SummonStrider(SummonHorse oldHorse, Player summoner) {
        this(summoner.level());
        BlockPos position = oldHorse.blockPosition();
        this.setPos(position.getX(), position.getY(), position.getZ());
        this.ticksLeft = oldHorse.getTicksLeft();
        this.equipSaddle(Items.SADDLE.getDefaultInstance(), SoundSource.NEUTRAL);
        this.setOwnerID(summoner.getUUID());
        oldHorse.getActiveEffects().stream().filter(e -> ((MobEffect)e.getEffect().value()).isBeneficial()).forEach(arg_0 -> ((SummonStrider)this).addEffect(arg_0));
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    protected boolean canRide(@NotNull Entity pEntity) {
        return pEntity instanceof Player;
    }

    public void travel(@NotNull Vec3 pTravelVector) {
        if (this.isAlive()) {
            LivingEntity livingentity = this.getControllingPassenger();
            if (this.isVehicle() && livingentity != null) {
                this.setYRot(livingentity.getYRot());
                this.yRotO = this.getYRot();
                this.setXRot(livingentity.getXRot() * 0.5f);
                this.setRot(this.getYRot(), this.getXRot());
                this.yHeadRot = this.yBodyRot = this.getYRot();
                float strafe = livingentity.xxa * 0.5f;
                float steer = livingentity.zza;
                if (steer <= 0.0f) {
                    steer *= 0.25f;
                }
                if (this.isControlledByLocalInstance()) {
                    this.setSpeed(this.getSpeed());
                    super.travel(new Vec3((double)strafe, pTravelVector.y, (double)steer));
                } else if (livingentity instanceof Player) {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                this.tryCheckInsideBlocks();
            } else {
                super.travel(pTravelVector);
            }
        }
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        if (!player.level().isClientSide() && player.getMainHandItem().isEmpty() && !player.isShiftKeyDown()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int getBaseExperienceReward() {
        return 0;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(OWNER_UUID, Optional.of(Util.NIL_UUID));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.level()), (BlockPos)this.blockPosition());
                this.remove(Entity.RemovalReason.DISCARDED);
                this.onSummonDeath(this.level(), null, true);
            }
        }
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        this.onSummonDeath(this.level(), cause, false);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.ticksLeft = compound.getInt("left");
        UUID uuid = null;
        if (compound.hasUUID("owner")) {
            uuid = compound.getUUID("owner");
        }
        if (uuid != null) {
            this.setOwnerID(uuid);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("left", this.ticksLeft);
        this.writeOwner(compound);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.getEntityData().get(OWNER_UUID)).isEmpty() ? this.getUUID() : (UUID)((Optional)this.getEntityData().get(OWNER_UUID)).get();
    }

    public void setOwnerID(UUID uuid) {
        this.getEntityData().set(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public Strider getBreedOffspring(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }

    public boolean isFood(@NotNull ItemStack pStack) {
        return false;
    }

    protected void dropEquipment() {
    }

    public boolean canMate(@NotNull Animal pOtherAnimal) {
        return false;
    }

    public boolean canBreed() {
        return false;
    }

    public boolean canFallInLove() {
        return false;
    }
}

