/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.familiars;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.FlashjackEntity;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.entity.familiar.FlyingFamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;

public class FlashjackFamiliar
extends FlyingFamiliarEntity
implements ISpellCastListener {
    static final Map<DyeColor, String> dyeToVariantMap = Map.of(DyeColor.RED, "flapjack", DyeColor.YELLOW, "flashjack");
    public static List<AbstractSpellPart> movementGlyphs = new ArrayList<AbstractSpellPart>();

    public FlashjackFamiliar(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
    }

    public FlashjackFamiliar(Level world) {
        super((EntityType)ModEntities.FLASHJACK_FAMILIAR.get(), world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new Parrot.ParrotWanderGoal((PathfinderMob)this, 1.0));
    }

    public boolean isActive() {
        return this.getTarget() != null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "idle_controller", 5, event -> this.onGround() ? event.setAndContinue(FlashjackEntity.inactive) : event.setAndContinue(FlashjackEntity.idle)));
        data.add(new AnimationController((GeoAnimatable)this, "action_controller", 5, event -> {
            if (this.isActive() && !event.isCurrentAnimation(FlashjackEntity.attack)) {
                return event.setAndContinue(FlashjackEntity.attack);
            }
            if (((FlashjackFamiliar)event.getAnimatable()).onGround()) {
                return PlayState.STOP;
            }
            if (event.isCurrentAnimation(FlashjackEntity.attack) && event.animationTick < 100.0) {
                return PlayState.CONTINUE;
            }
            return event.setAndContinue(FlashjackEntity.flapping);
        }));
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!player.level.isClientSide && player.equals((Object)this.getOwner())) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.getItem() == ((ArchfruitPod)ModItems.FLASHING_POD.get()).asItem()) {
                if (!player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 6000, 0, false, false));
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 6000, 0, false, false));
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 6000, 0, false, false));
            } else if (player.getMainHandItem().is(Tags.Items.DYES)) {
                DyeColor color = DyeColor.getColor((ItemStack)stack);
                if (color == null) {
                    return InteractionResult.PASS;
                }
                String variant = dyeToVariantMap.getOrDefault(color, "flashjack");
                if (((String)this.entityData.get(COLOR)).equals(variant)) {
                    return InteractionResult.SUCCESS;
                }
                this.setColor(variant);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public void onModifier(SpellModifierEvent event) {
        if (this.isAlive() && this.getOwner() != null && this.getOwner().equals((Object)event.caster) && SpellSchools.ELEMENTAL_AIR.isPartOfSchool(event.spellPart)) {
            event.builder.addDamageModifier(2.0);
        }
    }

    public void onCostCalc(SpellCostCalcEvent event) {
        if (this.isAlive() && this.getOwner() != null && this.getOwner().equals((Object)event.context.getUnwrappedCaster()) && movementGlyphs.contains(event.context.getSpell().unsafeList().getFirst())) {
            event.currentCost = (int)((double)event.currentCost - (double)event.context.getSpell().getCost() * 0.5);
        }
    }

    @NotNull
    public ResourceLocation getTexture() {
        String variant = this.getColor().toLowerCase();
        if (variant.isEmpty()) {
            variant = "flashjack";
        }
        return ArsElemental.prefix("textures/entity/" + variant + ".png");
    }
}

