/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.new_slab_variants.core.common.block;

import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LeavesSlabBlock
extends LeavesBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.SLAB_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final int DECAY_DISTANCE = 7;
    public static final IntegerProperty DISTANCE = BlockStateProperties.DISTANCE;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    private static final int TICK_DELAY = 1;

    public LeavesSlabBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean useShapeForLightOcclusion(BlockState $$0) {
        return $$0.getValue(TYPE) != SlabType.DOUBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.add(new Property[]{DISTANCE, PERSISTENT, TYPE, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState $$0, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        SlabType $$4 = (SlabType)$$0.getValue(TYPE);
        switch ($$4) {
            case DOUBLE: {
                return Shapes.block();
            }
            case TOP: {
                return TOP_AABB;
            }
        }
        return BOTTOM_AABB;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext $$0) {
        BlockPos $$1 = $$0.getClickedPos();
        BlockState $$2 = $$0.getLevel().getBlockState($$1);
        if ($$2.is((Block)this)) {
            return (BlockState)((BlockState)$$2.setValue(TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState $$3 = $$0.getLevel().getFluidState($$1);
        BlockState $$4 = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue(TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf($$3.getType() == Fluids.WATER));
        Direction $$5 = $$0.getClickedFace();
        return !($$5 == Direction.DOWN || $$5 != Direction.UP && $$0.getClickLocation().y - (double)$$1.getY() > 0.5) ? LeavesSlabBlock.updateDistance($$4, (LevelAccessor)$$0.getLevel(), $$0.getClickedPos()) : LeavesSlabBlock.updateDistance((BlockState)$$4.setValue(TYPE, (Comparable)SlabType.TOP), (LevelAccessor)$$0.getLevel(), $$0.getClickedPos());
    }

    public boolean canBeReplaced(BlockState $$0, BlockPlaceContext $$1) {
        ItemStack $$2 = $$1.getItemInHand();
        SlabType $$3 = (SlabType)$$0.getValue(TYPE);
        if ($$3 != SlabType.DOUBLE && $$2.is(this.asItem())) {
            if ($$1.replacingClickedOnBlock()) {
                boolean $$4 = $$1.getClickLocation().y - (double)$$1.getClickedPos().getY() > 0.5;
                Direction $$5 = $$1.getClickedFace();
                if ($$3 == SlabType.BOTTOM) {
                    return $$5 == Direction.UP || $$4 && $$5.getAxis().isHorizontal();
                }
                return $$5 == Direction.DOWN || !$$4 && $$5.getAxis().isHorizontal();
            }
            return true;
        }
        return false;
    }

    public FluidState getFluidState(BlockState $$0) {
        return (Boolean)$$0.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState($$0);
    }

    public boolean placeLiquid(LevelAccessor $$0, BlockPos $$1, BlockState $$2, FluidState $$3) {
        return $$2.getValue(TYPE) != SlabType.DOUBLE ? super.placeLiquid($$0, $$1, $$2, $$3) : false;
    }

    public boolean canPlaceLiquid(@Nullable Player $$0, BlockGetter $$1, BlockPos $$2, BlockState $$3, Fluid $$4) {
        return $$3.getValue(TYPE) != SlabType.DOUBLE ? super.canPlaceLiquid($$0, $$1, $$2, $$3, $$4) : false;
    }

    public BlockState updateShape(BlockState p_54440_, Direction p_54441_, BlockState p_54442_, LevelAccessor p_54443_, BlockPos p_54444_, BlockPos p_54445_) {
        int i;
        if (((Boolean)p_54440_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_54443_.scheduleTick(p_54444_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_54443_));
        }
        if ((i = LeavesSlabBlock.getDistanceAt(p_54442_) + 1) != 1 || (Integer)p_54440_.getValue((Property)DISTANCE) != i) {
            p_54443_.scheduleTick(p_54444_, (Block)this, 1);
        }
        return p_54440_;
    }

    public boolean isPathfindable(BlockState $$0, BlockGetter $$1, BlockPos $$2, PathComputationType $$3) {
        switch ($$3) {
            case LAND: {
                return false;
            }
            case WATER: {
                return $$1.getFluidState($$2).is(FluidTags.WATER);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape getBlockSupportShape(BlockState p_54456_, BlockGetter p_54457_, BlockPos p_54458_) {
        return Shapes.empty();
    }

    public boolean isRandomlyTicking(BlockState p_54449_) {
        return (Integer)p_54449_.getValue((Property)DISTANCE) == 7 && (Boolean)p_54449_.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(BlockState p_221379_, ServerLevel p_221380_, BlockPos p_221381_, RandomSource p_221382_) {
        if (this.decaying(p_221379_)) {
            LeavesSlabBlock.dropResources((BlockState)p_221379_, (Level)p_221380_, (BlockPos)p_221381_);
            p_221380_.removeBlock(p_221381_, false);
        }
    }

    protected boolean decaying(BlockState p_221386_) {
        return (Boolean)p_221386_.getValue((Property)PERSISTENT) == false && (Integer)p_221386_.getValue((Property)DISTANCE) == 7;
    }

    public void tick(BlockState p_221369_, ServerLevel p_221370_, BlockPos p_221371_, RandomSource p_221372_) {
        p_221370_.setBlock(p_221371_, LeavesSlabBlock.updateDistance(p_221369_, (LevelAccessor)p_221370_, p_221371_), 3);
    }

    public int getLightBlock(BlockState p_54460_, BlockGetter p_54461_, BlockPos p_54462_) {
        return 1;
    }

    private static BlockState updateDistance(BlockState p_54436_, LevelAccessor p_54437_, BlockPos p_54438_) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)p_54438_, direction);
            i = Math.min(i, LeavesSlabBlock.getDistanceAt(p_54437_.getBlockState((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)p_54436_.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState p_54464_) {
        return LeavesSlabBlock.getOptionalDistanceAt(p_54464_).orElse(7);
    }

    public static OptionalInt getOptionalDistanceAt(BlockState p_277868_) {
        if (p_277868_.is(BlockTags.LOGS)) {
            return OptionalInt.of(0);
        }
        return p_277868_.hasProperty((Property)DISTANCE) ? OptionalInt.of((Integer)p_277868_.getValue((Property)DISTANCE)) : OptionalInt.empty();
    }

    public void animateTick(BlockState p_221374_, Level p_221375_, BlockPos p_221376_, RandomSource p_221377_) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!p_221375_.isRainingAt(p_221376_.above()) || p_221377_.nextInt(15) != 1 || (blockstate = p_221375_.getBlockState(blockpos = p_221376_.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)p_221375_, blockpos, Direction.UP))) {
            ParticleUtils.spawnParticleBelow((Level)p_221375_, (BlockPos)p_221376_, (RandomSource)p_221377_, (ParticleOptions)ParticleTypes.DRIPPING_WATER);
        }
    }
}

