/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.Lazy;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillTask
extends Task {
    private static final ResourceLocation ZOMBIE = ResourceLocation.withDefaultNamespace((String)"zombie");
    private static final Lazy<NameMap<ResourceLocation>> entityNameMap = Lazy.of(KillTask::scanEntityTypes);
    private static final Lazy<NameMap<String>> entityTagMap = Lazy.of(KillTask::scanEntityTags);
    private ResourceLocation entityTypeId = ZOMBIE;
    private TagKey<EntityType<?>> entityTypeTag = null;
    private long value = 100L;
    private String customName = "";
    private static final Map<ResourceLocation, Icon> entityIcons = new HashMap<ResourceLocation, Icon>();

    public KillTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.KILL;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("entity", this.entityTypeId.toString());
        if (this.entityTypeTag != null) {
            nbt.putString("entityTypeTag", this.entityTypeTag.location().toString());
        }
        nbt.putLong("value", this.value);
        if (!this.customName.isEmpty()) {
            nbt.putString("custom_name", this.customName);
        }
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.entityTypeId = ResourceLocation.tryParse((String)nbt.getString("entity"));
        this.entityTypeTag = KillTask.parseTypeTag(nbt.getString("entityTypeTag"));
        this.value = nbt.getLong("value");
        this.customName = nbt.getString("custom_name");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.entityTypeId.toString());
        buffer.writeUtf(this.entityTypeTag == null ? "" : this.entityTypeTag.location().toString());
        buffer.writeVarLong(this.value);
        buffer.writeUtf(this.customName);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.entityTypeId = ResourceLocation.tryParse((String)buffer.readUtf());
        this.entityTypeTag = KillTask.parseTypeTag(buffer.readUtf());
        this.value = buffer.readVarInt();
        this.customName = buffer.readUtf();
    }

    @Nullable
    private static TagKey<EntityType<?>> parseTypeTag(String tag) {
        ResourceLocation rl;
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        if (tag.startsWith("#")) {
            tag = tag.substring(1);
        }
        return (rl = ResourceLocation.tryParse((String)tag)) == null || rl.getPath().isEmpty() ? null : TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)rl);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("entity", (Object)this.entityTypeId, v -> {
            this.entityTypeId = v;
        }, (NameMap)entityNameMap.get(), (Object)ZOMBIE);
        config.addEnum("entity_type_tag", (Object)this.getTypeTagStr(), v -> {
            this.entityTypeTag = KillTask.parseTypeTag(v);
        }, (NameMap)entityTagMap.get());
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE);
        config.addString("custom_name", this.customName, v -> {
            this.customName = v;
        }, "");
    }

    private String getTypeTagStr() {
        return this.entityTypeTag == null ? "" : this.entityTypeTag.location().toString();
    }

    private static Icon getIconForEntityType(ResourceLocation typeId) {
        return entityIcons.computeIfAbsent(typeId, k -> {
            ItemStack stack;
            Entity e;
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId);
            if (entityType.equals(EntityType.PLAYER)) {
                return Icons.PLAYER;
            }
            SpawnEggItem item = SpawnEggItem.byId((EntityType)entityType);
            if (item == null && (e = entityType.create(FTBQuestsClient.getClientLevel())) != null && (stack = e.getPickResult()) != null) {
                item = stack.getItem();
            }
            return ItemIcon.getItemIcon((Item)(item != null ? item : Items.SPAWNER));
        });
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        entityNameMap.invalidate();
        entityTagMap.invalidate();
        entityIcons.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        MutableComponent name;
        MutableComponent mutableComponent = name = this.entityTypeTag == null ? Component.translatable((String)("entity." + this.entityTypeId.toLanguageKey())) : Component.literal((String)("#" + this.getTypeTagStr()));
        if (!this.customName.isEmpty()) {
            return Component.translatable((String)"ftbquests.task.ftbquests.kill.title_named", (Object[])new Object[]{this.formatMaxProgress(), name, Component.literal((String)this.customName)});
        }
        return Component.translatable((String)"ftbquests.task.ftbquests.kill.title", (Object[])new Object[]{this.formatMaxProgress(), name});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.entityTypeTag == null) {
            return KillTask.getIconForEntityType(this.entityTypeId);
        }
        ArrayList icons = new ArrayList();
        BuiltInRegistries.ENTITY_TYPE.getTag(this.entityTypeTag).ifPresent(set -> set.forEach(holder -> holder.unwrapKey().map(k -> icons.add(KillTask.getIconForEntityType(k.location())))));
        return icons.isEmpty() ? Icons.BARRIER : IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void kill(TeamData teamData, LivingEntity e) {
        if (!teamData.isCompleted(this) && this.match(e)) {
            teamData.addProgress(this, 1L);
        }
    }

    private boolean match(LivingEntity e) {
        return this.entityTypeTag == null ? this.entityTypeId.equals((Object)RegistrarManager.getId((Object)e.getType(), (ResourceKey)Registries.ENTITY_TYPE)) && this.nameMatchOK(e) : e.getType().is(this.entityTypeTag) && this.nameMatchOK(e);
    }

    private boolean nameMatchOK(LivingEntity e) {
        Player p;
        return this.customName.isEmpty() || (e instanceof Player ? (p = (Player)e).getGameProfile().getName().equals(this.customName) : e.getName().getString().equals(this.customName));
    }

    @NotNull
    private static NameMap<ResourceLocation> scanEntityTypes() {
        ArrayList ids = new ArrayList();
        BuiltInRegistries.ENTITY_TYPE.forEach(type -> {
            try {
                if (type.create(FTBQuestsClient.getClientLevel()) instanceof LivingEntity) {
                    ids.add(type.arch$registryName());
                }
            }
            catch (Exception e) {
                FTBQuests.LOGGER.warn("Entity creation failed during kill task scanning for {}: {}", (Object)type.arch$registryName(), (Object)e.getMessage());
            }
        });
        ids.sort((r1, r2) -> {
            MutableComponent c1 = Component.translatable((String)("entity." + r1.toLanguageKey()));
            MutableComponent c2 = Component.translatable((String)("entity." + r2.toLanguageKey()));
            return c1.getString().compareTo(c2.getString());
        });
        return NameMap.of((Object)ZOMBIE, ids).name(id -> Component.translatable((String)("entity." + id.toLanguageKey())).append((Component)Component.empty().withStyle(ChatFormatting.GRAY).append(" [").append((Component)Component.literal((String)id.toString())).append("]"))).icon(KillTask::getIconForEntityType).create();
    }

    @NotNull
    private static NameMap<String> scanEntityTags() {
        ArrayList<String> tags = new ArrayList<String>(List.of(""));
        tags.addAll(BuiltInRegistries.ENTITY_TYPE.getTags().map(pair -> ((TagKey)pair.getFirst()).location().toString()).sorted().toList());
        return NameMap.of((Object)"minecraft:zombies", tags).create();
    }
}

