/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record ClaimRewardMessage(long id, boolean shouldNotify) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClaimRewardMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("claim_reward_message"));
    public static final StreamCodec<FriendlyByteBuf, ClaimRewardMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, ClaimRewardMessage::id, (StreamCodec)ByteBufCodecs.BOOL, ClaimRewardMessage::shouldNotify, ClaimRewardMessage::new);

    public CustomPacketPayload.Type<ClaimRewardMessage> type() {
        return TYPE;
    }

    public static void handle(ClaimRewardMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player patt0$temp;
            Reward reward = ServerQuestFile.INSTANCE.getReward(message.id);
            if (reward != null && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ServerQuestFile.INSTANCE.getTeamData((Player)player).ifPresent(teamData -> {
                    if (teamData.isCompleted(reward.getQuest())) {
                        teamData.claimReward(player, reward, message.shouldNotify);
                    }
                });
            }
        });
    }
}

