/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.item_filtering;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.integration.item_filtering.DisplayStacksCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.ItemStack;

public enum ItemMatchingSystem {
    INSTANCE;

    private final List<ItemFilterAdapter> adapters = new CopyOnWriteArrayList<ItemFilterAdapter>();

    public void registerFilterAdapter(ItemFilterAdapter adapter) {
        this.adapters.add(adapter);
    }

    public boolean isItemFilter(ItemStack stack) {
        return this.getFilterAdapter(stack).isPresent();
    }

    public Optional<ItemFilterAdapter> getFilterAdapter(ItemStack stack) {
        return this.adapters.stream().filter(adapter -> adapter.isFilterStack(stack)).findFirst();
    }

    public boolean doesItemMatch(ItemStack filterStack, ItemStack toCheck, ComponentMatchType matchType, HolderLookup.Provider registryAccess) {
        return this.getFilterAdapter(filterStack).map(adapter -> adapter.doesItemMatch(filterStack, toCheck, registryAccess)).orElse(this.areItemStacksEqual(filterStack, toCheck, matchType));
    }

    public List<ItemStack> getAllMatchingStacks(ItemStack filterStack, HolderLookup.Provider registryAccess) {
        ArrayList res = new ArrayList();
        this.adapters.forEach(adapter -> {
            if (adapter.isFilterStack(filterStack)) {
                res.addAll(DisplayStacksCache.getCachedDisplayStacks(filterStack, adapter, registryAccess));
            }
        });
        return res.isEmpty() ? List.of(filterStack) : res;
    }

    private boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB, ComponentMatchType matchType) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.getItem() != stackB.getItem()) {
            return false;
        }
        return switch (matchType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> this.fuzzyMatch(stackA.getComponents(), stackB.getComponents());
            case 2 -> ItemStack.isSameItemSameComponents((ItemStack)stackA, (ItemStack)stackB);
        };
    }

    private boolean fuzzyMatch(DataComponentMap map, DataComponentMap toMatch) {
        return map.stream().allMatch(tc -> toMatch.has(tc.type()) && toMatch.get(tc.type()).equals(tc.value()));
    }

    public Collection<ItemFilterAdapter> adapters() {
        return Collections.unmodifiableCollection(this.adapters);
    }

    public static enum ComponentMatchType {
        NONE("none"),
        FUZZY("fuzzy"),
        STRICT("strict");

        public static final NameMap<ComponentMatchType> NAME_MAP;
        private final String name;

        private ComponentMatchType(String name) {
            this.name = name;
        }

        static {
            NAME_MAP = NameMap.of((Object)((Object)NONE), (Object[])ComponentMatchType.values()).id(v -> v.name).create();
        }
    }
}

