/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.integration.currency;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.integration.currency.CurrencyProvider;
import dev.ftb.mods.ftblibrary.integration.currency.FallbackCurrencyProvider;
import java.util.Objects;

public enum CurrencyHelper {
    INSTANCE;

    private CurrencyProvider activeImpl = null;

    public static CurrencyHelper getInstance() {
        return INSTANCE;
    }

    public void setActiveImpl(CurrencyProvider newProvider) {
        if (this.activeImpl != null) {
            FTBLibrary.LOGGER.warn("Overriding existing currency provider: {} -> {}", (Object)this.activeImpl.getName(), (Object)newProvider.getName());
        } else {
            FTBLibrary.LOGGER.info("Setting permissions currency implementation to: {}", (Object)newProvider.getName());
        }
        this.activeImpl = newProvider;
    }

    public CurrencyProvider getProvider() {
        return Objects.requireNonNullElse(this.activeImpl, FallbackCurrencyProvider.INSTANCE);
    }
}

