/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification.selection.selectors;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelectorSerializers;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.common.conditions.FalseCondition;
import net.neoforged.neoforge.common.conditions.ICondition;

public record ChoiceResourceSelector(ConditionedResourceSelector first, ConditionedResourceSelector second, ICondition condition) implements ResourceSelector<ChoiceResourceSelector>
{
    public ChoiceResourceSelector(ResourceSelector<?> first, ResourceSelector<?> second, ICondition condition) {
        this(new ConditionedResourceSelector(first), new ConditionedResourceSelector(second), condition);
    }

    @Override
    public Either<Set<ResourceLocation>, Predicate<ResourceLocation>> select() {
        return this.condition.test(ICondition.IContext.EMPTY) ? this.first.select() : this.second.select();
    }

    public Serializer getSerializer() {
        return ResourceSelectorSerializers.CHOICE;
    }

    public static final class Serializer
    implements ResourceSelector.Serializer<ChoiceResourceSelector> {
        @Override
        public JsonElement serialize(ChoiceResourceSelector selector) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("first", selector.first.serialize());
            jsonObject.add("second", selector.second.serialize());
            jsonObject.add("condition", (JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)selector.condition).mapOrElse(element -> element, error -> JsonNull.INSTANCE));
            return jsonObject;
        }

        @Override
        public ChoiceResourceSelector deserialize(JsonElement element) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonObject conditionObject = GsonHelper.convertToJsonObject((JsonElement)jsonObject.get("condition"), (String)"condition");
            DataResult result = ICondition.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)conditionObject);
            if (result.isError()) {
                return new ChoiceResourceSelector(ConditionedResourceSelector.EMPTY, ConditionedResourceSelector.deserialize("second", (JsonElement)GsonHelper.convertToJsonObject((JsonElement)jsonObject.get("second"), (String)"second")), (ICondition)FalseCondition.INSTANCE);
            }
            return new ChoiceResourceSelector(ConditionedResourceSelector.deserialize("first", jsonObject.get("first")), ConditionedResourceSelector.deserialize("second", jsonObject.get("second")), (ICondition)((Pair)result.result().get()).getFirst());
        }
    }
}

