/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification;

import com.google.common.collect.HashMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierGroup;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierSerializerRegistry;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.EventPriority;

public class ObjectModificationManager<T, S, D>
extends SimpleJsonResourceReloadListener {
    public static final String MAIN_PATH = "modifiers";
    private static final HashMultimap<String, Initializer<?>> INITIALIZER_MAP = HashMultimap.create();
    protected final EnumMap<EventPriority, Pair<Map<ResourceLocation, List<ObjectModifier<T, S, D, ?>>>, List<Pair<Predicate<ResourceLocation>, List<ObjectModifier<T, S, D, ?>>>>>> prioritizedAssignedModifiers = new EnumMap(EventPriority.class);
    private final String type;
    private final ObjectModifierSerializerRegistry<T, S, D> serializerRegistry;
    private final Function<ResourceLocation, D> additionalDeserializationGetter;
    private final boolean logSkipping;
    private final boolean allowPriority;

    public ObjectModificationManager(Gson gson, String directory, String type, ObjectModifierSerializerRegistry<T, S, D> serializerRegistry, Function<ResourceLocation, D> additionalDeserializationGetter, boolean logSkipping, boolean allowPriority) {
        super(gson, "modifiers/" + directory);
        this.type = type;
        this.serializerRegistry = serializerRegistry;
        this.additionalDeserializationGetter = additionalDeserializationGetter;
        this.logSkipping = logSkipping;
        this.allowPriority = allowPriority;
    }

    public ObjectModificationManager(Gson gson, String directory, String type, ObjectModifierSerializerRegistry<T, S, D> serializerRegistry, D additionalDeserializationObject, boolean logSkipping, boolean allowPriority) {
        this(gson, directory, type, (ObjectModifierSerializerRegistry<T, S, Function<ResourceLocation, Object>>)serializerRegistry, location -> additionalDeserializationObject, logSkipping, allowPriority);
    }

    public void applyModifiers(EventPriority eventPriority, ResourceLocation location, T value) {
        Pair<Map<ResourceLocation, List<ObjectModifier<T, S, D, ?>>>, List<Pair<Predicate<ResourceLocation>, List<ObjectModifier<T, S, D, ?>>>>> assignedModifiers = this.prioritizedAssignedModifiers.get(eventPriority);
        if (assignedModifiers != null) {
            List dynamicModifiers;
            Map directModifiers = (Map)assignedModifiers.getFirst();
            List modifiers = (List)directModifiers.get(location);
            if (modifiers != null) {
                modifiers.forEach(modifier -> modifier.modify(value));
            }
            if (!(dynamicModifiers = (List)assignedModifiers.getSecond()).isEmpty()) {
                for (Pair dynamicModifier : dynamicModifiers) {
                    if (!((Predicate)dynamicModifier.getFirst()).test(location)) continue;
                    ((List)dynamicModifier.getSecond()).forEach(modifier -> modifier.modify(value));
                }
            }
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        String type = this.type;
        int groupsLoaded = 0;
        ObjectModifierSerializerRegistry<T, S, D> serializerRegistry = this.serializerRegistry;
        Function<ResourceLocation, D> additionalDeserializationGetter = this.additionalDeserializationGetter;
        boolean logSkipping = this.logSkipping;
        boolean allowPriority = this.allowPriority;
        EnumMap<EventPriority, Pair<Map<ResourceLocation, List<ObjectModifier<T, S, D, ?>>>, List<Pair<Predicate<ResourceLocation>, List<ObjectModifier<T, S, D, ?>>>>>> prioritizedAssignedModifiers = this.prioritizedAssignedModifiers;
        prioritizedAssignedModifiers.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            try {
                ObjectModifierGroup<T, S, D> group = ObjectModifierGroup.deserialize(resourcelocation.toString(), entry.getValue().getAsJsonObject(), additionalDeserializationGetter.apply(resourcelocation), serializerRegistry, logSkipping, allowPriority);
                Pair assignedModifiers = prioritizedAssignedModifiers.computeIfAbsent(group.priority(), __ -> Pair.of(new HashMap(), new ArrayList()));
                List<ObjectModifier<T, S, D, ?>> groupModifiers = group.modifiers();
                Either<Set<ResourceLocation>, Predicate<ResourceLocation>> either = group.selector().select();
                Optional locations = either.left();
                if (locations.isPresent()) {
                    Map directModifiers = (Map)assignedModifiers.getFirst();
                    for (ResourceLocation location : (Set)locations.get()) {
                        directModifiers.computeIfAbsent(location, __ -> new ArrayList()).addAll(groupModifiers);
                    }
                } else {
                    ((List)assignedModifiers.getSecond()).add(Pair.of((Object)((Predicate)either.right().get()), groupModifiers));
                }
                ++groupsLoaded;
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                Blueprint.LOGGER.error("Parsing error loading " + type + " Modifier Group: {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        Blueprint.LOGGER.info(type + " Modification Manager has loaded {} modifier groups", (Object)groupsLoaded);
    }

    @FunctionalInterface
    public static interface Initializer<OM extends ObjectModificationManager<?, ?, ?>> {
        public OM init(RegistryAccess.Frozen var1, Commands.CommandSelection var2, ReloadableServerResources var3);
    }
}

