/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import java.util.List;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

public final class TradeUtil {
    public static final int NOVICE = 1;
    public static final int APPRENTICE = 2;
    public static final int JOURNEYMAN = 3;
    public static final int EXPERT = 4;
    public static final int MASTER = 5;

    public static void addVillagerTrades(VillagerTradesEvent event, int level, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            ((List)event.getTrades().get(level)).add(trade);
        }
    }

    public static void addVillagerTrades(VillagerTradesEvent event, VillagerProfession profession, int level, VillagerTrades.ItemListing ... trades) {
        if (event.getType() == profession) {
            TradeUtil.addVillagerTrades(event, level, trades);
        }
    }

    public static void addWandererTrades(WandererTradesEvent event, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            event.getGenericTrades().add(trade);
        }
    }

    public static void addRareWandererTrades(WandererTradesEvent event, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            event.getRareTrades().add(trade);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, int level, VillagerTrades.ItemListing ... trades) {
        if (ModList.get().isLoaded(modid)) {
            TradeUtil.addVillagerTrades(event, level, trades);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, VillagerProfession profession, int level, VillagerTrades.ItemListing ... trades) {
        if (ModList.get().isLoaded(modid)) {
            TradeUtil.addVillagerTrades(event, profession, level, trades);
        }
    }

    public static void addCompatWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ItemListing ... trades) {
        if (ModList.get().isLoaded(modid)) {
            TradeUtil.addWandererTrades(event, trades);
        }
    }

    public static void addCompatRareWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ItemListing ... trades) {
        if (ModList.get().isLoaded(modid)) {
            TradeUtil.addRareWandererTrades(event, trades);
        }
    }

    public static class BlueprintTrade
    extends BasicItemListing {
        public BlueprintTrade(ItemStack input, ItemStack input2, ItemStack output, int maxTrades, int xp, float priceMult) {
            super(input, input2, output, maxTrades, xp, priceMult);
        }

        public BlueprintTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((ItemLike)input, inputCount), ItemStack.EMPTY, new ItemStack((ItemLike)output, outputCount), maxTrades, xp, priceMult);
        }

        public BlueprintTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp) {
            this(input, inputCount, output, outputCount, maxTrades, xp, 0.15f);
        }

        public BlueprintTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((ItemLike)input, inputCount), ItemStack.EMPTY, new ItemStack((ItemLike)Items.EMERALD, emeraldCount), maxTrades, xp, priceMult);
        }

        public BlueprintTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp) {
            this(input, inputCount, emeraldCount, maxTrades, xp, 0.15f);
        }

        public BlueprintTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((ItemLike)Items.EMERALD, emeraldCount), ItemStack.EMPTY, new ItemStack((ItemLike)output, outputCount), maxTrades, xp, priceMult);
        }

        public BlueprintTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp) {
            this(emeraldCount, output, outputCount, maxTrades, xp, 0.15f);
        }
    }
}

