/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.other;

import com.teamabnormals.blueprint.common.network.particle.SpawnParticlesPayload;
import com.teamabnormals.blueprint.core.other.tags.BlueprintBlockTags;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.NoteBlock;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.NoteBlockEvent;

@EventBusSubscriber(modid="blueprint")
public final class BlueprintEvents {
    public static List<DataUtil.CustomNoteBlockInstrument> SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS = null;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onNoteBlockPlay(NoteBlockEvent.Play event) {
        LevelAccessor levelAccessor;
        if (SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS != null && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            BlockSource source = new BlockSource(level, pos, level.getBlockState(pos.relative(Direction.DOWN)), null);
            BlockSource headSource = new BlockSource(level, pos, level.getBlockState(pos.relative(Direction.UP)), null);
            Iterator<DataUtil.CustomNoteBlockInstrument> iterator = SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS.iterator();
            while (iterator.hasNext()) {
                DataUtil.CustomNoteBlockInstrument instrument;
                boolean isMobHead = (instrument = iterator.next()).isMobHead();
                if (!instrument.test(isMobHead ? headSource : source)) continue;
                SoundEvent sound = instrument.getSound();
                int note = event.getVanillaNoteId();
                level.playSound(null, pos, sound, SoundSource.RECORDS, 3.0f, isMobHead ? 1.0f : NoteBlock.getPitchFromNote((int)note));
                if (!isMobHead) {
                    NetworkUtil.spawnParticle(level, (ParticleOptions)ParticleTypes.NOTE, List.of(new SpawnParticlesPayload.ParticleInstance((double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, (double)note / 24.0, 0.0, 0.0)));
                }
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getState().is(BlueprintBlockTags.LEAF_PILES) && event.getEntity().getMainHandItem().is(Tags.Items.TOOLS_SHEAR)) {
            event.setNewSpeed(15.0f);
        }
    }
}

