/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.mixin;

import com.teamabnormals.blueprint.core.api.BlueprintRabbitVariants;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Rabbit.class})
public abstract class RabbitMixin
extends Animal
implements VariantHolder<Rabbit.Variant> {
    protected RabbitMixin(EntityType<? extends Animal> animal, Level level) {
        super(animal, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.putInt("RabbitType", ((Integer)this.entityData.get(Rabbit.DATA_TYPE_ID)).intValue());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.getEntityData().set(Rabbit.DATA_TYPE_ID, (Object)tag.getInt("RabbitType"));
    }

    @Inject(at={@At(value="RETURN")}, method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Rabbit;"}, cancellable=true)
    private void getBreedOffspring(ServerLevel level, AgeableMob ageableMob, CallbackInfoReturnable<Rabbit> cir) {
        Rabbit rabbit = (Rabbit)cir.getReturnValue();
        int id = 0;
        if (this.random.nextInt(20) != 0) {
            if (this.random.nextBoolean() && ageableMob instanceof Rabbit) {
                Rabbit partner = (Rabbit)ageableMob;
                id = (Integer)partner.getEntityData().get(Rabbit.DATA_TYPE_ID);
            } else {
                id = (Integer)this.getEntityData().get(Rabbit.DATA_TYPE_ID);
            }
        } else {
            boolean foundVariant = false;
            for (BlueprintRabbitVariants.BlueprintRabbitVariant newVariant : BlueprintRabbitVariants.values()) {
                if (!newVariant.test((ServerLevelAccessor)level, this.blockPosition())) continue;
                id = newVariant.id();
                foundVariant = true;
                break;
            }
            if (!foundVariant) {
                id = Rabbit.getRandomRabbitVariant((LevelAccessor)level, (BlockPos)this.blockPosition()).id();
            }
        }
        rabbit.getEntityData().set(Rabbit.DATA_TYPE_ID, (Object)id);
        cir.setReturnValue((Object)rabbit);
    }

    @Inject(at={@At(value="RETURN")}, method={"finalizeSpawn"}, cancellable=true)
    private void finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnData, CallbackInfoReturnable<SpawnGroupData> cir) {
        int id = ((Rabbit.Variant)this.getVariant()).id();
        for (BlueprintRabbitVariants.BlueprintRabbitVariant newVariant : BlueprintRabbitVariants.values()) {
            if (!newVariant.test(level, this.blockPosition())) continue;
            id = newVariant.id();
            break;
        }
        if (spawnData instanceof BlueprintRabbitVariants.BlueprintRabbitGroupData) {
            BlueprintRabbitVariants.BlueprintRabbitGroupData groupData = (BlueprintRabbitVariants.BlueprintRabbitGroupData)((Object)spawnData);
            id = groupData.variant;
        } else {
            spawnData = new BlueprintRabbitVariants.BlueprintRabbitGroupData(id);
        }
        this.getEntityData().set(Rabbit.DATA_TYPE_ID, (Object)id);
        cir.setReturnValue((Object)super.finalizeSpawn(level, difficulty, spawnType, spawnData));
    }
}

