/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public enum PlayableEndimationManager {
    INSTANCE;

    private final BiMap<ResourceLocation, PlayableEndimation> registry = HashBiMap.create();
    private final ObjectList<PlayableEndimation> byID = new ObjectArrayList(256);
    private final Object2IntMap<PlayableEndimation> toID = new Object2IntOpenHashMap();
    private int nextID;

    private PlayableEndimationManager() {
        this.toID.defaultReturnValue(-1);
        this.registerPlayableEndimation(PlayableEndimation.BLANK);
    }

    public PlayableEndimation registerPlayableEndimation(PlayableEndimation playableEndimation) {
        return this.registerPlayableEndimation(playableEndimation.location(), playableEndimation);
    }

    public synchronized PlayableEndimation registerPlayableEndimation(ResourceLocation key, PlayableEndimation playableEndimation) {
        BiMap<ResourceLocation, PlayableEndimation> registry = this.registry;
        if (registry.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicate key for Playable Endimation: " + String.valueOf(key));
        }
        registry.put((Object)key, (Object)playableEndimation);
        int nextID = this.nextID++;
        this.byID.size(Math.max(this.byID.size(), nextID + 1));
        this.byID.set(nextID, (Object)playableEndimation);
        this.toID.put((Object)playableEndimation, nextID);
        return playableEndimation;
    }

    @Nullable
    public PlayableEndimation getEndimation(ResourceLocation key) {
        return (PlayableEndimation)this.registry.get((Object)key);
    }

    @Nullable
    public ResourceLocation getKey(PlayableEndimation playableEndimation) {
        return (ResourceLocation)this.registry.inverse().get((Object)playableEndimation);
    }

    @Nullable
    public PlayableEndimation getEndimation(int id) {
        return (PlayableEndimation)this.byID.get(id);
    }

    public int getID(PlayableEndimation endimation) {
        return this.toID.getInt((Object)endimation);
    }
}

