/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public final class EndimationLoader
implements PreparableReloadListener {
    private static final JsonParser PARSER = new JsonParser();
    private final BiMap<ResourceLocation, Endimation> registry = HashBiMap.create();

    @Nullable
    public Endimation getEndimation(ResourceLocation key) {
        return (Endimation)this.registry.get((Object)key);
    }

    @Nullable
    public ResourceLocation getKey(Endimation endimation) {
        return (ResourceLocation)this.registry.inverse().get((Object)endimation);
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier barrier, ResourceManager manager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller2, Executor executor, Executor executor2) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, Endimation> endimations = new HashMap<ResourceLocation, Endimation>();
            for (Map.Entry entry : manager.listResources("endimations", location -> location.getPath().endsWith(".json")).entrySet()) {
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                    try {
                        DataResult dataResult = Endimation.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)PARSER.parse((Reader)reader));
                        Optional error = dataResult.error();
                        if (error.isPresent()) {
                            throw new JsonParseException(((DataResult.Error)error.get()).message());
                        }
                        ResourceLocation location2 = (ResourceLocation)entry.getKey();
                        String path = location2.getPath();
                        ResourceLocation adjustedLocation = ResourceLocation.fromNamespaceAndPath((String)location2.getNamespace(), (String)path.substring(12, path.length() - 5));
                        if (endimations.put(adjustedLocation, (Endimation)((Pair)dataResult.result().get()).getFirst()) == null) continue;
                        Blueprint.LOGGER.warn("Loaded Duplicate Endimation: {}", (Object)adjustedLocation);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception exception) {
                    Blueprint.LOGGER.error("Error while loading Endimation: {}", entry.getKey(), (Object)exception);
                }
            }
            return endimations;
        }, executor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0))).thenAcceptAsync(endimations -> {
            BiMap<ResourceLocation, Endimation> registry = this.registry;
            registry.clear();
            registry.putAll(endimations);
            registry.put((Object)PlayableEndimation.BLANK.location(), (Object)Endimation.BLANK);
            Blueprint.LOGGER.info("Endimation Loader has loaded {} endimations", (Object)registry.size());
        }, executor2);
    }
}

