/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.codec.NullableFieldCodec;
import com.teamabnormals.blueprint.core.endimator.EndimationKeyframe;
import com.teamabnormals.blueprint.core.endimator.KeyframeType;
import com.teamabnormals.blueprint.core.endimator.effects.ConfiguredEndimationEffect;
import com.teamabnormals.blueprint.core.util.DataUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;

public final class Endimation {
    public static final Endimation BLANK = Endimation.builder().build();
    private static final List<ConfiguredEndimationEffect<?, ?>> NO_EFFECTS = new ArrayList();
    public static final Codec<Endimation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("length").forGetter(endimation -> Optional.of(Float.valueOf(endimation.length))), (App)Codec.FLOAT.optionalFieldOf("blend_weight", (Object)Float.valueOf(1.0f)).forGetter(endimation -> Float.valueOf(endimation.blendWeight)), (App)KeyframesCodec.INSTANCE.fieldOf("parts").forGetter(endimation -> endimation.partKeyframes), (App)NullableFieldCodec.nullable("effects", ConfiguredEndimationEffect.CODEC.listOf(), NO_EFFECTS).forGetter(endimation -> Arrays.asList(endimation.effects))).apply((Applicative)instance, (length, blendWeight, keyframes, effects) -> {
        Object[] effectArray = effects.toArray(new ConfiguredEndimationEffect[0]);
        Arrays.sort(effectArray);
        float largestTime = 0.0f;
        if (length.isPresent()) {
            largestTime = ((Float)length.get()).floatValue();
        } else {
            float largestEffectTime;
            for (PartKeyframes partKeyframes : keyframes.values()) {
                for (KeyframeType keyframeType : KeyframeType.values()) {
                    float time;
                    EndimationKeyframe[] keyframeArray = keyframeType.getFrames(partKeyframes);
                    int arrayLength = keyframeArray.length;
                    if (arrayLength <= 0 || !((time = keyframeArray[arrayLength - 1].time) > largestTime)) continue;
                    largestTime = time;
                }
            }
            int effectsLength = effectArray.length;
            if (effectsLength > 0 && (largestEffectTime = ((ConfiguredEndimationEffect)effectArray[effectsLength - 1]).getTime()) > largestTime) {
                largestTime = largestEffectTime;
            }
        }
        return new Endimation(largestTime, blendWeight.floatValue(), (Object2ObjectArrayMap<String, PartKeyframes>)keyframes, (ConfiguredEndimationEffect<?, ?>[])effectArray);
    }));
    private final float length;
    private final float blendWeight;
    private final Object2ObjectArrayMap<String, PartKeyframes> partKeyframes;
    private final ConfiguredEndimationEffect<?, ?>[] effects;

    public Endimation(float length, float blendWeight, Object2ObjectArrayMap<String, PartKeyframes> partKeyframes, ConfiguredEndimationEffect<?, ?>[] effects) {
        this.length = length;
        this.blendWeight = blendWeight;
        this.partKeyframes = partKeyframes;
        this.effects = effects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public float getLength() {
        return this.length;
    }

    public float getBlendWeight() {
        return this.blendWeight;
    }

    public Object2ObjectArrayMap<String, PartKeyframes> getPartKeyframes() {
        return this.partKeyframes;
    }

    public ConfiguredEndimationEffect<?, ?>[] getEffects() {
        return this.effects;
    }

    public static class Builder {
        private Optional<Float> length = Optional.empty();
        private float blendWeight = 1.0f;
        private Object2ObjectArrayMap<String, PartKeyframes> keyframes = new Object2ObjectArrayMap();
        private ConfiguredEndimationEffect<?, ?>[] effects = new ConfiguredEndimationEffect[0];

        public Builder length(float length) {
            this.length = Optional.of(Float.valueOf(length));
            return this;
        }

        public Builder blendWeight(float blendWeight) {
            this.blendWeight = blendWeight;
            return this;
        }

        public Builder keyframes(Object2ObjectArrayMap<String, PartKeyframes> keyframes) {
            this.keyframes = keyframes;
            return this;
        }

        public Builder keyframes(Keyframes keyframes) {
            this.keyframes = keyframes.build();
            return this;
        }

        public Builder effects(ConfiguredEndimationEffect<?, ?>[] effects) {
            this.effects = effects;
            return this;
        }

        public Builder addEffects(ConfiguredEndimationEffect<?, ?> ... configuredEffects) {
            this.effects = DataUtil.concatArrays(this.effects, configuredEffects);
            return this;
        }

        public Endimation build() {
            Object[] effects = this.effects;
            Arrays.sort(effects);
            Optional<Float> length = this.length;
            float largestLength = 0.0f;
            if (length.isEmpty()) {
                float largestEffectTime;
                int effectsLength = effects.length;
                if (effectsLength > 0 && largestLength < (largestEffectTime = ((ConfiguredEndimationEffect)effects[effectsLength - 1]).getTime())) {
                    largestLength = largestEffectTime;
                }
                for (PartKeyframes partKeyframes : this.keyframes.values()) {
                    for (KeyframeType keyframeType : KeyframeType.values()) {
                        float time;
                        EndimationKeyframe[] keyframeArray = keyframeType.getFrames(partKeyframes);
                        int arrayLength = keyframeArray.length;
                        if (arrayLength <= 0 || !((time = keyframeArray[arrayLength - 1].time) > largestLength)) continue;
                        largestLength = time;
                    }
                }
            } else {
                largestLength = length.get().floatValue();
            }
            return new Endimation(largestLength, this.blendWeight, this.keyframes, this.effects);
        }

        public static final class Keyframes {
            private final Object2ObjectArrayMap<String, PartKeyframes> keyframes = new Object2ObjectArrayMap();

            private Keyframes() {
            }

            public static Keyframes keyframes() {
                return new Keyframes();
            }

            public Keyframes part(String part, PartKeyframes partFrames) {
                this.keyframes.put((Object)part, (Object)partFrames);
                return this;
            }

            public Keyframes part(String part, PartKeyframes.Builder partFrames) {
                this.keyframes.put((Object)part, (Object)partFrames.build());
                return this;
            }

            public Object2ObjectArrayMap<String, PartKeyframes> build() {
                return this.keyframes;
            }
        }
    }

    public static enum KeyframesCodec implements Codec<Object2ObjectArrayMap<String, PartKeyframes>>
    {
        INSTANCE;


        public <T> DataResult<Pair<Object2ObjectArrayMap<String, PartKeyframes>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult mapLikeDataResult = ops.getMap(input);
            Optional mapLikeDataResultError = mapLikeDataResult.error();
            if (mapLikeDataResultError.isPresent()) {
                return DataResult.error(() -> ((DataResult.Error)mapLikeDataResultError.get()).message());
            }
            MapLike mapLike = (MapLike)mapLikeDataResult.result().get();
            Iterator iterator = mapLike.entries().iterator();
            Object2ObjectArrayMap map = new Object2ObjectArrayMap();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                DataResult partResult = ops.getStringValue(pair.getFirst());
                Optional partResultError = partResult.error();
                if (partResultError.isEmpty()) {
                    String name = (String)partResult.result().get();
                    DataResult partKeyframesResult = PartKeyframes.CODEC.decode(ops, pair.getSecond());
                    Optional partKeyframesError = partKeyframesResult.error();
                    if (partKeyframesError.isEmpty()) {
                        map.put((Object)name, (Object)((PartKeyframes)((Pair)partKeyframesResult.result().get()).getFirst()));
                        continue;
                    }
                    return DataResult.error(() -> ((DataResult.Error)partKeyframesError.get()).message());
                }
                return DataResult.error(() -> ((DataResult.Error)partResultError.get()).message());
            }
            return DataResult.success((Object)Pair.of((Object)map, input));
        }

        public <T> DataResult<T> encode(Object2ObjectArrayMap<String, PartKeyframes> input, DynamicOps<T> ops, T prefix) {
            RecordBuilder keyframes = ops.mapBuilder();
            input.forEach((partName, partKeyframes) -> keyframes.add(partName, PartKeyframes.CODEC.encode(partKeyframes, ops, ops.empty())));
            return keyframes.build(prefix);
        }
    }

    public static final class PartKeyframes {
        private static final List<EndimationKeyframe> EMPTY = new ArrayList<EndimationKeyframe>(0);
        public static final Codec<PartKeyframes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NullableFieldCodec.nullable("position", EndimationKeyframe.CODEC.listOf(), EMPTY).forGetter(partKeyframes -> Arrays.asList(partKeyframes.position)), (App)NullableFieldCodec.nullable("rotation", EndimationKeyframe.CODEC.listOf(), EMPTY).forGetter(partKeyframes -> Arrays.asList(partKeyframes.rotation)), (App)NullableFieldCodec.nullable("offset", EndimationKeyframe.CODEC.listOf(), EMPTY).forGetter(partKeyframes -> Arrays.asList(partKeyframes.offset)), (App)NullableFieldCodec.nullable("scale", EndimationKeyframe.CODEC.listOf(), EMPTY).forGetter(partKeyframes -> Arrays.asList(partKeyframes.scale))).apply((Applicative)instance, (move, rotate, offset, scale) -> new PartKeyframes(PartKeyframes.convertAndSort(move), PartKeyframes.convertAndSort(rotate), PartKeyframes.convertAndSort(offset), PartKeyframes.convertAndSort(scale))));
        private final EndimationKeyframe[] position;
        private final EndimationKeyframe[] rotation;
        private final EndimationKeyframe[] offset;
        private final EndimationKeyframe[] scale;

        public PartKeyframes(EndimationKeyframe[] position, EndimationKeyframe[] rotation, EndimationKeyframe[] offset, EndimationKeyframe[] scale) {
            this.position = position;
            this.rotation = rotation;
            this.offset = offset;
            this.scale = scale;
        }

        private static EndimationKeyframe[] convertAndSort(List<EndimationKeyframe> frames) {
            Object[] array = frames.toArray(new EndimationKeyframe[0]);
            if (frames.size() > 1) {
                Arrays.sort(array);
            }
            return array;
        }

        public EndimationKeyframe[] getPosFrames() {
            return this.position;
        }

        public EndimationKeyframe[] getRotationFrames() {
            return this.rotation;
        }

        public EndimationKeyframe[] getOffsetFrames() {
            return this.offset;
        }

        public EndimationKeyframe[] getScaleFrames() {
            return this.scale;
        }

        public static final class Builder {
            private final TreeSet<EndimationKeyframe> pos = new TreeSet();
            private final TreeSet<EndimationKeyframe> rotate = new TreeSet();
            private final TreeSet<EndimationKeyframe> offset = new TreeSet();
            private final TreeSet<EndimationKeyframe> scale = new TreeSet();

            private Builder() {
            }

            public static Builder partKeyframes() {
                return new Builder();
            }

            public Builder pos(EndimationKeyframe ... endimationKeyframes) {
                TreeSet<EndimationKeyframe> pos = this.pos;
                pos.clear();
                Collections.addAll(pos, endimationKeyframes);
                return this;
            }

            public Builder rotate(EndimationKeyframe ... endimationKeyframes) {
                TreeSet<EndimationKeyframe> rotate = this.rotate;
                rotate.clear();
                Collections.addAll(rotate, endimationKeyframes);
                return this;
            }

            public Builder offset(EndimationKeyframe ... endimationKeyframes) {
                TreeSet<EndimationKeyframe> offset = this.offset;
                offset.clear();
                Collections.addAll(offset, endimationKeyframes);
                return this;
            }

            public Builder scale(EndimationKeyframe ... endimationKeyframes) {
                TreeSet<EndimationKeyframe> scale = this.scale;
                scale.clear();
                Collections.addAll(scale, endimationKeyframes);
                return this;
            }

            public PartKeyframes build() {
                return new PartKeyframes(this.pos.toArray(new EndimationKeyframe[0]), this.rotate.toArray(new EndimationKeyframe[0]), this.offset.toArray(new EndimationKeyframe[0]), this.scale.toArray(new EndimationKeyframe[0]));
            }
        }
    }

    public static enum EffectsCodec implements Codec<Int2ObjectOpenHashMap<ConfiguredEndimationEffect<?, ?>[]>>
    {
        INSTANCE;

        private static final Codec<List<ConfiguredEndimationEffect<?, ?>>> ARRAY_CODEC;

        public <T> DataResult<Pair<Int2ObjectOpenHashMap<ConfiguredEndimationEffect<?, ?>[]>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult mapLikeDataResult = ops.getMap(input);
            Optional mapLikeDataResultError = mapLikeDataResult.error();
            if (mapLikeDataResultError.isPresent()) {
                return DataResult.error(() -> ((DataResult.Error)mapLikeDataResultError.get()).message());
            }
            MapLike mapLike = (MapLike)mapLikeDataResult.result().get();
            Int2ObjectOpenHashMap effects = new Int2ObjectOpenHashMap((int)mapLike.entries().count());
            Iterator iterator = mapLike.entries().iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                DataResult tickResult = ops.getStringValue(pair.getFirst());
                Optional tickResultError = tickResult.error();
                if (tickResultError.isEmpty()) {
                    String tickString = (String)tickResult.result().get();
                    try {
                        int tick = Integer.parseInt(tickString);
                        DataResult configuredEffectsResult = ops.getList(pair.getSecond());
                        Optional configuredEffectsResultError = configuredEffectsResult.error();
                        if (configuredEffectsResultError.isEmpty()) {
                            ArrayList configuredEndimationEffectsRaw = new ArrayList();
                            ((Consumer)configuredEffectsResult.result().get()).accept(configuredEndimationEffectsRaw::add);
                            ArrayList<ConfiguredEndimationEffect> configuredEndimationEffects = new ArrayList<ConfiguredEndimationEffect>(configuredEndimationEffectsRaw.size());
                            for (Object effectRaw : configuredEndimationEffectsRaw) {
                                DataResult configuredResult = ConfiguredEndimationEffect.CODEC.decode(ops, effectRaw);
                                Optional configuredResultError = configuredResult.error();
                                if (configuredResultError.isPresent()) {
                                    return DataResult.error(() -> ((DataResult.Error)configuredResultError.get()).message());
                                }
                                configuredEndimationEffects.add((ConfiguredEndimationEffect)((Pair)configuredResult.result().get()).getFirst());
                            }
                            effects.put(tick, (Object)configuredEndimationEffects.toArray(new ConfiguredEndimationEffect[0]));
                            continue;
                        }
                        return DataResult.error(() -> ((DataResult.Error)configuredEffectsResultError.get()).message());
                    }
                    catch (NumberFormatException exception) {
                        return DataResult.error(() -> "Failed to convert effect tick " + tickString + " to an integer!");
                    }
                }
                return DataResult.error(() -> ((DataResult.Error)tickResultError.get()).message());
            }
            return DataResult.success((Object)Pair.of((Object)effects, input));
        }

        public <T> DataResult<T> encode(Int2ObjectOpenHashMap<ConfiguredEndimationEffect<?, ?>[]> input, DynamicOps<T> ops, T prefix) {
            RecordBuilder effects = ops.mapBuilder();
            input.forEach((tick, configuredEndimationEffects) -> effects.add(String.valueOf(tick), ARRAY_CODEC.encode(Arrays.asList(configuredEndimationEffects), ops, ops.empty())));
            return effects.build(prefix);
        }

        static {
            ARRAY_CODEC = ConfiguredEndimationEffect.CODEC.listOf();
        }
    }
}

