/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.data.server;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;

public class BlueprintRecipeProvider
extends RecipeProvider {
    private final String modid;

    public BlueprintRecipeProvider(String modid, PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
        this.modid = modid;
    }

    public void buildRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Blocks.CAKE).define(Character.valueOf('A'), Tags.Items.DRINKS_MILK).define(Character.valueOf('B'), (ItemLike)Items.SUGAR).define(Character.valueOf('C'), (ItemLike)Items.WHEAT).define(Character.valueOf('E'), Tags.Items.EGGS).pattern("AAA").pattern("BEB").pattern("CCC").unlockedBy("has_egg", BlueprintRecipeProvider.has((TagKey)Tags.Items.EGGS)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.PUMPKIN_PIE).requires(Tags.Items.PUMPKINS_NORMAL).requires((ItemLike)Items.SUGAR).requires(Tags.Items.EGGS).unlockedBy("has_pumpkin", BlueprintRecipeProvider.has((TagKey)Tags.Items.PUMPKINS)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.PUMPKIN_SEEDS, (int)4).requires(Tags.Items.PUMPKINS_NORMAL).unlockedBy("has_pumpkin", BlueprintRecipeProvider.has((TagKey)Tags.Items.PUMPKINS)).save(output);
    }

    public static void foodCookingRecipes(RecipeOutput recipeOutput, ItemLike input, ItemLike output) {
        BlueprintRecipeProvider.foodCookingRecipes(recipeOutput, input, output, 0.35f, 200);
    }

    public static void foodCookingRecipes(RecipeOutput recipeOutput, ItemLike input, ItemLike output, float xp, int baseCookTime) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)xp, (int)baseCookTime).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)input), BlueprintRecipeProvider.has((ItemLike)input)).save(recipeOutput);
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)xp, (int)(baseCookTime / 2)).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)input), BlueprintRecipeProvider.has((ItemLike)input)).save(recipeOutput, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)output)) + "_from_smoking");
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)xp, (int)(baseCookTime * 3)).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)input), BlueprintRecipeProvider.has((ItemLike)input)).save(recipeOutput, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)output)) + "_from_campfire_cooking");
    }

    public void oreRecipes(RecipeOutput recipeOutput, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float smeltingXp, int smeltingTime, String group) {
        this.oreRecipes(recipeOutput, inputs, category, output, smeltingXp, smeltingTime, smeltingXp, smeltingTime / 2, group);
    }

    public void oreRecipes(RecipeOutput recipeOutput, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float smeltingXp, int smeltingTime, float blastingXp, int blastingTime, String group) {
        this.smeltingRecipe(recipeOutput, inputs, category, output, smeltingXp, smeltingTime, group);
        this.blastingRecipe(recipeOutput, inputs, category, output, blastingXp, blastingTime, group);
    }

    public void smeltingRecipe(RecipeOutput recipeOutput, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float xp, int cookTime, String group) {
        for (ItemLike item : inputs) {
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item}), (RecipeCategory)category, (ItemLike)output, (float)xp, (int)cookTime).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)item), BlueprintRecipeProvider.has((ItemLike)item)).group(group).save(recipeOutput);
        }
    }

    public void blastingRecipe(RecipeOutput recipeOutput, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float xp, int cookTime, String group) {
        for (ItemLike item : inputs) {
            SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item}), (RecipeCategory)category, (ItemLike)output, (float)xp, (int)cookTime).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)item), BlueprintRecipeProvider.has((ItemLike)item)).group(group).save(recipeOutput);
        }
    }

    public void leafPileRecipes(RecipeOutput output, ItemLike leaves, ItemLike leafPile) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)leafPile, (int)4).requires(leaves).group("leaf_pile").unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)leaves), BlueprintRecipeProvider.has((ItemLike)leaves)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)leaves).define(Character.valueOf('#'), leafPile).pattern("##").pattern("##").group("leaves").unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)leafPile), BlueprintRecipeProvider.has((ItemLike)leafPile)).save(output, this.getModConversionRecipeName(leaves, leafPile));
    }

    public void stonecutterRecipe(RecipeOutput recipeOutput, RecipeCategory category, ItemLike output, ItemLike input) {
        this.stonecutterRecipe(recipeOutput, category, output, input, 1);
    }

    public void stonecutterRecipe(RecipeOutput recipeOutput, RecipeCategory category, ItemLike output, ItemLike input, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)output, (int)count).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)input), BlueprintRecipeProvider.has((ItemLike)input)).save(recipeOutput, String.valueOf(this.getModConversionRecipeName(output, input)) + "_stonecutting");
    }

    public void conversionRecipe(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        this.conversionRecipe(recipeOutput, output, input, null);
    }

    public void conversionRecipe(RecipeOutput recipeOutput, ItemLike output, ItemLike input, @Nullable String group) {
        this.conversionRecipe(recipeOutput, output, input, group, 1);
    }

    public void conversionRecipe(RecipeOutput recipeOutput, ItemLike output, ItemLike input, @Nullable String group, int count) {
        BlueprintRecipeProvider.conversionRecipeBuilder(output, input, count).group(group).save(recipeOutput, this.getModConversionRecipeName(output, input));
    }

    public static ShapelessRecipeBuilder conversionRecipeBuilder(ItemLike output, ItemLike input, int count) {
        return BlueprintRecipeProvider.conversionRecipeBuilder(RecipeCategory.MISC, output, input, count);
    }

    public static ShapelessRecipeBuilder conversionRecipeBuilder(RecipeCategory category, ItemLike output, ItemLike input, int count) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)output, (int)count).requires(input).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)input), BlueprintRecipeProvider.has((ItemLike)input));
    }

    public void storageRecipes(RecipeOutput output, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String storageName, String storageGroup, String itemName, String itemGroup) {
        BlueprintRecipeProvider.nineBlockStorageRecipes((RecipeOutput)output, (RecipeCategory)itemCategory, (ItemLike)item, (RecipeCategory)storageCategory, (ItemLike)storage, (String)(this.modid + ":" + storageName), (String)storageGroup, (String)(this.modid + ":" + itemName), (String)itemGroup);
    }

    public void storageRecipes(RecipeOutput output, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage) {
        this.storageRecipes(output, itemCategory, item, storageCategory, storage, BlueprintRecipeProvider.getSimpleRecipeName((ItemLike)storage), null, BlueprintRecipeProvider.getSimpleRecipeName((ItemLike)item), null);
    }

    public void storageRecipesWithCustomPacking(RecipeOutput output, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String storageName, String storageGroup) {
        this.storageRecipes(output, itemCategory, item, storageCategory, storage, storageName, storageGroup, BlueprintRecipeProvider.getSimpleRecipeName((ItemLike)item), null);
    }

    public void storageRecipesWithCustomUnpacking(RecipeOutput output, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String itemName, String itemGroup) {
        this.storageRecipes(output, itemCategory, item, storageCategory, storage, BlueprintRecipeProvider.getSimpleRecipeName((ItemLike)storage), null, itemName, itemGroup);
    }

    public void conditionalStorageRecipes(RecipeOutput output, ICondition condition, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage) {
        this.conditionalStorageRecipes(output, condition, itemCategory, item, storageCategory, storage, BlueprintRecipeProvider.getSimpleRecipeName((ItemLike)storage), null, BlueprintRecipeProvider.getSimpleRecipeName((ItemLike)item), null);
    }

    public void conditionalStorageRecipes(RecipeOutput output, ICondition condition, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String storageLocation, @Nullable String itemGroup, String itemLocation, @Nullable String storageGroup) {
        BlueprintRecipeProvider.conditionalRecipe(output, (RecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)itemCategory, (ItemLike)item, (int)9).requires(storage).group(storageGroup).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)storage), BlueprintRecipeProvider.has((ItemLike)storage)), ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)itemLocation), condition);
        BlueprintRecipeProvider.conditionalRecipe(output, (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)storageCategory, (ItemLike)storage).define(Character.valueOf('#'), item).pattern("###").pattern("###").pattern("###").group(itemGroup).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)item), BlueprintRecipeProvider.has((ItemLike)item)), ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)storageLocation), condition);
    }

    public void conditionalStorageRecipesWithCustomUnpacking(RecipeOutput output, ICondition condition, RecipeCategory itemCategory, ItemLike item, RecipeCategory storageCategory, ItemLike storage, String shapelessName, String shapelessGroup) {
        this.conditionalStorageRecipes(output, condition, itemCategory, item, storageCategory, storage, BlueprintRecipeProvider.getSimpleRecipeName((ItemLike)storage), null, shapelessName, shapelessGroup);
    }

    public static void conditionalRecipe(RecipeOutput output, RecipeBuilder recipe, ICondition ... conditions) {
        recipe.save(output.withConditions(conditions));
    }

    public static void conditionalRecipe(RecipeOutput output, RecipeBuilder recipe, ResourceLocation id, ICondition ... conditions) {
        recipe.save(output.withConditions(conditions), id);
    }

    public void waxRecipe(RecipeOutput output, RecipeCategory category, ItemLike input, ItemLike result) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result).requires(input).requires((ItemLike)Items.HONEYCOMB).group(BlueprintRecipeProvider.getItemName((ItemLike)result)).unlockedBy(BlueprintRecipeProvider.getHasName((ItemLike)input), BlueprintRecipeProvider.has((ItemLike)input)).save(output, this.getModConversionRecipeName(result, (ItemLike)Items.HONEYCOMB));
    }

    public void netheriteSmithingRecipe(RecipeOutput recipeOutput, Item input, RecipeCategory category, Item output) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), (RecipeCategory)category, (Item)output).unlocks("has_netherite_ingot", BlueprintRecipeProvider.has((ItemLike)Items.NETHERITE_INGOT)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)(BlueprintRecipeProvider.getItemName((ItemLike)output) + "_smithing")));
    }

    public static void trimSmithing(RecipeOutput output, ItemLike item) {
        SmithingTrimRecipeBuilder.smithingTrim((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item}), (Ingredient)Ingredient.of((TagKey)ItemTags.TRIMMABLE_ARMOR), (Ingredient)Ingredient.of((TagKey)ItemTags.TRIM_MATERIALS), (RecipeCategory)RecipeCategory.MISC).unlocks("has_smithing_trim_template", BlueprintRecipeProvider.has((ItemLike)item)).save(output, BlueprintRecipeProvider.suffix(RecipeBuilder.getDefaultRecipeId((ItemLike)item), "_smithing_trim"));
    }

    public static void trimRecipes(RecipeOutput output, ItemLike item, TagKey<Item> copyItem) {
        BlueprintRecipeProvider.trimSmithing(output, item);
        BlueprintRecipeProvider.copySmithingTemplate((RecipeOutput)output, (ItemLike)item, copyItem);
    }

    public static void trimRecipes(RecipeOutput output, ItemLike item, ItemLike copyItem) {
        BlueprintRecipeProvider.trimSmithing(output, item);
        BlueprintRecipeProvider.copySmithingTemplate((RecipeOutput)output, (ItemLike)item, (ItemLike)copyItem);
    }

    public static void generateRecipes(RecipeOutput output, BlockFamily family) {
        BlueprintRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)family, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
    }

    public static ResourceLocation suffix(ResourceLocation rl, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath() + suffix));
    }

    public ResourceLocation getModConversionRecipeName(ItemLike output, ItemLike input) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BlueprintRecipeProvider.getConversionRecipeName((ItemLike)output, (ItemLike)input));
    }

    public String getModID() {
        return this.modid;
    }
}

