/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.data.server;

import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSlice;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.registry.BlueprintBiomes;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.util.BiomeUtil;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;

public final class BlueprintDatapackBuiltinEntriesProvider
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.BIOME, BlueprintDatapackBuiltinEntriesProvider::bootstrapBiomes).add(BlueprintDataPackRegistries.MODDED_BIOME_SLICES, BlueprintDatapackBuiltinEntriesProvider::bootstrapSlices);

    public BlueprintDatapackBuiltinEntriesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider, BUILDER, Set.of("blueprint"));
    }

    public static void bootstrapBiomes(BootstrapContext<Biome> context) {
        HolderGetter placedFeatureHolderGetter = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter configuredWorldCarverHolderGetter = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(BlueprintBiomes.ORIGINAL_SOURCE_MARKER, (Object)OverworldBiomes.theVoid((HolderGetter)placedFeatureHolderGetter, (HolderGetter)configuredWorldCarverHolderGetter));
    }

    private static void bootstrapSlices(BootstrapContext<ModdedBiomeSlice> context) {
        ResourceKey originalsKey = ResourceKey.create(BlueprintDataPackRegistries.MODDED_BIOME_SLICES, (ResourceLocation)Blueprint.location("originals"));
        context.register(originalsKey, (Object)new ModdedBiomeSlice(100, BiomeUtil.OriginalModdedBiomeProvider.INSTANCE, LevelStem.OVERWORLD, LevelStem.NETHER, LevelStem.END));
    }
}

