/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.data.client;

import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class BlueprintItemModelProvider
extends ItemModelProvider {
    public BlueprintItemModelProvider(PackOutput output, String modid, ExistingFileHelper helper) {
        super(output, modid, helper);
    }

    public ItemModelBuilder item(DeferredHolder<? extends ItemLike, ?> item, String type) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BlueprintItemModelProvider.name((ItemLike)item.get()), "item/" + type)).texture("layer0", BlueprintItemModelProvider.itemTexture((ItemLike)item.get()));
    }

    public ItemModelBuilder item(DeferredHolder<? extends ItemLike, ?> item, String path, String type) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BlueprintItemModelProvider.name((ItemLike)item.get()), "item/" + type)).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("item/" + path)));
    }

    public ItemModelBuilder item(ResourceLocation location, String type) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(location.getPath(), "item/" + type)).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("item/" + location.getPath())));
    }

    public ItemModelBuilder blockItem(DeferredHolder<Block, ?> block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BlueprintBlockStateProvider.name((Block)block.get()))).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("block/" + BlueprintBlockStateProvider.name((Block)block.get())))));
    }

    @SafeVarargs
    public final void generatedItem(DeferredHolder<? extends ItemLike, ?> ... items) {
        for (DeferredHolder<? extends ItemLike, ?> item : items) {
            this.item(item, "generated");
        }
    }

    @SafeVarargs
    public final void handheldItem(DeferredHolder<? extends ItemLike, ?> ... items) {
        for (DeferredHolder<? extends ItemLike, ?> item : items) {
            this.item(item, "handheld");
        }
    }

    @SafeVarargs
    public final void spawnEggItem(DeferredHolder<? extends ItemLike, ?> ... items) {
        for (DeferredHolder<? extends ItemLike, ?> item : items) {
            this.withExistingParent(BlueprintItemModelProvider.name((ItemLike)item.get()), "item/template_spawn_egg");
        }
    }

    public void animatedItem(DeferredHolder<? extends ItemLike, ?> item, int count) {
        for (int i = 0; i < count; ++i) {
            String path = BlueprintItemModelProvider.name((ItemLike)item.get()) + "_" + String.format("%02d", i);
            ((ItemModelBuilder)this.withExistingParent(path, "item/generated")).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("item/" + path)));
        }
    }

    @SafeVarargs
    public final void trimmableArmorItem(DeferredHolder<? extends ItemLike, ?> ... items) {
        for (DeferredHolder<? extends ItemLike, ?> item : items) {
            Item item2 = ((ItemLike)item.get()).asItem();
            if (!(item2 instanceof ArmorItem)) continue;
            ArmorItem armor = (ArmorItem)item2;
            ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)armor);
            ItemModelBuilder itemModel = this.item(item, "generated");
            int trimType = 1;
            for (String trim : new String[]{"quartz", "iron", "netherite", "redstone", "copper", "gold", "emerald", "diamond", "lapis", "amethyst"}) {
                ResourceLocation name = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("item/" + location.getPath() + "_" + trim + "_trim"));
                itemModel.override().model((ModelFile)new ModelFile.UncheckedModelFile(name)).predicate(ResourceLocation.withDefaultNamespace((String)"trim_type"), (float)((double)trimType / 10.0));
                ResourceLocation texture = ResourceLocation.withDefaultNamespace((String)("trims/items/" + armor.getType().getName() + "_trim_" + trim));
                this.existingFileHelper.trackGenerated(texture, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name.getPath(), "item/generated")).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("item/" + location.getPath())))).texture("layer1", texture);
                ++trimType;
            }
        }
    }

    public static ResourceLocation key(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem());
    }

    public static String name(ItemLike item) {
        return BlueprintItemModelProvider.key(item).getPath();
    }

    public static ResourceLocation itemTexture(ItemLike item) {
        ResourceLocation name = BlueprintItemModelProvider.key(item);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("item/" + name.getPath()));
    }
}

